/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math.polynomial;

import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.polynomial.Quadratic;

public abstract class BasisMatrixQuadratic
implements Quadratic {
    private Matrix3x3 m_h;
    protected Vector3 m_g;

    protected BasisMatrixQuadratic(Matrix3x3 h, Vector3 g) {
        this.m_h = h;
        this.m_g = g;
    }

    public boolean isNaN() {
        return this.m_h == null || this.m_h.isNaN() || this.m_g == null || this.m_g.isNaN();
    }

    public double evaluate(double t) {
        double tt = t * t;
        return (tt * this.m_h.right.x + t * this.m_h.right.y + this.m_h.right.z) * this.m_g.x + (tt * this.m_h.up.x + t * this.m_h.up.y + this.m_h.up.z) * this.m_g.y + (tt * this.m_h.backward.x + t * this.m_h.backward.y + this.m_h.backward.z) * this.m_g.z;
    }

    public double evaluateDerivative(double t) {
        double t2 = t * 2.0;
        return (t2 * this.m_h.right.x + this.m_h.right.y) * this.m_g.x + (t2 * this.m_h.up.x + this.m_h.up.y) * this.m_g.y + (t2 * this.m_h.backward.x + this.m_h.backward.y) * this.m_g.z;
    }
}

