/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math.rigidbody;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.rigidbody.TranslationAndOrientationDerivative;
import edu.cmu.cs.dennisc.math.rigidbody.TranslationFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TranslationAndOrientationFunction
extends TranslationFunction<TranslationAndOrientationDerivative> {
    private UnitQuaternion m_orientation = UnitQuaternion.createNaN();
    private Vector3 m_angularMomentum = new Vector3();
    private UnitQuaternion m_spin = UnitQuaternion.createNaN();
    private Vector3 m_angularVelocity = new Vector3();
    private double m_inertiaTensor = 0.16666666666666666;
    private double m_inverseInertiaTensor = 6.0;

    public UnitQuaternion accessOrientation() {
        return this.m_orientation;
    }

    public UnitQuaternion getOrientation(UnitQuaternion rv) {
        rv.setValue(this.m_orientation);
        return rv;
    }

    public UnitQuaternion getOrientation() {
        return this.getOrientation(UnitQuaternion.createNaN());
    }

    public void setOrientation(UnitQuaternion orientation) {
        this.m_orientation.setValue(orientation);
    }

    public void setOrientation(double x, double y, double z, double w) {
        this.m_orientation.set(x, y, z, w);
    }

    public Vector3 accessAngularMomentum() {
        return this.m_angularMomentum;
    }

    public Vector3 getAngularMomentum(Vector3 rv) {
        rv.set(this.m_angularMomentum);
        return rv;
    }

    public Vector3 getAngularMomentum() {
        return this.getAngularMomentum(new Vector3());
    }

    public void setAngularMomentum(Vector3 angularMomentum) {
        this.m_angularMomentum.set(angularMomentum);
    }

    public void setAngularMomentum(double x, double y, double z) {
        this.m_angularMomentum.set(x, y, z);
    }

    public UnitQuaternion accessSpin() {
        return this.m_spin;
    }

    public UnitQuaternion getSpin(UnitQuaternion rv) {
        rv.setValue(this.m_spin);
        return rv;
    }

    public UnitQuaternion getSpin() {
        return this.getSpin(UnitQuaternion.createNaN());
    }

    public void setSpin(UnitQuaternion spin) {
        this.m_spin.setValue(spin);
    }

    public void setSpin(double w, double x, double y, double z) {
        this.m_spin.set(w, x, y, z);
    }

    public Vector3 accessAngularVelocity() {
        return this.m_angularVelocity;
    }

    public Vector3 getAngularVelocity(Vector3 rv) {
        rv.set(this.m_angularVelocity);
        return rv;
    }

    public Vector3 getAngularVelocity() {
        return this.getAngularVelocity(new Vector3());
    }

    public void setAngularVelocity(Vector3 angularVelocity) {
        this.m_angularVelocity.set(angularVelocity);
    }

    public void setAngularVelocity(double x, double y, double z) {
        this.m_angularVelocity.set(x, y, z);
    }

    public double getInertiaTensor() {
        return this.m_inertiaTensor;
    }

    public void setInertiaTensor(double inertiaTensor) {
        this.m_inertiaTensor = inertiaTensor;
        this.m_inverseInertiaTensor = 1.0 / this.m_inertiaTensor;
    }

    public AffineMatrix4x4 getTransformation(AffineMatrix4x4 rv) {
        rv.set(this.m_orientation, this.accessTranslation());
        return rv;
    }

    public AffineMatrix4x4 getTransformation() {
        return this.getTransformation(AffineMatrix4x4.createNaN());
    }

    public void setTransformation(AffineMatrix4x4 transformation) {
        this.accessTranslation().set(transformation.translation);
        this.m_orientation.setValue(transformation.orientation);
    }

    protected abstract Vector3 getTorque(Vector3 var1, double var2);

    @Override
    protected TranslationAndOrientationDerivative newDerivative() {
        return new TranslationAndOrientationDerivative();
    }

    @Override
    protected TranslationAndOrientationDerivative evaluate(TranslationAndOrientationDerivative rv, double t) {
        rv.spin.setValue(this.m_spin);
        this.getTorque(rv.torque, t);
        return super.evaluate(rv, t);
    }

    @Override
    protected void update(double t, double dt, TranslationAndOrientationDerivative derivative) {
        super.update(t, dt, derivative);
        this.m_orientation.add(UnitQuaternion.createMultiplication(derivative.spin, dt));
        this.m_orientation.normalize();
        this.m_angularMomentum.add(Vector3.createMultiplication((Tuple3)derivative.torque, dt));
    }

    @Override
    protected TranslationAndOrientationDerivative evaluate(TranslationAndOrientationDerivative rv, double t, double dt, TranslationAndOrientationDerivative positionDerivative) {
        return super.evaluate(rv, t, dt, positionDerivative);
    }

    @Override
    public void update(TranslationAndOrientationDerivative a, TranslationAndOrientationDerivative b, TranslationAndOrientationDerivative c, TranslationAndOrientationDerivative d, double dt) {
        super.update(a, b, c, d, dt);
        this.m_orientation.add(UnitQuaternion.createMultiplication(UnitQuaternion.createAddition(a.spin, UnitQuaternion.createAddition(UnitQuaternion.createMultiplication(UnitQuaternion.createAddition(b.spin, c.spin), 2.0), d.spin)), dt / 6.0));
        this.m_orientation.normalize();
        this.m_angularMomentum.add(Vector3.createMultiplication((Tuple3)Vector3.createAddition(a.torque, Vector3.createAddition(Vector3.createMultiplication((Tuple3)Vector3.createAddition(b.torque, c.torque), 2.0), d.torque)), dt / 6.0));
    }

    @Override
    public void update() {
        super.update();
        this.m_angularVelocity.setToMultiplication((Tuple3)this.m_angularMomentum, this.m_inverseInertiaTensor);
        this.m_spin.setToMultiplication(UnitQuaternion.createMultiplication(new UnitQuaternion(0.0, this.m_angularVelocity.x, this.m_angularVelocity.y, this.m_angularVelocity.z), this.m_orientation), 0.5);
    }
}

