/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math.rigidbody;

import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.rigidbody.TranslationDerivative;
import edu.cmu.cs.dennisc.math.rungekutta.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TranslationFunction<E extends TranslationDerivative>
implements Function<E> {
    private Point3 m_translation = new Point3();
    private Vector3 m_momentum = new Vector3();
    private Vector3 m_velocity = new Vector3();
    private double m_mass = 1.0;
    private double m_inverseMass = 1.0;

    public Point3 accessTranslation() {
        return this.m_translation;
    }

    public Point3 getTranslation(Point3 rv) {
        rv.set(this.m_translation);
        return rv;
    }

    public Point3 getTranslation() {
        return this.getTranslation(new Point3());
    }

    public void setTranslation(Point3 translation) {
        this.m_translation.set(translation);
    }

    public void setTranslation(double x, double y, double z) {
        this.m_translation.set(x, y, z);
    }

    public Vector3 accessMomentum() {
        return this.m_momentum;
    }

    public Vector3 getMomentum(Vector3 rv) {
        rv.set(this.m_momentum);
        return rv;
    }

    public Vector3 getMomentum() {
        return this.getMomentum(new Vector3());
    }

    public void setMomentum(Vector3 momentum) {
        this.m_momentum.set(momentum);
    }

    public void setMomentum(double x, double y, double z) {
        this.m_momentum.set(x, y, z);
    }

    public Vector3 accessVelocity() {
        return this.m_velocity;
    }

    public Vector3 getVelocity(Vector3 rv) {
        rv.set(this.m_velocity);
        return rv;
    }

    public Vector3 getVelocity() {
        return this.getVelocity(new Vector3());
    }

    public void setVelocity(Vector3 velocity) {
        this.m_velocity.set(velocity);
    }

    public void setVelocity(double x, double y, double z) {
        this.m_velocity.set(x, y, z);
    }

    public double getMass() {
        return this.m_mass;
    }

    public void setMass(double mass) {
        this.m_mass = mass;
        this.m_inverseMass = 1.0 / this.m_mass;
    }

    protected abstract Vector3 getForce(Vector3 var1, double var2);

    protected E newDerivative() {
        return (E)new TranslationDerivative();
    }

    protected E evaluate(E rv, double t) {
        ((TranslationDerivative)rv).velocity.set(this.m_velocity);
        this.getForce(((TranslationDerivative)rv).force, t);
        return rv;
    }

    protected void update(double t, double dt, E derivative) {
        this.m_translation.add(Vector3.createMultiplication((Tuple3)((TranslationDerivative)derivative).velocity, dt));
        this.m_momentum.add(Vector3.createMultiplication((Tuple3)((TranslationDerivative)derivative).force, dt));
    }

    protected E evaluate(E rv, double t, double dt, E derivative) {
        try {
            TranslationFunction pf = (TranslationFunction)this.clone();
            pf.update(t, dt, derivative);
            pf.update();
            return (E)pf.evaluate(t + dt);
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    @Override
    public final E evaluate(double t) {
        return this.evaluate(this.newDerivative(), t);
    }

    @Override
    public final E evaluate(double t, double dt, E derivative) {
        return this.evaluate(this.newDerivative(), t, dt, derivative);
    }

    @Override
    public void update(E a, E b, E c, E d, double dt) {
        this.m_translation.add(Vector3.createMultiplication((Tuple3)Vector3.createAddition(((TranslationDerivative)a).velocity, Vector3.createAddition(Vector3.createMultiplication((Tuple3)Vector3.createAddition(((TranslationDerivative)b).velocity, ((TranslationDerivative)c).velocity), 2.0), ((TranslationDerivative)d).velocity)), dt / 6.0));
        this.m_momentum.add(Vector3.createMultiplication((Tuple3)Vector3.createAddition(((TranslationDerivative)a).force, Vector3.createAddition(Vector3.createMultiplication((Tuple3)Vector3.createAddition(((TranslationDerivative)b).force, ((TranslationDerivative)c).force), 2.0), ((TranslationDerivative)d).force)), dt / 6.0));
    }

    @Override
    public void update() {
        Vector3.setReturnValueToMultiplication((Tuple3)this.m_velocity, (Tuple3)this.m_momentum, this.m_inverseMass);
    }
}

