/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.media.jmf;

import com.sun.media.codec.audio.mp3.JavaDecoder;
import edu.cmu.cs.dennisc.javax.media.protocol.ByteArrayDataSource;
import edu.cmu.cs.dennisc.javax.media.renderer.audio.FixedJavaSoundRenderer;
import edu.cmu.cs.dennisc.media.jmf.Player;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.media.CannotRealizeException;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.protocol.DataSource;
import org.alice.virtualmachine.event.ResourceContentEvent;
import org.alice.virtualmachine.event.ResourceContentListener;
import org.alice.virtualmachine.resources.AudioResource;

public class MediaFactory
extends edu.cmu.cs.dennisc.media.MediaFactory {
    private Map<AudioResource, DataSource> audioResourceToDataSourceMap = new HashMap<AudioResource, DataSource>();
    private ResourceContentListener resourceContentListener = new ResourceContentListener(){

        public void contentChanging(ResourceContentEvent e) {
        }

        public void contentChanged(ResourceContentEvent e) {
            MediaFactory.this.forget((AudioResource)e.getTypedSource());
        }
    };
    private static MediaFactory singleton;

    public static MediaFactory getSingleton() {
        return singleton;
    }

    private MediaFactory() {
    }

    private void forget(AudioResource audioResource) {
        this.audioResourceToDataSourceMap.remove(audioResource);
        audioResource.removeContentListener(this.resourceContentListener);
    }

    public AudioResource createAudioResource(File file) throws IOException {
        String contentType = AudioResource.getContentType(file);
        if (contentType != null) {
            final AudioResource rv = new AudioResource(file, contentType);
            Runnable runnable = new Runnable(){

                public void run() {
                    Player player = new Player(MediaFactory.this.createJMFPlayer(rv), 1.0, 0.0, Double.NaN);
                    player.realize();
                    rv.setDuration(player.getDuration());
                }
            };
            boolean USE_THREAD_JUST_TO_BE_SORT_OF_SAFE = true;
            new Thread(runnable).start();
            return rv;
        }
        throw new RuntimeException("content type not found for " + file);
    }

    private javax.media.Player createJMFPlayer(AudioResource audioResource) {
        assert (audioResource != null);
        Object dataSource = this.audioResourceToDataSourceMap.get(audioResource);
        if (dataSource == null) {
            dataSource = new ByteArrayDataSource(audioResource.getData(), audioResource.getContentType());
            audioResource.addContentListener(this.resourceContentListener);
            this.audioResourceToDataSourceMap.put(audioResource, (DataSource)dataSource);
        }
        try {
            PrintUtilities.println("MediaFactory.acquirePlayer", audioResource);
            return Manager.createRealizedPlayer((DataSource)dataSource);
        }
        catch (CannotRealizeException cre) {
            throw new RuntimeException(audioResource.toString(), cre);
        }
        catch (NoPlayerException npe) {
            throw new RuntimeException(audioResource.toString(), npe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(audioResource.toString(), ioe);
        }
    }

    public Player createPlayer(AudioResource audioResource, double volume, double startTime, double stopTime) {
        Player player = new Player(this.createJMFPlayer(audioResource), volume, startTime, stopTime);
        if (Double.isNaN(audioResource.getDuration())) {
            player.realize();
            audioResource.setDuration(player.getDuration());
        }
        return player;
    }

    static {
        System.out.print("Attempting to register mp3 capability... ");
        JavaDecoder.main((String[])new String[0]);
        FixedJavaSoundRenderer.usurpControlFromJavaSoundRenderer();
        singleton = new MediaFactory();
    }
}

