/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.movie.seriesofimages;

import edu.cmu.cs.dennisc.image.ImageUtilities;
import edu.cmu.cs.dennisc.movie.MovieEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class SeriesOfImagesMovieEncoder
implements MovieEncoder {
    private String m_directoryPath;
    private String m_fileName;
    private NumberFormat m_numberFormat;
    private String m_extension;
    private int m_index;

    public SeriesOfImagesMovieEncoder(String directoryPath, String fileName, String localizedPattern, String extension) {
        this.m_directoryPath = directoryPath;
        this.m_fileName = fileName;
        this.m_numberFormat = NumberFormat.getInstance();
        if (this.m_numberFormat instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)this.m_numberFormat;
            df.applyLocalizedPattern(localizedPattern);
        }
        this.m_extension = extension;
        this.m_index = -1;
    }

    private void getPathForIndex(StringBuffer sb, int index) {
        sb.append(this.m_directoryPath);
        sb.append(File.separatorChar);
        sb.append(this.m_fileName);
        sb.append(this.m_numberFormat.format(index));
        sb.append(".");
        sb.append(this.m_extension);
    }

    public String getPathForIndex(int index) {
        StringBuffer sb = new StringBuffer();
        this.getPathForIndex(sb, index);
        return sb.toString();
    }

    public void start() {
        this.m_index = 0;
    }

    public void addBufferedImage(BufferedImage bufferedImage) {
        assert (this.m_index != -1);
        String path = this.getPathForIndex(this.m_index++);
        File file = new File(path);
        file.getParentFile().mkdirs();
        ImageUtilities.write(path, (Image)bufferedImage);
    }

    public void stop() {
        this.m_index = -1;
    }
}

