/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.preference;

import edu.cmu.cs.dennisc.lang.SystemUtilities;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.preference.Preference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionOfPreferences {
    private Preferences utilPrefs;
    private Preference<?>[] preferences;

    public void initialize() {
        assert (this.preferences == null);
        assert (this.utilPrefs == null);
        this.utilPrefs = Preferences.userNodeForPackage(this.getClass());
        if (SystemUtilities.isPropertyTrue("org.alice.clearAllPreferences")) {
            try {
                this.utilPrefs.clear();
            }
            catch (BackingStoreException bse) {
                throw new RuntimeException(bse);
            }
        }
        List<Field> fields = ReflectionUtilities.getPublicFinalFields(this.getClass(), Preference.class);
        this.preferences = new Preference[fields.size()];
        int i = 0;
        for (Field field : fields) {
            this.preferences[i] = (Preference)ReflectionUtilities.get(field, this);
            this.preferences[i].initialize(this, field.getName(), Modifier.isTransient(field.getModifiers()));
            ++i;
        }
        this.setOrder(this.preferences);
    }

    public Preferences getUtilPrefs() {
        return this.utilPrefs;
    }

    protected Preference<?>[] setOrder(Preference<?>[] rv) {
        return rv;
    }

    public final Preference<?>[] getPreferences() {
        assert (this.preferences != null);
        return this.preferences;
    }
}

