/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.preference;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.codec.InputStreamBinaryDecoder;
import edu.cmu.cs.dennisc.codec.OutputStreamBinaryEncoder;
import edu.cmu.cs.dennisc.preference.Preference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPreference<E>
extends Preference<List<E>> {
    private static final int LIST_VERSION = 1;
    private static final String LIST_VERSION_SUFFIX = ".list_version";
    private static final String ITEM_VERSION_SUFFIX = ".item_version";
    private static final String DATA_SUFFIX = ".data";

    public ListPreference(List<E> defaultValue) {
        super(defaultValue);
    }

    protected abstract int getItemVersion();

    protected abstract void encode(BinaryEncoder var1, E var2);

    private byte[] encode(List<E> value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamBinaryEncoder binaryEncoder = new OutputStreamBinaryEncoder(baos);
        binaryEncoder.encode(value.size());
        for (E item : value) {
            this.encode(binaryEncoder, item);
        }
        binaryEncoder.flush();
        return baos.toByteArray();
    }

    protected abstract E decode(int var1, BinaryDecoder var2);

    private List<E> decode(int version, byte[] value) {
        if (value != null) {
            LinkedList<E> rv = new LinkedList<E>();
            ByteArrayInputStream bais = new ByteArrayInputStream(value);
            InputStreamBinaryDecoder binaryDecoder = new InputStreamBinaryDecoder(bais);
            int N = binaryDecoder.decodeInt();
            for (int i = 0; i < N; ++i) {
                E item = this.decode(version, binaryDecoder);
                rv.add(item);
            }
            return rv;
        }
        return null;
    }

    @Override
    protected List<E> getValue(Preferences utilPrefs, String key, List<E> defaultValue) {
        int listVersion = utilPrefs.getInt(key + LIST_VERSION_SUFFIX, 0);
        if (listVersion == 1) {
            int itemVersion = utilPrefs.getInt(key + ITEM_VERSION_SUFFIX, 0);
            byte[] defaultData = this.encode(defaultValue);
            byte[] currentData = utilPrefs.getByteArray(key + DATA_SUFFIX, defaultData);
            return this.decode(itemVersion, currentData);
        }
        return defaultValue;
    }

    @Override
    protected void setAndCommitValue(Preferences utilPrefs, String key, List<E> nextValue) {
        utilPrefs.putInt(key + LIST_VERSION_SUFFIX, 1);
        utilPrefs.putInt(key + ITEM_VERSION_SUFFIX, this.getItemVersion());
        if (nextValue != null) {
            utilPrefs.putByteArray(key + DATA_SUFFIX, this.encode(nextValue));
        } else {
            utilPrefs.putByteArray(key + DATA_SUFFIX, null);
        }
    }
}

