/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.print;

import edu.cmu.cs.dennisc.lang.SystemUtilities;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrintUtilities {
    private static boolean s_isDumpStackDesired;
    private static Stack<PrintStream> s_printStreamStack;
    private static PrintStream s_printStream;
    private static Stack<DecimalFormat> s_decimalFormatStack;
    private static DecimalFormat s_decimalFormat;
    private static Stack<String> s_indentTextStack;
    private static String s_indentText;
    private static Stack<String> s_separatorTextStack;
    private static String s_separatorText;
    private static Map<Class<?>, Method> s_classToAppendMethod;
    private static Map<Class<?>, Method> s_classToAppendLinesMethod;

    private static Method getMethod(String name, Class<?> cls) {
        return ReflectionUtilities.getMethod(PrintUtilities.class, name, StringBuffer.class, cls);
    }

    private PrintUtilities() {
        throw new AssertionError();
    }

    public static void pushPrintStream() {
        s_printStreamStack.push(s_printStream);
    }

    public static PrintStream accessPrintStream() {
        return s_printStream;
    }

    public static void setPrintStream(PrintStream printStream) {
        s_printStream = printStream;
    }

    public static void popPrintStream() {
        s_printStream = s_printStreamStack.pop();
    }

    public static void pushDecimalFormat() {
        s_decimalFormatStack.push(s_decimalFormat);
    }

    public static DecimalFormat accessDecimalFormat() {
        return s_decimalFormat;
    }

    public static void setDecimalFormat(DecimalFormat decimalFormat) {
        s_decimalFormat = decimalFormat;
    }

    public static void popDecimalFormat() {
        s_decimalFormat = s_decimalFormatStack.pop();
    }

    public static void pushIndentText() {
        s_indentTextStack.push(s_indentText);
    }

    public static String getIndentText() {
        return s_indentText;
    }

    public static void setIndentText(String indentText) {
        s_indentText = indentText;
    }

    public static void popIndentText() {
        s_indentText = s_indentTextStack.pop();
    }

    public static void pushSeparatorText() {
        s_separatorTextStack.push(s_separatorText);
    }

    public static String getSeparatorText() {
        return s_separatorText;
    }

    public static void setSeparatorText(String separatorText) {
        s_separatorText = separatorText;
    }

    public static void popSeparatorText() {
        s_separatorText = s_separatorTextStack.pop();
    }

    public static final void printlns(PrintStream ps, int count) {
        for (int i = 0; i < count; ++i) {
            ps.println();
        }
    }

    public static final void println(PrintStream ps) {
        PrintUtilities.printlns(ps, 1);
    }

    public static final void printlns(int count) {
        PrintUtilities.printlns(s_printStream, count);
    }

    public static final void println() {
        PrintUtilities.printlns(1);
    }

    private static StringBuffer append(StringBuffer rv, Object[] values, boolean isSingleLine) {
        if (s_isDumpStackDesired) {
            Thread.dumpStack();
        }
        for (Object value : values) {
            if (value != null) {
                Map<Class<?>, Method> map = isSingleLine ? s_classToAppendMethod : s_classToAppendLinesMethod;
                Method method = map.get(value.getClass());
                if (method != null) {
                    Object[] args = new Object[]{rv, value};
                    ReflectionUtilities.invoke(null, method, args);
                } else if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    rv.append(array.getClass().getComponentType().getName());
                    rv.append("[]: ");
                    rv.append("length=");
                    rv.append(array.length);
                    rv.append("; values=[ ");
                    for (int i = 0; i < array.length; ++i) {
                        if (isSingleLine) {
                            PrintUtilities.append(rv, array[i]);
                            rv.append(" ");
                            continue;
                        }
                        PrintUtilities.appendLines(rv, array[i]);
                        rv.append("\n");
                    }
                    rv.append("]");
                } else {
                    rv.append(value);
                }
            } else {
                rv.append("null");
            }
            rv.append(s_separatorText);
        }
        return rv;
    }

    public static StringBuffer append(StringBuffer rv, Object ... values) {
        return PrintUtilities.append(rv, values, true);
    }

    public static StringBuffer appendLines(StringBuffer rv, Object ... values) {
        return PrintUtilities.append(rv, values, false);
    }

    public static String toString(Object ... value) {
        return PrintUtilities.append(new StringBuffer(), value).toString();
    }

    public static String toStringLines(Object ... value) {
        return PrintUtilities.appendLines(new StringBuffer(), value).toString();
    }

    public static void print(PrintStream ps, Object ... value) {
        ps.print(PrintUtilities.toString(value));
    }

    public static void println(PrintStream ps, Object ... value) {
        ps.println(PrintUtilities.toString(value));
    }

    public static void printlns(PrintStream ps, Object ... value) {
        ps.println(PrintUtilities.toStringLines(value));
    }

    public static void print(Object ... value) {
        PrintUtilities.print(s_printStream, value);
    }

    public static void println(Object ... value) {
        PrintUtilities.println(s_printStream, value);
    }

    public static void printlns(Object ... value) {
        PrintUtilities.printlns(s_printStream, value);
    }

    public static StringBuffer append(StringBuffer rv, Float value) {
        return rv.append(s_decimalFormat.format(value));
    }

    public static StringBuffer append(StringBuffer rv, Double value) {
        return rv.append(s_decimalFormat.format(value));
    }

    public static StringBuffer append(StringBuffer rv, IntBuffer value) {
        rv.append(value);
        rv.append(' ');
        while (value.position() < value.limit()) {
            rv.append(value.get());
            rv.append(' ');
        }
        value.rewind();
        return rv;
    }

    public static StringBuffer appendLines(StringBuffer rv, IntBuffer value) {
        return PrintUtilities.append(rv, value);
    }

    public static StringBuffer append(StringBuffer rv, FloatBuffer value) {
        rv.append(value);
        rv.append(' ');
        while (value.position() < value.limit()) {
            PrintUtilities.append(rv, Float.valueOf(value.get()));
            rv.append(' ');
        }
        value.rewind();
        return rv;
    }

    public static StringBuffer appendLines(StringBuffer rv, FloatBuffer value) {
        return PrintUtilities.append(rv, value);
    }

    public static StringBuffer append(StringBuffer rv, DoubleBuffer value) {
        rv.append(value);
        rv.append(' ');
        while (value.position() < value.limit()) {
            PrintUtilities.append(rv, value.get());
            rv.append(' ');
        }
        value.rewind();
        return rv;
    }

    public static StringBuffer appendLines(StringBuffer rv, DoubleBuffer value) {
        return PrintUtilities.append(rv, value);
    }

    public static StringBuffer append(StringBuffer rv, int[] value) {
        rv.append("int[]: ");
        if (value != null) {
            rv.append("length=");
            rv.append(value.length);
            rv.append("; values=[ ");
            for (int i = 0; i < value.length; ++i) {
                rv.append(value[i]);
                rv.append(" ");
            }
            rv.append("]");
        } else {
            rv.append("null");
        }
        return rv;
    }

    public static StringBuffer appendLines(StringBuffer rv, int[] value) {
        return PrintUtilities.append(rv, value);
    }

    public static StringBuffer append(StringBuffer rv, float[] value) {
        rv.append("float[]: ");
        if (value != null) {
            rv.append("length=");
            rv.append(value.length);
            rv.append("; values=[ ");
            for (int i = 0; i < value.length; ++i) {
                PrintUtilities.append(rv, Float.valueOf(value[i]));
                rv.append(" ");
            }
            rv.append("]");
        } else {
            rv.append("null");
        }
        return rv;
    }

    public static StringBuffer appendLines(StringBuffer rv, float[] value) {
        return PrintUtilities.append(rv, value);
    }

    public static StringBuffer append(StringBuffer rv, double[] value) {
        rv.append("double[]: ");
        if (value != null) {
            rv.append("length=");
            rv.append(value.length);
            rv.append("; values=[ ");
            for (int i = 0; i < value.length; ++i) {
                PrintUtilities.append(rv, value[i]);
                rv.append(" ");
            }
            rv.append("]");
        } else {
            rv.append("null");
        }
        return rv;
    }

    public static StringBuffer appendLines(StringBuffer rv, double[] value) {
        return PrintUtilities.append(rv, value);
    }

    public static StringBuffer append(StringBuffer rv, Printable value) {
        return value.append(rv, s_decimalFormat, false);
    }

    public static StringBuffer appendLines(StringBuffer rv, Printable value) {
        return value.append(rv, s_decimalFormat, true);
    }

    static {
        Class[] classes;
        s_printStreamStack = new Stack();
        s_printStream = System.out;
        s_decimalFormatStack = new Stack();
        s_indentTextStack = new Stack();
        s_separatorTextStack = new Stack();
        s_isDumpStackDesired = SystemUtilities.isPropertyTrue("edu.cmu.cs.dennisc.print.PrintUtilities.isDumpStackDesired");
        s_classToAppendMethod = new HashMap();
        s_classToAppendLinesMethod = new HashMap();
        s_classToAppendMethod.put(Float.class, PrintUtilities.getMethod("append", Float.class));
        s_classToAppendMethod.put(Double.class, PrintUtilities.getMethod("append", Double.class));
        for (Class cls : classes = new Class[]{int[].class, float[].class, double[].class, IntBuffer.class, FloatBuffer.class, DoubleBuffer.class, Printable.class}) {
            s_classToAppendMethod.put(cls, PrintUtilities.getMethod("append", cls));
            s_classToAppendLinesMethod.put(cls, PrintUtilities.getMethod("appendLines", cls));
        }
        s_decimalFormat = new DecimalFormat("0.0000");
        s_decimalFormat.setPositivePrefix("+");
        s_indentText = "    ";
        s_separatorText = " ";
    }
}

