/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.property;

import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.property.Property;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.property.PropertyUtilities;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetterSetterProperty<E>
implements Property<E> {
    private static Object[] s_getterArgs = new Object[0];
    private static Object[] s_setterArgs = new Object[]{null};
    private Method m_getter;
    private Method m_setter;
    private String m_name;

    public GetterSetterProperty(Method getter, Method setter) {
        this.m_getter = getter;
        this.m_setter = setter;
        this.m_name = PropertyUtilities.getPropertyNameForGetter(this.m_getter);
    }

    public GetterSetterProperty(Class<? extends PropertyOwner> cls, String name) {
        this(PropertyUtilities.getGetter(cls, name), PropertyUtilities.getSetter(cls, name));
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getValue(PropertyOwner owner) {
        Object[] objectArray = s_getterArgs;
        synchronized (s_getterArgs) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (E)ReflectionUtilities.invoke(owner, this.m_getter, s_getterArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(PropertyOwner owner, E value) {
        Object[] objectArray = s_setterArgs;
        synchronized (s_setterArgs) {
            GetterSetterProperty.s_setterArgs[0] = value;
            ReflectionUtilities.invoke(owner, this.m_setter, s_setterArgs);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.m_name);
        sb.append("]");
        return sb.toString();
    }
}

