/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.property;

import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.property.event.AddListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.ClearListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.ListPropertyListener;
import edu.cmu.cs.dennisc.property.event.RemoveListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.SetListPropertyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListProperty<E>
extends InstanceProperty<ArrayList<E>>
implements Iterable<E> {
    private List<ListPropertyListener<E>> m_listPropertyListeners = null;

    public ListProperty(InstancePropertyOwner owner) {
        super(owner, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListPropertyListener(ListPropertyListener<E> l) {
        if (this.m_listPropertyListeners == null) {
            this.m_listPropertyListeners = new LinkedList<ListPropertyListener<E>>();
        }
        List<ListPropertyListener<E>> list = this.m_listPropertyListeners;
        synchronized (list) {
            this.m_listPropertyListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListPropertyListener(ListPropertyListener<E> l) {
        assert (this.m_listPropertyListeners != null);
        List<ListPropertyListener<E>> list = this.m_listPropertyListeners;
        synchronized (list) {
            this.m_listPropertyListeners.remove(l);
        }
    }

    private void fireAdding(AddListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.adding(e);
            }
        }
        this.getOwner().fireAdding(e);
    }

    private void fireAdded(AddListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.added(e);
            }
        }
        this.getOwner().fireAdded(e);
    }

    private void fireClearing(ClearListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.clearing(e);
            }
        }
        this.getOwner().fireClearing(e);
    }

    private void fireCleared(ClearListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.cleared(e);
            }
        }
        this.getOwner().fireCleared(e);
    }

    private void fireRemoving(RemoveListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.removing(e);
            }
        }
        this.getOwner().fireRemoving(e);
    }

    private void fireRemoved(RemoveListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.removed(e);
            }
        }
        this.getOwner().fireRemoved(e);
    }

    private void fireSetting(SetListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.setting(e);
            }
        }
        this.getOwner().fireSetting(e);
    }

    private void fireSet(SetListPropertyEvent<E> e) {
        if (this.m_listPropertyListeners != null) {
            for (ListPropertyListener<E> l : this.m_listPropertyListeners) {
                l.set(e);
            }
        }
        this.getOwner().fireSet(e);
    }

    public Object[] toArray() {
        return ((ArrayList)this.getValue()).toArray();
    }

    public <T> T[] toArray(T[] a) {
        return ((ArrayList)this.getValue()).toArray(a);
    }

    public boolean isEmpty() {
        return ((ArrayList)this.getValue()).isEmpty();
    }

    public boolean contains(Object o) {
        return ((ArrayList)this.getValue()).contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return ((ArrayList)this.getValue()).containsAll(c);
    }

    public int size() {
        return ((ArrayList)this.getValue()).size();
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return ((ArrayList)this.getValue()).subList(fromIndex, toIndex);
    }

    public int indexOf(Object element) {
        return ((ArrayList)this.getValue()).indexOf(element);
    }

    public int lastIndexOf(Object element) {
        return ((ArrayList)this.getValue()).lastIndexOf(element);
    }

    public E get(int index) {
        return ((ArrayList)this.getValue()).get(index);
    }

    @Override
    public Iterator<E> iterator() {
        return ((ArrayList)this.getValue()).iterator();
    }

    public void add(int index, E ... elements) {
        AddListPropertyEvent<E> e = new AddListPropertyEvent<E>(this, index, elements);
        this.fireAdding(e);
        ((ArrayList)this.getValue()).ensureCapacity(this.size() + elements.length);
        int i = index;
        for (E element : elements) {
            ((ArrayList)this.getValue()).add(i++, element);
        }
        this.fireAdded(e);
    }

    public void add(E ... elements) {
        this.add(this.size(), elements);
    }

    public boolean addAll(int index, Collection<? extends E> collection) {
        AddListPropertyEvent<? extends E> e = new AddListPropertyEvent<E>(this, index, collection);
        this.fireAdding(e);
        boolean rv = ((ArrayList)this.getValue()).addAll(index, collection);
        this.fireAdded(e);
        return rv;
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size(), c);
    }

    public void clear() {
        ClearListPropertyEvent e = new ClearListPropertyEvent(this);
        this.fireClearing(e);
        ((ArrayList)this.getValue()).clear();
        this.fireCleared(e);
    }

    public void remove(int fromIndex, int toIndex) {
        RemoveListPropertyEvent e = new RemoveListPropertyEvent(this, fromIndex, ((ArrayList)this.getValue()).subList(fromIndex, toIndex));
        this.fireRemoving(e);
        for (int i = fromIndex; i < toIndex; ++i) {
            ((ArrayList)this.getValue()).remove(i);
        }
        this.fireRemoved(e);
    }

    public E remove(int index) {
        E rv = this.get(index);
        this.remove(index, index + 1);
        return rv;
    }

    public void set(int index, E ... elements) {
        SetListPropertyEvent<E> e = new SetListPropertyEvent<E>(this, index, elements);
        this.fireSetting(e);
        for (int i = 0; i < elements.length; ++i) {
            ((ArrayList)this.getValue()).set(index + i, elements[i]);
        }
        this.fireSet(e);
    }

    @Override
    public void setValue(PropertyOwner owner, ArrayList<E> value) {
        ClearListPropertyEvent eClear = new ClearListPropertyEvent(this);
        AddListPropertyEvent<E> eAdd = new AddListPropertyEvent<E>(this, 0, value);
        this.fireClearing(eClear);
        this.fireAdding(eAdd);
        super.setValue(owner, value);
        this.fireCleared(eClear);
        this.fireAdded(eAdd);
    }
}

