/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.property;

import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyUtilities {
    private PropertyUtilities() {
    }

    public static Method getGetter(Class<?> cls, String propertyName) {
        Class[] parameterTypes = new Class[]{};
        String methodName = propertyName.startsWith("Is") && Character.isUpperCase(propertyName.charAt(2)) ? "is" + propertyName.substring(2) : "get" + propertyName;
        return ReflectionUtilities.getMethod(cls, methodName, parameterTypes);
    }

    public static Method getSetter(Class<?> cls, String propertyName) {
        Method getter = PropertyUtilities.getGetter(cls, propertyName);
        Class<?> valueClass = getter.getReturnType();
        Class[] parameterTypes = new Class[]{valueClass};
        String methodName = propertyName.startsWith("Is") && Character.isUpperCase(propertyName.charAt(2)) ? "set" + propertyName.substring(2) : "set" + propertyName;
        try {
            return ReflectionUtilities.getMethod(cls, methodName, parameterTypes);
        }
        catch (RuntimeException re) {
            if (valueClass.equals(Double.TYPE) || valueClass.equals(Double.class)) {
                parameterTypes[0] = Number.class;
                return ReflectionUtilities.getMethod(cls, methodName, parameterTypes);
            }
            throw re;
        }
    }

    public static boolean hasGetter(Class<?> cls, String propertyName) {
        try {
            return PropertyUtilities.getGetter(cls, propertyName) != null;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    public static boolean hasSetter(Class<?> cls, String propertyName) {
        try {
            return PropertyUtilities.getSetter(cls, propertyName) != null;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    public static String getPropertyNameForGetter(Method method) {
        Class<?> valueClass = method.getReturnType();
        boolean isBoolean = valueClass.equals(Boolean.TYPE) || valueClass.equals(Boolean.class);
        String prefix = isBoolean ? "is" : "get";
        String name = method.getName();
        if (name.startsWith(prefix)) {
            String rv = name.substring(prefix.length());
            if (isBoolean) {
                rv = "Is" + rv;
            }
            return rv;
        }
        return null;
    }

    private static String getPropertyNameForSetter(Method method, boolean isExtraParametersAcceptable) {
        String prefix = "set";
        String name = method.getName();
        if (name.startsWith(prefix)) {
            Class<?>[] parameterClses = method.getParameterTypes();
            if (parameterClses.length == 1 || isExtraParametersAcceptable && parameterClses.length >= 1) {
                Class<?> valueClass = parameterClses[0];
                boolean isBoolean = valueClass.equals(Boolean.TYPE) || valueClass.equals(Boolean.class);
                String rv = name.substring(prefix.length());
                if (isBoolean) {
                    rv = "Is" + rv;
                }
                return rv;
            }
            return null;
        }
        return null;
    }

    public static String getPropertyNameForSetter(Method method) {
        return PropertyUtilities.getPropertyNameForSetter(method, false);
    }

    public static boolean isGetterAndSetterExists(Method method) {
        String propertyName = PropertyUtilities.getPropertyNameForGetter(method);
        if (propertyName != null) {
            return PropertyUtilities.hasSetter(method.getDeclaringClass(), propertyName);
        }
        return false;
    }

    public static boolean isSetterAndGetterExists(Method method) {
        String propertyName = PropertyUtilities.getPropertyNameForSetter(method, false);
        if (propertyName != null) {
            return PropertyUtilities.hasGetter(method.getDeclaringClass(), propertyName);
        }
        return false;
    }

    public static boolean isSetterWithExtraParametersAndGetterExists(Method method) {
        String propertyName = PropertyUtilities.getPropertyNameForSetter(method, true);
        if (propertyName != null) {
            return PropertyUtilities.hasGetter(method.getDeclaringClass(), propertyName);
        }
        return false;
    }

    public static Method getSetterForGetter(Method method) {
        return PropertyUtilities.getSetter(method.getDeclaringClass(), PropertyUtilities.getPropertyNameForGetter(method));
    }

    public static Method getGetterForSetter(Method method) {
        return PropertyUtilities.getGetter(method.getDeclaringClass(), PropertyUtilities.getPropertyNameForSetter(method));
    }

    public static Object getPropertyValue(Object o, String propertyName) {
        Method getter = PropertyUtilities.getGetter(o.getClass(), propertyName);
        Object[] args = new Object[]{};
        return ReflectionUtilities.invoke(o, getter, args);
    }

    public static void setPropertyValue(Object o, String propertyName, Object value) {
        Method setter = PropertyUtilities.getSetter(o.getClass(), propertyName);
        Object[] args = new Object[]{value};
        ReflectionUtilities.invoke(o, setter, args);
    }
}

