/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.raytrace;

import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.lang.RuntimeUtilities;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.pattern.VisitUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.AmbientLight;
import edu.cmu.cs.dennisc.scenegraph.Appearance;
import edu.cmu.cs.dennisc.scenegraph.Background;
import edu.cmu.cs.dennisc.scenegraph.Box;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Cylinder;
import edu.cmu.cs.dennisc.scenegraph.DirectionalLight;
import edu.cmu.cs.dennisc.scenegraph.Disc;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Light;
import edu.cmu.cs.dennisc.scenegraph.PlanarReflector;
import edu.cmu.cs.dennisc.scenegraph.PointLight;
import edu.cmu.cs.dennisc.scenegraph.Scene;
import edu.cmu.cs.dennisc.scenegraph.SingleAppearance;
import edu.cmu.cs.dennisc.scenegraph.Sphere;
import edu.cmu.cs.dennisc.scenegraph.SymmetricPerspectiveCamera;
import edu.cmu.cs.dennisc.scenegraph.Torus;
import edu.cmu.cs.dennisc.scenegraph.TriangleFan;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class POVRayUtilities {
    private static String toString(Color4f color) {
        return "color rgb <" + color.red + ", " + color.green + ", " + color.blue + ">";
    }

    private static String toString(Color4f color, float opacity) {
        return "color rgbt <" + color.red + ", " + color.green + ", " + color.blue + ", " + (1.0 - (double)(color.alpha * opacity)) + ">";
    }

    private static String toString(AffineMatrix4x4 m) {
        return "matrix < " + m.orientation.right.x + ", " + m.orientation.right.y + ", " + -m.orientation.right.z + ", " + m.orientation.up.x + ", " + m.orientation.up.y + ", " + -m.orientation.up.z + ", " + -m.orientation.backward.x + ", " + -m.orientation.backward.y + ", " + m.orientation.backward.z + ", " + m.translation.x + ", " + m.translation.y + ", " + -m.translation.z + " >";
    }

    private static String toString(double x, double y, double z) {
        return "<" + x + ", " + y + ", " + -z + ">";
    }

    private static String toString(Tuple3 t) {
        return POVRayUtilities.toString(t.x, t.y, t.z);
    }

    private static void exportBackground(PrintWriter pw, Background sgBackground) {
        pw.println("background {");
        pw.println(POVRayUtilities.toString((Color4f)sgBackground.color.getValue()));
        pw.println("}");
    }

    private static void exportGeometry(PrintWriter pw, Geometry sgGeometry, Appearance sgAppearance, double reflection, AffineMatrix4x4 m) {
        if (sgGeometry instanceof Sphere) {
            Sphere sgSphere = (Sphere)sgGeometry;
            pw.println("sphere {");
            pw.println("<" + m.translation.x + ", " + m.translation.y + ", " + -m.translation.z + ">, " + sgSphere.radius.getValue());
        } else if (sgGeometry instanceof Torus) {
            Torus sgTorus = (Torus)sgGeometry;
            pw.println("torus {");
            pw.println(sgTorus.majorRadius.getValue() + ", " + sgTorus.minorRadius.getValue());
            pw.println(POVRayUtilities.toString(m));
        } else if (sgGeometry instanceof Cylinder) {
            Cylinder sgCylinder = (Cylinder)sgGeometry;
            pw.println("cone {");
            Point3 base = sgCylinder.getCenterOfBottom();
            Point3 cap = sgCylinder.getCenterOfTop();
            pw.println(POVRayUtilities.toString(base));
            pw.println(sgCylinder.bottomRadius.getValue() + ", ");
            pw.println(POVRayUtilities.toString(cap));
            pw.println(sgCylinder.getActualTopRadius());
            if (((Boolean)sgCylinder.hasTopCap.getValue()).booleanValue()) {
                if (!((Boolean)sgCylinder.hasBottomCap.getValue()).booleanValue()) {
                    System.err.println("UNHANDLED CYLINDER CAP STATE: " + sgCylinder);
                }
            } else if (((Boolean)sgCylinder.hasBottomCap.getValue()).booleanValue()) {
                System.err.println("UNHANDLED CYLINDER CAP STATE: " + sgCylinder);
            } else {
                pw.println("open");
            }
            pw.println(POVRayUtilities.toString(m));
        } else if (sgGeometry instanceof Disc) {
            Disc sgDisc = (Disc)sgGeometry;
            pw.println("disc {");
            pw.println("<0,0,0>, <0,0,-1>, " + sgDisc.outerRadius.getValue() + ", " + sgDisc.innerRadius.getValue());
            pw.println(POVRayUtilities.toString(m));
        } else if (sgGeometry instanceof Box) {
            Box sgBox = (Box)sgGeometry;
            Point3 minimum = sgBox.getMinimum();
            Point3 maximum = sgBox.getMaximum();
            pw.println("box {");
            pw.print(POVRayUtilities.toString(minimum));
            pw.print(", ");
            pw.println(POVRayUtilities.toString(maximum));
            pw.println(POVRayUtilities.toString(m));
        } else if (sgGeometry instanceof TriangleFan) {
            TriangleFan sgTriangleFan = (TriangleFan)sgGeometry;
            pw.println("polygon {");
            int n = sgTriangleFan.vertices.getLength();
            pw.println(n + ",");
            Vertex[] sgVertices = (Vertex[])sgTriangleFan.vertices.getValue();
            for (int i = 0; i < n; ++i) {
                Vertex sgVertex = sgVertices[i];
                Point3 p = new Point3(sgVertex.position);
                m.transform(p);
                pw.print(POVRayUtilities.toString(p));
                if (i < n - 1) {
                    pw.println(",");
                    continue;
                }
                pw.println();
            }
        } else {
            System.err.println("UNHANDLED GEOMETRY: " + sgGeometry);
            return;
        }
        Color4f color = null;
        float opacity = Float.NaN;
        float specular = Float.NaN;
        if (sgAppearance instanceof SingleAppearance) {
            SingleAppearance sgSingleAppearance = (SingleAppearance)sgAppearance;
            color = (Color4f)sgSingleAppearance.diffuseColor.getValue();
            opacity = ((Float)sgSingleAppearance.opacity.getValue()).floatValue();
            specular = ((Float)sgSingleAppearance.specularHighlightExponent.getValue()).floatValue();
        }
        pw.println("texture {");
        if (color != null) {
            pw.println("pigment { ");
            pw.println(POVRayUtilities.toString(color, opacity));
            pw.println("}");
        }
        pw.println("finish { ");
        if (reflection > 0.0) {
            pw.println("reflection  " + reflection);
        } else {
            pw.println("phong 1");
            if (!Float.isNaN(specular)) {
                pw.println("specular " + specular);
            }
        }
        pw.println("}");
        pw.println("}");
        pw.println("}");
    }

    private static void exportVisual(PrintWriter pw, Visual sgVisual) {
        AffineMatrix4x4 m = sgVisual.getAbsoluteTransformation();
        Appearance sgAppearance = sgVisual.frontFacingAppearance.getValue();
        double reflection = sgVisual instanceof PlanarReflector ? 0.6 : 0.0;
        for (Geometry sgGeometry : (Geometry[])sgVisual.geometries.getValue()) {
            POVRayUtilities.exportGeometry(pw, sgGeometry, sgAppearance, reflection, m);
        }
    }

    private static void exportLight(PrintWriter pw, Light sgLight) {
        if (sgLight instanceof AmbientLight) {
            System.err.println("UNHANDLED AMBIENT LIGHT: " + sgLight);
            return;
        }
        AffineMatrix4x4 m = sgLight.getAbsoluteTransformation();
        pw.println("light_source { ");
        pw.println("<" + m.translation.x + ", " + m.translation.y + ", " + -m.translation.z + ">");
        pw.println(POVRayUtilities.toString((Color4f)sgLight.color.getValue()));
        if (!(sgLight instanceof PointLight)) {
            if (sgLight instanceof DirectionalLight) {
                pw.println("parallel");
                double x = m.translation.x - m.orientation.backward.x;
                double y = m.translation.y - m.orientation.backward.y;
                double z = m.translation.z - m.orientation.backward.z;
                pw.print("point_at ");
                pw.println(POVRayUtilities.toString(x, y, z));
            } else {
                System.err.println("UNHANDLED LIGHT: " + sgLight);
            }
        }
        pw.println("}");
    }

    public static void export(PrintWriter pw, LookingGlass lookingGlass) {
        AbstractCamera sgCamera = lookingGlass.getCameraAt(0);
        Composite sgRoot = sgCamera.getRoot();
        if (sgRoot instanceof Scene) {
            Scene sgScene = (Scene)sgRoot;
            Background background = sgCamera.background.getValue();
            if (background == null) {
                background = sgScene.background.getValue();
            }
            POVRayUtilities.exportBackground(pw, background);
            AffineMatrix4x4 m = sgCamera.getAbsoluteTransformation();
            pw.println("camera {");
            pw.println(POVRayUtilities.toString(m));
            if (sgCamera instanceof SymmetricPerspectiveCamera) {
                SymmetricPerspectiveCamera sgSymmetricPerspectiveCamera = (SymmetricPerspectiveCamera)sgCamera;
                pw.println("angle " + lookingGlass.getActualHorizontalViewingAngle(sgSymmetricPerspectiveCamera).getAsDegrees());
            }
            pw.println("}");
            for (Visual sgVisual : VisitUtilities.getAll(sgScene, Visual.class)) {
                PrintUtilities.println(sgVisual);
                POVRayUtilities.exportVisual(pw, sgVisual);
            }
            for (Light sgLight : VisitUtilities.getAll(sgScene, Light.class)) {
                POVRayUtilities.exportLight(pw, sgLight);
            }
            pw.flush();
        }
    }

    public static void export(File file, LookingGlass lookingGlass) {
        try {
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            POVRayUtilities.export(new PrintWriter(bos), lookingGlass);
            bos.flush();
            fos.flush();
            fos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void export(String path, LookingGlass lookingGlass) {
        POVRayUtilities.export(new File(path), lookingGlass);
    }

    public static int exec(String path) {
        return RuntimeUtilities.exec(new File("s:/povray"), "pvengine", "/RENDER", "test.pov");
    }
}

