/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.AxisRotation;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.property.AffineMatrix4x4Property;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.TransformationAffect;

public abstract class AbstractTransformable
extends Composite {
    public final AffineMatrix4x4Property localTransformation = new AffineMatrix4x4Property(this, AffineMatrix4x4.createIdentity()){

        public void setValue(PropertyOwner owner, AffineMatrix4x4 value) {
            super.setValue(owner, value);
            AbstractTransformable.this.fireAbsoluteTransformationChange();
        }
    };

    protected abstract Composite getVehicle();

    public AffineMatrix4x4 getAbsoluteTransformation(AffineMatrix4x4 rv) {
        Composite vehicle = this.getVehicle();
        if (vehicle == null || vehicle.isSceneOf(this)) {
            rv = this.getLocalTransformation(rv);
        } else {
            rv = vehicle.getAbsoluteTransformation(rv);
            rv.setToMultiplication(rv, (AffineMatrix4x4)this.localTransformation.getValue());
        }
        return rv;
    }

    public AffineMatrix4x4 getInverseAbsoluteTransformation(AffineMatrix4x4 rv) {
        rv = this.getAbsoluteTransformation(rv);
        rv.invert();
        return rv;
    }

    @Deprecated
    public AffineMatrix4x4 getLocalTransformation(AffineMatrix4x4 rv) {
        rv.set((AffineMatrix4x4)this.localTransformation.getValue());
        return rv;
    }

    @Deprecated
    public AffineMatrix4x4 getLocalTransformation() {
        return this.getLocalTransformation(AffineMatrix4x4.createNaN());
    }

    protected void setLocalTransformation(AffineMatrix4x4 transformation, TransformationAffect affect) {
        if (transformation == null) {
            throw new NullPointerException();
        }
        if (transformation.isNaN()) {
            throw new RuntimeException("isNaN");
        }
        assert (affect != null);
        AffineMatrix4x4 m = (AffineMatrix4x4)this.localTransformation.getValue();
        affect.set(m, transformation);
        this.localTransformation.touch();
        this.fireAbsoluteTransformationChange();
    }

    public final void setLocalTransformation(AffineMatrix4x4 transformation) {
        this.setLocalTransformation(transformation, TransformationAffect.AFFECT_ALL);
    }

    public AffineMatrix4x4 getTransformation(AffineMatrix4x4 rv, ReferenceFrame asSeenBy) {
        if (asSeenBy.isVehicleOf(this)) {
            rv = this.getLocalTransformation(rv);
        } else if (asSeenBy.isSceneOf(this)) {
            rv = this.getAbsoluteTransformation(rv);
        } else if (asSeenBy.isLocalOf(this)) {
            rv.setIdentity();
        } else {
            asSeenBy.getInverseAbsoluteTransformation(rv);
            rv.multiply(this.getAbsoluteTransformation());
        }
        return rv;
    }

    public void setTransformation(AffineMatrix4x4 transformation, ReferenceFrame asSeenBy, TransformationAffect affect) {
        if (asSeenBy.isVehicleOf(this)) {
            this.setLocalTransformation(transformation, affect);
        } else if (asSeenBy.isLocalOf(this)) {
            this.applyTransformation(transformation, asSeenBy, affect);
        } else {
            Composite vehicle = this.getVehicle();
            assert (vehicle != null);
            AffineMatrix4x4 m = new AffineMatrix4x4(vehicle.getInverseAbsoluteTransformation());
            if (!asSeenBy.isSceneOf(this)) {
                m.multiply(asSeenBy.getAbsoluteTransformation());
            }
            m.multiply(transformation);
            this.setLocalTransformation(m, affect);
        }
    }

    public void setTransformation(AffineMatrix4x4 transformation, ReferenceFrame asSeenBy) {
        this.setTransformation(transformation, asSeenBy, TransformationAffect.AFFECT_ALL);
    }

    public void setTranslationOnly(double x, double y, double z, ReferenceFrame asSeenBy) {
        if (Double.isNaN(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        if (Double.isNaN(z)) {
            z = 0.0;
        }
        this.setTransformation(AffineMatrix4x4.createTranslation(x, y, z), asSeenBy, TransformationAffect.getTranslationAffect(x, y, z));
    }

    public void setTranslationOnly(Tuple3 t, ReferenceFrame asSeenBy) {
        this.setTranslationOnly(t.x, t.y, t.z, asSeenBy);
    }

    public void setAxesOnly(Orientation orientation, ReferenceFrame asSeenBy) {
        this.setTransformation(AffineMatrix4x4.createOrientation(orientation), asSeenBy, TransformationAffect.AFFECT_ORIENTAION_ONLY);
    }

    public void setAxesOnlyToPointAt(Component target, Point3 targetOffset, Vector3 upGuide) {
        Vector3 forward;
        AffineMatrix4x4 mSelf = this.getAbsoluteTransformation();
        AffineMatrix4x4 mTarget = target.getAbsoluteTransformation();
        if (targetOffset != null) {
            mTarget.applyTranslation(targetOffset);
        }
        if ((forward = Vector3.createSubtraction(mTarget.translation, mSelf.translation)).calculateMagnitudeSquared() != 0.0) {
            this.setAxesOnly(new ForwardAndUpGuide(forward, null).createOrthogonalMatrix3x3(), AsSeenBy.SCENE);
        }
    }

    public void setAxesOnlyToPointAt(Component target, Point3 offset) {
        this.setAxesOnlyToPointAt(target, offset, null);
    }

    public void setAxesOnlyToPointAt(Component target) {
        this.setAxesOnlyToPointAt(target, null);
    }

    public void setAxesOnlyToStandUp(ReferenceFrame asSeenBy) {
        OrthogonalMatrix3x3 axes = this.getAxes(asSeenBy);
        this.setAxesOnly(OrthogonalMatrix3x3.createFromStandUp(axes), asSeenBy);
    }

    public void setAxesOnlyToStandUp() {
        this.setAxesOnlyToStandUp(AsSeenBy.SCENE);
    }

    public void applyTransformation(AffineMatrix4x4 transformation, ReferenceFrame asSeenBy, TransformationAffect affect) {
        if (asSeenBy.isLocalOf(this)) {
            AffineMatrix4x4 m = this.getLocalTransformation();
            m.setToMultiplication(m, transformation);
            this.setLocalTransformation(m);
        } else if (asSeenBy.isVehicleOf(this)) {
            AffineMatrix4x4 m = this.getLocalTransformation();
            m.setToMultiplication(transformation, m);
            this.setLocalTransformation(m);
        } else {
            AffineMatrix4x4 m = this.getTransformation(asSeenBy);
            m.setToMultiplication(transformation, m);
            this.setTransformation(m, asSeenBy);
        }
    }

    public void applyTransformation(AffineMatrix4x4 transformation, ReferenceFrame asSeenBy) {
        this.applyTransformation(transformation, asSeenBy, TransformationAffect.AFFECT_ALL);
    }

    public void applyTranslation(double x, double y, double z, ReferenceFrame asSeenBy) {
        this.applyTransformation(AffineMatrix4x4.createTranslation(x, y, z), asSeenBy);
    }

    public void applyTranslation(Tuple3 t, ReferenceFrame asSeenBy) {
        this.applyTranslation(t.x, t.y, t.z, asSeenBy);
    }

    public void applyTranslation(double x, double y, double z) {
        this.applyTranslation(x, y, z, AsSeenBy.SELF);
    }

    public void applyTranslation(Tuple3 t) {
        this.applyTranslation(t.x, t.y, t.z);
    }

    @Deprecated
    public void applyRotationAboutXAxisInRadians(double angleInRadians, ReferenceFrame asSeenBy) {
        this.applyTransformation(AffineMatrix4x4.createRotationAboutXAxis(new AngleInRadians(angleInRadians)), asSeenBy);
    }

    @Deprecated
    public void applyRotationAboutXAxisInRadians(double angleInRadians) {
        this.applyRotationAboutXAxisInRadians(angleInRadians, AsSeenBy.SELF);
    }

    @Deprecated
    public void applyRotationAboutYAxisInRadians(double angleInRadians, ReferenceFrame asSeenBy) {
        this.applyTransformation(AffineMatrix4x4.createRotationAboutYAxis(new AngleInRadians(angleInRadians)), asSeenBy);
    }

    @Deprecated
    public void applyRotationAboutYAxisInRadians(double angleInRadians) {
        this.applyRotationAboutYAxisInRadians(angleInRadians, AsSeenBy.SELF);
    }

    @Deprecated
    public void applyRotationAboutZAxisInRadians(double angleInRadians, ReferenceFrame asSeenBy) {
        this.applyTransformation(AffineMatrix4x4.createRotationAboutZAxis(new AngleInRadians(angleInRadians)), asSeenBy);
    }

    @Deprecated
    public void applyRotationAboutZAxisInRadians(double angleInRadians) {
        this.applyRotationAboutZAxisInRadians(angleInRadians, AsSeenBy.SELF);
    }

    @Deprecated
    public void applyRotationAboutArbitraryAxisInRadians(Vector3 axis, double angleInRadians, ReferenceFrame asSeenBy) {
        if (axis.isPositiveXAxis()) {
            this.applyRotationAboutXAxisInRadians(angleInRadians, asSeenBy);
        } else if (axis.isNegativeXAxis()) {
            this.applyRotationAboutXAxisInRadians(-angleInRadians, asSeenBy);
        } else if (axis.isPositiveYAxis()) {
            this.applyRotationAboutYAxisInRadians(angleInRadians, asSeenBy);
        } else if (axis.isNegativeYAxis()) {
            this.applyRotationAboutYAxisInRadians(-angleInRadians, asSeenBy);
        } else if (axis.isPositiveZAxis()) {
            this.applyRotationAboutZAxisInRadians(angleInRadians, asSeenBy);
        } else if (axis.isNegativeZAxis()) {
            this.applyRotationAboutZAxisInRadians(-angleInRadians, asSeenBy);
        } else {
            this.applyTransformation(AffineMatrix4x4.createOrientation(new AxisRotation(axis, new AngleInRadians(angleInRadians))), asSeenBy);
        }
    }

    @Deprecated
    public void applyRotationAboutArbitraryAxisInRadians(Vector3 axis, double angleInRadians) {
        this.applyRotationAboutArbitraryAxisInRadians(axis, angleInRadians, AsSeenBy.SELF);
    }

    public void applyRotationAboutXAxis(Angle angle, ReferenceFrame asSeenBy) {
        this.applyRotationAboutXAxisInRadians(angle.getAsRadians(), asSeenBy);
    }

    public void applyRotationAboutXAxis(Angle angle) {
        this.applyRotationAboutXAxis(angle, AsSeenBy.SELF);
    }

    public void applyRotationAboutYAxis(Angle angle, ReferenceFrame asSeenBy) {
        this.applyRotationAboutYAxisInRadians(angle.getAsRadians(), asSeenBy);
    }

    public void applyRotationAboutYAxis(Angle angle) {
        this.applyRotationAboutYAxis(angle, AsSeenBy.SELF);
    }

    public void applyRotationAboutZAxis(Angle angle, ReferenceFrame asSeenBy) {
        this.applyRotationAboutZAxisInRadians(angle.getAsRadians(), asSeenBy);
    }

    public void applyRotationAboutZAxis(Angle angle) {
        this.applyRotationAboutZAxis(angle, AsSeenBy.SELF);
    }

    public void applyRotationAboutArbitraryAxis(Vector3 axis, Angle angle, ReferenceFrame asSeenBy) {
        this.applyRotationAboutArbitraryAxisInRadians(axis, angle.getAsRadians(), asSeenBy);
    }

    public void applyRotationAboutArbitraryAxis(Vector3 axis, Angle angle) {
        this.applyRotationAboutArbitraryAxis(axis, angle, AsSeenBy.SELF);
    }
}

