/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.pattern.Visitor;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.event.ComponentAddedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.ComponentRemovedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.ComponentsListener;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Composite
extends Component {
    private List<Component> m_children = new LinkedList<Component>();
    private List<ComponentsListener> m_childrenListeners = new LinkedList<ComponentsListener>();

    @Override
    public void accept(Visitor visitor) {
        super.accept(visitor);
        for (Component child : this.m_children) {
            child.accept(visitor);
        }
    }

    @Override
    protected void actuallyRelease() {
        super.actuallyRelease();
        for (Component child : this.m_children) {
            child.release();
        }
    }

    public boolean isAncestorOf(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDescendantOf(this);
    }

    public boolean isSceneOf(Composite other) {
        return false;
    }

    public boolean isParentOf(Composite other) {
        return this == other.getParent();
    }

    public boolean isLocalOf(Composite other) {
        return this == other;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildAdded(Component child) {
        assert (child != this);
        List<Component> list = this.m_children;
        synchronized (list) {
            this.m_children.add(child);
        }
        ComponentAddedEvent e = new ComponentAddedEvent(this, child);
        List<ComponentsListener> list2 = this.m_childrenListeners;
        synchronized (list2) {
            for (ComponentsListener childrenListener : this.m_childrenListeners) {
                childrenListener.componentAdded(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChildRemoved(Component child) {
        List<Component> list = this.m_children;
        synchronized (list) {
            this.m_children.remove(child);
        }
        ComponentRemovedEvent e = new ComponentRemovedEvent(this, child);
        List<ComponentsListener> list2 = this.m_childrenListeners;
        synchronized (list2) {
            for (ComponentsListener childrenListener : this.m_childrenListeners) {
                childrenListener.componentRemoved(e);
            }
        }
    }

    public void addComponent(Component component) {
        assert (component != this);
        component.setParent(this);
    }

    public void removeComponent(Component component) {
        if (component.getParent() != this) {
            throw new RuntimeException();
        }
        component.setParent(null);
    }

    public int getComponentCount() {
        return this.m_children.size();
    }

    public int getIndexOfComponent(Component component) {
        return this.m_children.indexOf(component);
    }

    public Component getComponentAt(int i) {
        return this.m_children.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getComponents(Component[] rv) {
        List<Component> list = this.m_children;
        synchronized (list) {
            return this.m_children.toArray(rv);
        }
    }

    public Component[] getComponents() {
        return this.getComponents(new Component[this.getComponentCount()]);
    }

    public Iterable<Component> accessComponents() {
        return this.m_children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildrenListener(ComponentsListener childrenListener) {
        List<ComponentsListener> list = this.m_childrenListeners;
        synchronized (list) {
            this.m_childrenListeners.add(childrenListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenListener(ComponentsListener childrenListener) {
        List<ComponentsListener> list = this.m_childrenListeners;
        synchronized (list) {
            this.m_childrenListeners.remove(childrenListener);
        }
    }

    public Iterable<ComponentsListener> getChildrenListenerIterable() {
        return this.m_childrenListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireAbsoluteTransformationChange() {
        super.fireAbsoluteTransformationChange();
        List<Component> list = this.m_children;
        synchronized (list) {
            for (Component child : this.m_children) {
                child.fireAbsoluteTransformationChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireHierarchyChanged() {
        super.fireHierarchyChanged();
        List<Component> list = this.m_children;
        synchronized (list) {
            for (Component child : this.m_children) {
                child.fireHierarchyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element newCopy() {
        Composite rv = (Composite)super.newCopy();
        List<Component> list = this.m_children;
        synchronized (list) {
            for (Component component : this.m_children) {
                Component rvComponent = (Component)component.newCopy();
                rvComponent.setParent(rv);
            }
        }
        return rv;
    }
}

