/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.BooleanProperty;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Shape;

public class Cylinder
extends Shape {
    public final Geometry.BoundDoubleProperty length = new Geometry.BoundDoubleProperty((InstancePropertyOwner)this, (Double)1.0){

        public void setValue(PropertyOwner owner, Double value) {
            assert (value >= 0.0);
            super.setValue(owner, value);
        }
    };
    public final Geometry.BoundDoubleProperty bottomRadius = new Geometry.BoundDoubleProperty((InstancePropertyOwner)this, (Double)1.0){

        public void setValue(PropertyOwner owner, Double value) {
            assert (value >= 0.0);
            super.setValue(owner, value);
        }
    };
    public final Geometry.BoundDoubleProperty topRadius = new Geometry.BoundDoubleProperty((InstancePropertyOwner)this, (Double)1.0){

        public void setValue(PropertyOwner owner, Double value) {
            assert (value >= 0.0);
            super.setValue(owner, value);
        }
    };
    public final InstanceProperty<OriginAlignment> originAlignment = new InstanceProperty<OriginAlignment>((InstancePropertyOwner)this, OriginAlignment.BOTTOM){

        @Override
        public void setValue(PropertyOwner owner, OriginAlignment value) {
            super.setValue(owner, value);
            Cylinder.this.fireBoundChange();
        }
    };
    public final InstanceProperty<BottomToTopAxis> bottomToTopAxis = new InstanceProperty<BottomToTopAxis>((InstancePropertyOwner)this, BottomToTopAxis.POSITIVE_Y){

        @Override
        public void setValue(PropertyOwner owner, BottomToTopAxis value) {
            super.setValue(owner, value);
            Cylinder.this.fireBoundChange();
        }
    };
    public final BooleanProperty hasBottomCap = new BooleanProperty((InstancePropertyOwner)this, true);
    public final BooleanProperty hasTopCap = new BooleanProperty((InstancePropertyOwner)this, true);

    public double getActualTopRadius() {
        if (Double.isNaN((Double)this.topRadius.getValue())) {
            return (Double)this.bottomRadius.getValue();
        }
        return (Double)this.topRadius.getValue();
    }

    private double getMaxRadius() {
        if (Double.isNaN((Double)this.topRadius.getValue())) {
            return (Double)this.bottomRadius.getValue();
        }
        return Math.max((Double)this.bottomRadius.getValue(), (Double)this.topRadius.getValue());
    }

    private double getTop() {
        OriginAlignment originAlignment = this.originAlignment.getValue();
        if (originAlignment == OriginAlignment.BOTTOM) {
            return (Double)this.length.getValue();
        }
        if (originAlignment == OriginAlignment.CENTER) {
            return (Double)this.length.getValue() * 0.5;
        }
        if (originAlignment == OriginAlignment.TOP) {
            return 0.0;
        }
        throw new RuntimeException();
    }

    private double getBottom() {
        OriginAlignment originAlignment = this.originAlignment.getValue();
        if (originAlignment == OriginAlignment.BOTTOM) {
            return 0.0;
        }
        if (originAlignment == OriginAlignment.CENTER) {
            return -((Double)this.length.getValue()).doubleValue() * 0.5;
        }
        if (originAlignment == OriginAlignment.TOP) {
            return -((Double)this.length.getValue()).doubleValue();
        }
        throw new RuntimeException();
    }

    private double getCenter() {
        OriginAlignment originAlignment = this.originAlignment.getValue();
        if (originAlignment == OriginAlignment.BOTTOM) {
            return (Double)this.length.getValue() * 0.5;
        }
        if (originAlignment == OriginAlignment.CENTER) {
            return 0.0;
        }
        if (originAlignment == OriginAlignment.TOP) {
            return -((Double)this.length.getValue()).doubleValue() * 0.5;
        }
        throw new RuntimeException();
    }

    public Point3 getCenterOfTop(Point3 rv) {
        double top = this.getTop();
        BottomToTopAxis bottomToTopAxis = this.bottomToTopAxis.getValue();
        if (bottomToTopAxis == BottomToTopAxis.POSITIVE_X) {
            rv.set(top, 0.0, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Y) {
            rv.set(0.0, top, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Z) {
            rv.set(0.0, 0.0, top);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_X) {
            rv.set(-top, 0.0, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Y) {
            rv.set(0.0, -top, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Z) {
            rv.set(0.0, 0.0, -top);
        } else {
            throw new RuntimeException();
        }
        return rv;
    }

    public Point3 getCenterOfTop() {
        return this.getCenterOfTop(new Point3());
    }

    public Point3 getCenterOfBottom(Point3 rv) {
        double bottom = this.getBottom();
        BottomToTopAxis bottomToTopAxis = this.bottomToTopAxis.getValue();
        if (bottomToTopAxis == BottomToTopAxis.POSITIVE_X) {
            rv.set(bottom, 0.0, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Y) {
            rv.set(0.0, bottom, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Z) {
            rv.set(0.0, 0.0, bottom);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_X) {
            rv.set(-bottom, 0.0, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Y) {
            rv.set(0.0, -bottom, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Z) {
            rv.set(0.0, 0.0, -bottom);
        } else {
            throw new RuntimeException();
        }
        return rv;
    }

    public Point3 getCenterOfBottom() {
        return this.getCenterOfBottom(new Point3());
    }

    protected void updateBoundingBox(AxisAlignedBox boundingBox) {
        double top = this.getTop();
        double bottom = this.getBottom();
        double maxRadius = this.getMaxRadius();
        BottomToTopAxis bottomToTopAxis = this.bottomToTopAxis.getValue();
        if (bottomToTopAxis == BottomToTopAxis.POSITIVE_X) {
            boundingBox.setMinimum(bottom, -maxRadius, -maxRadius);
            boundingBox.setMaximum(top, maxRadius, maxRadius);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Y) {
            boundingBox.setMinimum(-maxRadius, bottom, -maxRadius);
            boundingBox.setMaximum(maxRadius, top, maxRadius);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Z) {
            boundingBox.setMinimum(-maxRadius, -maxRadius, bottom);
            boundingBox.setMaximum(maxRadius, maxRadius, top);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_X) {
            boundingBox.setMinimum(top, -maxRadius, -maxRadius);
            boundingBox.setMaximum(bottom, maxRadius, maxRadius);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Y) {
            boundingBox.setMinimum(-maxRadius, top, -maxRadius);
            boundingBox.setMaximum(maxRadius, bottom, maxRadius);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Z) {
            boundingBox.setMinimum(-maxRadius, -maxRadius, top);
            boundingBox.setMaximum(maxRadius, maxRadius, bottom);
        } else {
            throw new RuntimeException();
        }
    }

    protected void updateBoundingSphere(Sphere boundingSphere) {
        double center = this.getCenter();
        BottomToTopAxis bottomToTopAxis = this.bottomToTopAxis.getValue();
        if (bottomToTopAxis == BottomToTopAxis.POSITIVE_X) {
            boundingSphere.center.set(center, 0.0, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Y) {
            boundingSphere.center.set(0.0, center, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.POSITIVE_Z) {
            boundingSphere.center.set(0.0, 0.0, center);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_X) {
            boundingSphere.center.set(-center, 0.0, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Y) {
            boundingSphere.center.set(0.0, -center, 0.0);
        } else if (bottomToTopAxis == BottomToTopAxis.NEGATIVE_Z) {
            boundingSphere.center.set(0.0, 0.0, -center);
        } else {
            throw new RuntimeException();
        }
        double halfLength = (Double)this.length.getValue() * 0.5;
        double halfLengthSquared = halfLength * halfLength;
        double maxRadius = this.getMaxRadius();
        double maxRadiusSquared = maxRadius * maxRadius;
        boundingSphere.radius = Math.sqrt(halfLengthSquared + maxRadiusSquared + maxRadiusSquared);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BottomToTopAxis {
        POSITIVE_X(1.0, 0.0, 0.0),
        POSITIVE_Y(0.0, 1.0, 0.0),
        POSITIVE_Z(0.0, 0.0, 1.0),
        NEGATIVE_X(-1.0, 0.0, 0.0),
        NEGATIVE_Y(0.0, -1.0, 0.0),
        NEGATIVE_Z(0.0, 0.0, -1.0);

        private Vector3 m_axis = new Vector3();

        private BottomToTopAxis(double x, double y, double z) {
            this.m_axis.set(x, y, z);
        }

        public Vector3 accessVector() {
            return this.m_axis;
        }

        public Vector3 getVector(Vector3 rv) {
            rv.set(this.m_axis);
            return rv;
        }

        public Vector3 getVector() {
            return this.getVector(new Vector3());
        }

        public boolean isPositive() {
            return this.m_axis.x > 0.0 || this.m_axis.y > 0.0 || this.m_axis.z > 0.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OriginAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

