/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.DoubleProperty;
import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.event.BoundEvent;
import edu.cmu.cs.dennisc.scenegraph.event.BoundListener;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Geometry
extends Element {
    private AxisAlignedBox m_boundingBox = new AxisAlignedBox();
    private Sphere m_boundingSphere = new Sphere();
    private Vector<BoundListener> m_boundObservers = new Vector();

    protected abstract void updateBoundingBox(AxisAlignedBox var1);

    protected abstract void updateBoundingSphere(Sphere var1);

    protected abstract void updatePlane(Vector3 var1, Vector3 var2, Point3 var3);

    public AffineMatrix4x4 getPlane(AffineMatrix4x4 rv) {
        Vector3 forward = new Vector3();
        Vector3 upGuide = new Vector3();
        this.updatePlane(forward, upGuide, rv.translation);
        rv.orientation.setValue(new ForwardAndUpGuide(forward, upGuide));
        return rv;
    }

    public abstract void transform(AbstractMatrix4x4 var1);

    public final AxisAlignedBox getAxisAlignedMinimumBoundingBox(AxisAlignedBox boundingBox) {
        if (this.m_boundingBox.isNaN()) {
            this.updateBoundingBox(this.m_boundingBox);
        }
        boundingBox.set(this.m_boundingBox);
        return boundingBox;
    }

    public final AxisAlignedBox getAxisAlignedMinimumBoundingBox() {
        return this.getAxisAlignedMinimumBoundingBox(new AxisAlignedBox());
    }

    public final Sphere getBoundingSphere(Sphere boundingSphere) {
        if (this.m_boundingSphere.isNaN()) {
            this.updateBoundingSphere(this.m_boundingSphere);
        }
        boundingSphere.set(this.m_boundingSphere);
        return boundingSphere;
    }

    public final Sphere getBoundingSphere() {
        return this.getBoundingSphere(new Sphere());
    }

    public void addBoundObserver(BoundListener boundObserver) {
        this.m_boundObservers.addElement(boundObserver);
    }

    public void removeBoundObserver(BoundListener boundObserver) {
        this.m_boundObservers.removeElement(boundObserver);
    }

    public Iterable<BoundListener> accessBoundObservers() {
        return this.m_boundObservers;
    }

    protected void fireBoundChange() {
        this.m_boundingBox.setNaN();
        this.m_boundingSphere.setNaN();
        BoundEvent e = new BoundEvent(this);
        for (BoundListener boundObserver : this.m_boundObservers) {
            boundObserver.boundChanged(e);
        }
    }

    public class BoundDoubleProperty
    extends DoubleProperty {
        public BoundDoubleProperty(InstancePropertyOwner owner, Double value) {
            super(owner, value);
        }

        public void setValue(PropertyOwner owner, Double value) {
            super.setValue(owner, value);
            Geometry.this.fireBoundChange();
        }
    }
}

