/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.glyph.GlyphVector;
import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.property.StringProperty;
import edu.cmu.cs.dennisc.scenegraph.FrontToBackAlignment;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.LeftToRightAlignment;
import edu.cmu.cs.dennisc.scenegraph.TopToBottomAlignment;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class Text
extends Geometry {
    private static final String DEFAULT_TEXT = "";
    private static final Font DEFAULT_FONT = new Font(null, 0, 12);
    public final StringProperty text = new StringProperty(this, ""){

        public void setValue(PropertyOwner owner, String value) {
            super.setValue(owner, value);
            Text.this.m_glyphVector.setText(value.toString());
            Text.this.m_unalignedBoundingBox.setNaN();
            Text.this.fireBoundChange();
        }
    };
    public final InstanceProperty<Font> font = new InstanceProperty<Font>((InstancePropertyOwner)this, DEFAULT_FONT){

        @Override
        public void setValue(PropertyOwner owner, Font value) {
            super.setValue(owner, value);
            Text.this.m_glyphVector.setFont(value);
            Text.this.m_unalignedBoundingBox.setNaN();
            Text.this.fireBoundChange();
        }
    };
    public final Geometry.BoundDoubleProperty depth = new Geometry.BoundDoubleProperty((InstancePropertyOwner)this, (Double)0.25){

        public void setValue(PropertyOwner owner, Double value) {
            super.setValue(owner, value);
            Text.this.m_unalignedBoundingBox.setNaN();
        }
    };
    public final InstanceProperty<LeftToRightAlignment> leftToRightAlignment = new InstanceProperty<LeftToRightAlignment>((InstancePropertyOwner)this, LeftToRightAlignment.ALIGN_CENTER_OF_LEFT_AND_RIGHT){

        @Override
        public void setValue(PropertyOwner owner, LeftToRightAlignment value) {
            super.setValue(owner, value);
            Text.this.m_unalignedBoundingBox.setNaN();
            Text.this.fireBoundChange();
        }
    };
    public final InstanceProperty<TopToBottomAlignment> topToBottomAlignment = new InstanceProperty<TopToBottomAlignment>((InstancePropertyOwner)this, TopToBottomAlignment.ALIGN_BASELINE){

        @Override
        public void setValue(PropertyOwner owner, TopToBottomAlignment value) {
            super.setValue(owner, value);
            Text.this.m_unalignedBoundingBox.setNaN();
            Text.this.fireBoundChange();
        }
    };
    public final InstanceProperty<FrontToBackAlignment> frontToBackAlignment = new InstanceProperty<FrontToBackAlignment>((InstancePropertyOwner)this, FrontToBackAlignment.ALIGN_CENTER_OF_FRONT_AND_BACK){

        @Override
        public void setValue(PropertyOwner owner, FrontToBackAlignment value) {
            super.setValue(owner, value);
            Text.this.m_unalignedBoundingBox.setNaN();
            Text.this.fireBoundChange();
        }
    };
    private AxisAlignedBox m_unalignedBoundingBox = new AxisAlignedBox(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    private GlyphVector m_glyphVector = new GlyphVector("", DEFAULT_FONT, -1.0f, -1.0f);

    public GlyphVector getGlyphVector() {
        return this.m_glyphVector;
    }

    protected void updateUnalignedBoundingBoxIfNecessary() {
        if (this.m_unalignedBoundingBox.isNaN()) {
            Rectangle2D.Float bounds = this.m_glyphVector.getBounds();
            this.m_unalignedBoundingBox.setMinimum(bounds.x, bounds.y, 0.0);
            this.m_unalignedBoundingBox.setMaximum(bounds.x + bounds.width, bounds.y + bounds.height, (Double)this.depth.getValue());
        }
    }

    public Vector3 getAlignmentOffset() {
        this.updateUnalignedBoundingBoxIfNecessary();
        Vector3 alignmentOffset = new Vector3();
        LeftToRightAlignment leftToRightAlignment = this.leftToRightAlignment.getValue();
        TopToBottomAlignment topToBottomAlignment = this.topToBottomAlignment.getValue();
        FrontToBackAlignment frontToBackAlignment = this.frontToBackAlignment.getValue();
        if (leftToRightAlignment == LeftToRightAlignment.ALIGN_CENTER_OF_LEFT_AND_RIGHT) {
            alignmentOffset.x = -(this.m_unalignedBoundingBox.getXMinimum() + this.m_unalignedBoundingBox.getWidth() / 2.0);
        } else if (leftToRightAlignment == LeftToRightAlignment.ALIGN_LEFT) {
            alignmentOffset.x = -this.m_unalignedBoundingBox.getXMinimum();
        } else if (leftToRightAlignment == LeftToRightAlignment.ALIGN_RIGHT) {
            alignmentOffset.x = -this.m_unalignedBoundingBox.getXMaximum();
        } else {
            throw new RuntimeException();
        }
        if (topToBottomAlignment == TopToBottomAlignment.ALIGN_CENTER_OF_TOP_AND_BOTTOM) {
            alignmentOffset.y = -(this.m_unalignedBoundingBox.getYMinimum() + this.m_unalignedBoundingBox.getHeight() / 2.0);
        } else if (topToBottomAlignment == TopToBottomAlignment.ALIGN_TOP) {
            alignmentOffset.y = -this.m_unalignedBoundingBox.getYMaximum();
        } else if (topToBottomAlignment == TopToBottomAlignment.ALIGN_BOTTOM) {
            alignmentOffset.y = -this.m_unalignedBoundingBox.getYMinimum();
        } else if (topToBottomAlignment == TopToBottomAlignment.ALIGN_BASELINE) {
            alignmentOffset.y = 0.0;
        } else if (topToBottomAlignment == TopToBottomAlignment.ALIGN_CENTER_OF_TOP_AND_BASELINE) {
            alignmentOffset.y = -this.m_unalignedBoundingBox.getYMaximum() / 2.0;
        } else {
            throw new RuntimeException();
        }
        if (frontToBackAlignment == FrontToBackAlignment.ALIGN_CENTER_OF_FRONT_AND_BACK) {
            alignmentOffset.z = -((Double)this.depth.getValue()).doubleValue() / 2.0;
        } else if (frontToBackAlignment == FrontToBackAlignment.ALIGN_FRONT) {
            alignmentOffset.z = 0.0;
        } else if (frontToBackAlignment == FrontToBackAlignment.ALIGN_BACK) {
            alignmentOffset.z = -((Double)this.depth.getValue()).doubleValue();
        } else {
            throw new RuntimeException();
        }
        return alignmentOffset;
    }

    protected void updateBoundingBox(AxisAlignedBox boundingBox) {
        this.updateUnalignedBoundingBoxIfNecessary();
        Vector3 alignmentOffset = this.getAlignmentOffset();
        boundingBox.set(this.m_unalignedBoundingBox);
        boundingBox.translate(alignmentOffset);
    }

    protected void updateBoundingSphere(Sphere boundingSphere) {
    }

    protected void updatePlane(Vector3 forward, Vector3 upGuide, Point3 translation) {
        throw new RuntimeException("TODO");
    }

    public void transform(AbstractMatrix4x4 trans) {
        throw new RuntimeException("TODO");
    }
}

