/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.bound;

import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundUtilities {
    public static AxisAlignedBox getBoundingBox(AxisAlignedBox rv, Vertex[] va) {
        Point3 min = new Point3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Point3 max = new Point3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (Vertex v : va) {
            min.x = Math.min(min.x, v.position.x);
            min.y = Math.min(min.y, v.position.y);
            min.z = Math.min(min.z, v.position.z);
            max.x = Math.max(max.x, v.position.x);
            max.y = Math.max(max.y, v.position.y);
            max.z = Math.max(max.z, v.position.z);
        }
        if (min.x == Double.MAX_VALUE) {
            rv.setNaN();
        } else {
            rv.setMinimum(min);
            rv.setMaximum(max);
        }
        return rv;
    }

    public static AxisAlignedBox getBoundingBox(AxisAlignedBox rv, Iterable<Point3> pi) {
        Point3 min = new Point3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Point3 max = new Point3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (Point3 p : pi) {
            min.x = Math.min(min.x, p.x);
            min.y = Math.min(min.y, p.y);
            min.z = Math.min(min.z, p.z);
            max.x = Math.max(max.x, p.x);
            max.y = Math.max(max.y, p.y);
            max.z = Math.max(max.z, p.z);
        }
        if (min.x == Double.MAX_VALUE) {
            rv.setNaN();
        } else {
            rv.setMinimum(min);
            rv.setMaximum(max);
        }
        return rv;
    }

    public static AxisAlignedBox getBoundingBox(AxisAlignedBox rv, Point3[] pa) {
        Point3 min = new Point3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Point3 max = new Point3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (Point3 p : pa) {
            min.x = Math.min(min.x, p.x);
            min.y = Math.min(min.y, p.y);
            min.z = Math.min(min.z, p.z);
            max.x = Math.max(max.x, p.x);
            max.y = Math.max(max.y, p.y);
            max.z = Math.max(max.z, p.z);
        }
        if (min.x == Double.MAX_VALUE) {
            rv.setNaN();
        } else {
            rv.setMinimum(min);
            rv.setMaximum(max);
        }
        return rv;
    }

    public static Sphere getBoundingSphere(Sphere rv, Point3[] pa) {
        int N = pa.length;
        if (N == 0) {
            rv.setNaN();
        } else {
            int indexOfCornerI = -1;
            int indexOfCornerJ = -1;
            double maxDistanceSquared = -1.7976931348623157E308;
            for (int i = 0; i < N; ++i) {
                Point3 cornerI = pa[i];
                for (int j = i + 1; j < N; ++j) {
                    Point3 cornerJ = pa[j];
                    double distanceSquared = Point3.calculateDistanceSquaredBetween(cornerI, cornerJ);
                    if (!(distanceSquared > maxDistanceSquared)) continue;
                    indexOfCornerI = i;
                    indexOfCornerJ = j;
                }
            }
            Point3 center = new Point3(0.0, 0.0, 0.0);
            center.add(pa[indexOfCornerI]);
            center.add(pa[indexOfCornerJ]);
            center.multiply(0.5);
            double maxDistanceFromCenterSquared = -1.7976931348623157E308;
            for (Point3 p : pa) {
                double distanceSquared = Point3.calculateDistanceSquaredBetween(p, center);
                maxDistanceFromCenterSquared = Math.max(maxDistanceFromCenterSquared, distanceSquared);
            }
            double radius = Math.sqrt(maxDistanceFromCenterSquared);
            rv.center.set(center);
            rv.radius = radius;
        }
        return rv;
    }

    public static Sphere getBoundingSphere(Sphere rv, Vertex[] va) {
        int N = va.length;
        if (N == 0) {
            rv.setNaN();
        } else {
            int indexOfCornerI = -1;
            int indexOfCornerJ = -1;
            double maxDistanceSquared = -1.7976931348623157E308;
            for (int i = 0; i < N; ++i) {
                Point3 cornerI = va[i].position;
                for (int j = i + 1; j < N; ++j) {
                    Point3 cornerJ = va[j].position;
                    double distanceSquared = Point3.calculateDistanceSquaredBetween(cornerI, cornerJ);
                    if (!(distanceSquared > maxDistanceSquared)) continue;
                    indexOfCornerI = i;
                    indexOfCornerJ = j;
                }
            }
            Point3 center = new Point3(0.0, 0.0, 0.0);
            center.add(va[indexOfCornerI].position);
            center.add(va[indexOfCornerJ].position);
            center.multiply(0.5);
            double maxDistanceFromCenterSquared = -1.7976931348623157E308;
            for (Vertex v : va) {
                double distanceSquared = Point3.calculateDistanceSquaredBetween(v.position, center);
                maxDistanceFromCenterSquared = Math.max(maxDistanceFromCenterSquared, distanceSquared);
            }
            double radius = Math.sqrt(maxDistanceFromCenterSquared);
            rv.center.set(center);
            rv.radius = radius;
        }
        return rv;
    }

    public static Sphere getBoundingSphere(Sphere rv, Vector<Point3> pv) {
        int N = pv.size();
        if (N == 0) {
            rv.setNaN();
        } else {
            AxisAlignedBox bb = new AxisAlignedBox();
            BoundUtilities.getBoundingBox(bb, pv);
            bb.getCenter(rv.center);
            double maxDistanceFromCenterSquared = -1.0;
            for (Point3 p : pv) {
                double distanceSquared = Point3.calculateDistanceSquaredBetween(p, rv.center);
                maxDistanceFromCenterSquared = Math.max(maxDistanceFromCenterSquared, distanceSquared);
            }
            rv.radius = Math.sqrt(maxDistanceFromCenterSquared);
        }
        return rv;
    }
}

