/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.bound;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Hexahedron;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import edu.cmu.cs.dennisc.scenegraph.bound.BoundUtilities;
import java.util.Vector;

public class CumulativeBound {
    private Vector<Point3> m_transformedPoints = new Vector();

    private void addPoint(Point3 p, AffineMatrix4x4 trans) {
        assert (!p.isNaN());
        assert (!trans.isNaN());
        trans.transform(p);
        this.m_transformedPoints.addElement(p);
    }

    public void add(Visual sgVisual, AffineMatrix4x4 trans) {
        AxisAlignedBox box = sgVisual.getAxisAlignedMinimumBoundingBox();
        if (!box.isNaN()) {
            Hexahedron hexahedron = box.getHexahedron();
            for (int i = 0; i < 8; ++i) {
                this.addPoint(hexahedron.getPointAt(i), trans);
            }
        }
    }

    public void addOrigin(AffineMatrix4x4 trans) {
        this.addPoint(Point3.createZero(), trans);
    }

    public Sphere getBoundingSphere(Sphere rv) {
        return BoundUtilities.getBoundingSphere(rv, this.m_transformedPoints);
    }

    public Sphere getBoundingSphere() {
        return this.getBoundingSphere(new Sphere());
    }

    public AxisAlignedBox getBoundingBox(AxisAlignedBox rv) {
        return BoundUtilities.getBoundingBox(rv, this.m_transformedPoints);
    }

    public AxisAlignedBox getBoundingBox() {
        return this.getBoundingBox(new AxisAlignedBox());
    }
}

