/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.io;

import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.image.ImageUtilities;
import edu.cmu.cs.dennisc.io.FileUtilities;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple2f;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Tuple3f;
import edu.cmu.cs.dennisc.math.Vector2f;
import edu.cmu.cs.dennisc.math.Vector3f;
import edu.cmu.cs.dennisc.property.Property;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import edu.cmu.cs.dennisc.scenegraph.io.AbstractPropertyReference;
import edu.cmu.cs.dennisc.scenegraph.io.MatrixUtilities;
import edu.cmu.cs.dennisc.scenegraph.io.PropertyReferenceToElement;
import edu.cmu.cs.dennisc.texture.TextureCoordinate2f;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASG {
    private static final int SMALL_ENOUGH_PRIMATIVE_ARRAY_LENGTH_TO_ENCODE_AS_TEXT = 32;
    private static final String ROOT_FILENAME = "root.xml";
    private static Set<String> s_deadProperties = null;
    private static final String OLD_PACKAGE = "edu.cmu.cs.stage3.";
    public static final double VERSION = 1.0;

    private static boolean isDeadProperty(String property) {
        if (s_deadProperties == null) {
            s_deadProperties = new HashSet<String>();
            s_deadProperties.add("IsFirstClass");
            s_deadProperties.add("OpacityMap");
            s_deadProperties.add("EmissiveColorMap");
            s_deadProperties.add("SpecularHighlightColorMap");
            s_deadProperties.add("BumpMap");
            s_deadProperties.add("DetailMap");
            s_deadProperties.add("Format");
            s_deadProperties.add("VertexLowerBound");
            s_deadProperties.add("VertexUpperBound");
        }
        return s_deadProperties.contains(property);
    }

    private static String convertPropertyIfNecessary(String property) {
        if (property.equals("DiffuseColorMap")) {
            property = "DiffuseColorTexture";
        }
        if (property.equals("Indices")) {
            property = "TriangleData";
        }
        return property;
    }

    private static String convertClassnameIfNecessary(String className) {
        if (className.equals("edu.cmu.cs.stage3.alice.scenegraph.Color")) {
            className = "edu.cmu.cs.dennisc.color.Color4f";
        }
        if (className.startsWith(OLD_PACKAGE)) {
            className = "edu.cmu.cs.dennisc." + className.substring(OLD_PACKAGE.length());
        }
        if (className.startsWith("[Ledu.cmu.cs.stage3.")) {
            className = "[Lorg." + className.substring(2 + OLD_PACKAGE.length());
        }
        if (className.endsWith("Vertex3d;")) {
            className = className.substring(0, className.length() - 3) + ';';
        }
        if (className.endsWith("Vertex3d")) {
            className = className.substring(0, className.length() - 2);
        }
        if (className.endsWith("TextureMap")) {
            className = className.substring(0, className.length() - 3);
        }
        return className;
    }

    public static void encodeVertexArrayInBinary(Vertex[] vertices, OutputStream os) {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(3);
            dos.writeInt(vertices.length);
            for (int i = 0; i < vertices.length; ++i) {
                int format = vertices[i].getFormat();
                dos.writeInt(format);
                if ((format & 1) != 0) {
                    dos.writeDouble(vertices[i].position.x);
                    dos.writeDouble(vertices[i].position.y);
                    dos.writeDouble(vertices[i].position.z);
                }
                if ((format & 2) != 0) {
                    dos.writeDouble(vertices[i].normal.x);
                    dos.writeDouble(vertices[i].normal.y);
                    dos.writeDouble(vertices[i].normal.z);
                }
                if ((format & 4) != 0) {
                    dos.writeFloat(vertices[i].diffuseColor.red);
                    dos.writeFloat(vertices[i].diffuseColor.green);
                    dos.writeFloat(vertices[i].diffuseColor.blue);
                    dos.writeFloat(vertices[i].diffuseColor.alpha);
                }
                if ((format & 8) != 0) {
                    dos.writeFloat(vertices[i].specularHighlightColor.red);
                    dos.writeFloat(vertices[i].specularHighlightColor.green);
                    dos.writeFloat(vertices[i].specularHighlightColor.blue);
                    dos.writeFloat(vertices[i].specularHighlightColor.alpha);
                }
                if ((format & 0x10) == 0) continue;
                dos.writeFloat(vertices[i].textureCoordinate0.u);
                dos.writeFloat(vertices[i].textureCoordinate0.v);
            }
            dos.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Vertex[] decodeVertexArrayInBinary(InputStream is) {
        Vertex[] vertices = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        try {
            int version = dis.readInt();
            if (version == 1) {
                int vertexCount = dis.readInt();
                vertices = new Vertex[vertexCount];
                for (int i = 0; i < vertices.length; ++i) {
                    vertices[i] = new Vertex();
                    vertices[i].position.x = dis.readDouble();
                    vertices[i].position.y = dis.readDouble();
                    vertices[i].position.z = dis.readDouble();
                    vertices[i].normal.x = (float)dis.readDouble();
                    vertices[i].normal.y = (float)dis.readDouble();
                    vertices[i].normal.z = (float)dis.readDouble();
                    vertices[i].textureCoordinate0.u = (float)dis.readDouble();
                    vertices[i].textureCoordinate0.v = (float)dis.readDouble();
                }
            } else if (version == 2) {
                int vertexCount = dis.readInt();
                vertices = new Vertex[vertexCount];
                for (int i = 0; i < vertices.length; ++i) {
                    int format = dis.readInt();
                    vertices[i] = new Vertex();
                    if ((format & 1) != 0) {
                        vertices[i].position.x = dis.readDouble();
                        vertices[i].position.y = dis.readDouble();
                        vertices[i].position.z = dis.readDouble();
                    }
                    if ((format & 2) != 0) {
                        vertices[i].normal.x = (float)dis.readDouble();
                        vertices[i].normal.y = (float)dis.readDouble();
                        vertices[i].normal.z = (float)dis.readDouble();
                    }
                    if ((format & 4) != 0) {
                        vertices[i].diffuseColor.red = (float)dis.readDouble();
                        vertices[i].diffuseColor.green = (float)dis.readDouble();
                        vertices[i].diffuseColor.blue = (float)dis.readDouble();
                        vertices[i].diffuseColor.alpha = (float)dis.readDouble();
                    }
                    if ((format & 8) != 0) {
                        // empty if block
                    }
                    if ((format & 0x10) == 0) continue;
                    vertices[i].textureCoordinate0.u = (float)dis.readDouble();
                    vertices[i].textureCoordinate0.v = (float)dis.readDouble();
                }
            } else if (version == 3) {
                int vertexCount = dis.readInt();
                vertices = new Vertex[vertexCount];
                for (int i = 0; i < vertices.length; ++i) {
                    int format = dis.readInt();
                    vertices[i] = new Vertex();
                    if ((format & 1) != 0) {
                        vertices[i].position.x = dis.readDouble();
                        vertices[i].position.y = dis.readDouble();
                        vertices[i].position.z = dis.readDouble();
                    }
                    if ((format & 2) != 0) {
                        vertices[i].normal.x = (float)dis.readDouble();
                        vertices[i].normal.y = (float)dis.readDouble();
                        vertices[i].normal.z = (float)dis.readDouble();
                    }
                    if ((format & 4) != 0) {
                        vertices[i].diffuseColor.red = dis.readFloat();
                        vertices[i].diffuseColor.green = dis.readFloat();
                        vertices[i].diffuseColor.blue = dis.readFloat();
                        vertices[i].diffuseColor.alpha = dis.readFloat();
                    }
                    if ((format & 8) != 0) {
                        vertices[i].specularHighlightColor.red = dis.readFloat();
                        vertices[i].specularHighlightColor.green = dis.readFloat();
                        vertices[i].specularHighlightColor.blue = dis.readFloat();
                        vertices[i].specularHighlightColor.alpha = dis.readFloat();
                    }
                    if ((format & 0x10) == 0) continue;
                    vertices[i].textureCoordinate0.u = dis.readFloat();
                    vertices[i].textureCoordinate0.v = dis.readFloat();
                }
            } else {
                throw new RuntimeException("invalid file version: " + version);
            }
            return vertices;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeIntArrayInBinary(int[] array, OutputStream os) {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(2);
            dos.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                dos.writeInt(array[i]);
            }
            dos.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static int[] decodeIntArrayInBinary(InputStream is) {
        int[] array = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        try {
            int version = dis.readInt();
            if (version == 1) {
                int faceCount = dis.readInt();
                dis.readInt();
                array = new int[faceCount * 3];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = dis.readInt();
                }
            } else if (version == 2) {
                int i;
                int count = dis.readInt();
                array = new int[count];
                for (i = 0; i < array.length; ++i) {
                    array[i] = dis.readInt();
                }
                for (i = 0; i < array.length; i += 3) {
                    int temp = array[i];
                    array[i] = array[i + 2];
                    array[i + 2] = temp;
                }
            } else {
                throw new RuntimeException("invalid file version: " + version);
            }
            return array;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encodeDoubleArrayInBinary(double[] array, OutputStream os) {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(2);
            dos.writeInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                dos.writeDouble(array[i]);
            }
            dos.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static double[] decodeDoubleArrayInBinary(InputStream is) {
        double[] array = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        try {
            int version = dis.readInt();
            if (version != 1) {
                if (version == 2) {
                    int count = dis.readInt();
                    array = new double[count];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = dis.readDouble();
                    }
                } else {
                    throw new RuntimeException("invalid file version: " + version);
                }
            }
            return array;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static String encodeIntArray(int[] array, int offset, int length, boolean isHexadecimal) {
        StringBuffer buffer = new StringBuffer();
        int index = offset;
        for (int lcv = 0; lcv < length; ++lcv) {
            int value = array[index++];
            String s = isHexadecimal ? Integer.toHexString(value).toUpperCase() : Integer.toString(value);
            buffer.append(s);
            if (lcv >= length - 1) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private static void decodeIntArray(String s, int[] array, int offset, int length, boolean isHexadecimal) {
        int index = offset;
        int begin = 0;
        for (int lcv = 0; lcv < length; ++lcv) {
            int end = s.indexOf(32, begin);
            if (end == -1) {
                end = s.length();
            }
            String substr = s.substring(begin, end);
            int value = isHexadecimal ? (int)Long.parseLong(substr, 16) : Integer.parseInt(substr);
            array[index++] = value;
            begin = end + 1;
        }
    }

    private static String encodeIntArray(int[] array, boolean isHexadecimal) {
        return ASG.encodeIntArray(array, 0, array.length, isHexadecimal);
    }

    private static void decodeIntArray(String s, int[] array, boolean isHexadecimal) {
        ASG.decodeIntArray(s, array, 0, array.length, isHexadecimal);
    }

    private static String encodeDoubleArray(double[] array, int offset, int length) {
        StringBuffer buffer = new StringBuffer();
        int index = offset;
        for (int lcv = 0; lcv < length; ++lcv) {
            buffer.append(Double.toString(array[index++]));
            if (lcv >= length - 1) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private static void decodeDoubleArray(String s, double[] array, int offset, int length) {
        int index = offset;
        int begin = 0;
        for (int lcv = 0; lcv < length; ++lcv) {
            int end = s.indexOf(32, begin);
            if (end == -1) {
                end = s.length();
            }
            String substr = s.substring(begin, end);
            array[index++] = Double.parseDouble(substr);
            begin = end + 1;
        }
    }

    private static String encodeDoubleArray(double[] array) {
        return ASG.encodeDoubleArray(array, 0, array.length);
    }

    private static void decodeDoubleArray(String s, double[] array) {
        ASG.decodeDoubleArray(s, array, 0, array.length);
    }

    private static String encodeTuple3d(Tuple3 tuple3d) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Double.toString(tuple3d.x));
        buffer.append(' ');
        buffer.append(Double.toString(tuple3d.y));
        buffer.append(' ');
        buffer.append(Double.toString(tuple3d.z));
        return buffer.toString();
    }

    private static void decodeTuple3d(String s, Tuple3 tuple3d) {
        int begin = 0;
        int end = s.indexOf(32, begin);
        tuple3d.x = Double.parseDouble(s.substring(begin, end));
        begin = end + 1;
        end = s.indexOf(32, begin);
        tuple3d.y = Double.parseDouble(s.substring(begin, end));
        begin = end + 1;
        end = s.length();
        tuple3d.z = Double.parseDouble(s.substring(begin, end));
    }

    private static String encodeTuple3f(Tuple3f tuple3d) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Double.toString(tuple3d.x));
        buffer.append(' ');
        buffer.append(Double.toString(tuple3d.y));
        buffer.append(' ');
        buffer.append(Double.toString(tuple3d.z));
        return buffer.toString();
    }

    private static void decodeTuple3f(String s, Tuple3f tuple3d) {
        int begin = 0;
        int end = s.indexOf(32, begin);
        tuple3d.x = Float.parseFloat(s.substring(begin, end));
        begin = end + 1;
        end = s.indexOf(32, begin);
        tuple3d.y = Float.parseFloat(s.substring(begin, end));
        begin = end + 1;
        end = s.length();
        tuple3d.z = Float.parseFloat(s.substring(begin, end));
    }

    private static void decodeTuple2f(String s, Tuple2f tuple2f) {
        int begin = 0;
        int end = s.indexOf(32, begin);
        tuple2f.x = Float.parseFloat(s.substring(begin, end));
        begin = end + 1;
        end = s.length();
        tuple2f.y = Float.parseFloat(s.substring(begin, end));
    }

    private static String encodeTexCoord2f(TextureCoordinate2f tc2f) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Float.toString(tc2f.u));
        buffer.append(' ');
        buffer.append(Float.toString(tc2f.v));
        return buffer.toString();
    }

    private static void decodeTexCoord2f(String s, TextureCoordinate2f tc2f) {
        int begin = 0;
        int end = s.indexOf(32, begin);
        tc2f.u = Float.parseFloat(s.substring(begin, end));
        begin = end + 1;
        end = s.length();
        tc2f.v = Float.parseFloat(s.substring(begin, end));
    }

    private static String encodeColor4f(Color4f color4f) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Float.toString(color4f.red));
        buffer.append(' ');
        buffer.append(Float.toString(color4f.green));
        buffer.append(' ');
        buffer.append(Float.toString(color4f.blue));
        buffer.append(' ');
        buffer.append(Float.toString(color4f.alpha));
        return buffer.toString();
    }

    private static void decodeColor4f(String s, Color4f color4f) {
        int begin = 0;
        int end = s.indexOf(32, begin);
        color4f.red = Float.parseFloat(s.substring(begin, end));
        begin = end + 1;
        end = s.indexOf(32, begin);
        color4f.green = Float.parseFloat(s.substring(begin, end));
        begin = end + 1;
        end = s.indexOf(32, begin);
        color4f.blue = Float.parseFloat(s.substring(begin, end));
        begin = end + 1;
        end = s.length();
        color4f.alpha = Float.parseFloat(s.substring(begin, end));
    }

    private static String getKey(Element element) {
        return Integer.toString(element.hashCode());
    }

    private static org.w3c.dom.Element encodeElement(Element element, Document document, String s, HashMap<String, ByteArrayOutputStream> filenameToStreamMap, HashMap<String, Element> keyToElementToBeEncodedMap, boolean isTextAlwaysDesired) {
        org.w3c.dom.Element xmlElement = document.createElement(s);
        Class<?> elementClass = element.getClass();
        xmlElement.setAttribute("class", elementClass.getName());
        xmlElement.setAttribute("key", ASG.getKey(element));
        for (Property<?> property : element.getProperties()) {
            String propertyName = property.getName();
            if (propertyName.equals("Parent") || propertyName.equals("Bonus")) continue;
            org.w3c.dom.Element xmlProperty = document.createElement("property");
            xmlProperty.setAttribute("name", propertyName);
            Object value = property.getValue(element);
            if (value != null) {
                Object[] array;
                org.w3c.dom.Element xmlRow;
                BinaryEncodableAndDecodable m;
                Class<?> propertyValueClass = value.getClass();
                if (Element.class.isAssignableFrom(propertyValueClass)) {
                    String key = Integer.toString(value.hashCode());
                    xmlProperty.setAttribute("key", key);
                    if (!Component.class.isAssignableFrom(propertyValueClass)) {
                        keyToElementToBeEncodedMap.put(key, (Element)value);
                    }
                } else if (AffineMatrix4x4.class.isAssignableFrom(propertyValueClass)) {
                    xmlProperty.setAttribute("class", "edu.cmu.cs.dennisc.math.Matrix4d");
                    m = (AffineMatrix4x4)value;
                    double[] row = new double[4];
                    for (int rowIndex = 0; rowIndex < 4; ++rowIndex) {
                        xmlRow = document.createElement("row");
                        MatrixUtilities.getRow(row, m, rowIndex);
                        xmlRow.appendChild(document.createTextNode(ASG.encodeDoubleArray(row)));
                        xmlProperty.appendChild(xmlRow);
                    }
                } else if (Matrix3x3.class.isAssignableFrom(propertyValueClass)) {
                    xmlProperty.setAttribute("class", "edu.cmu.cs.dennisc.math.Matrix3d");
                    m = (Matrix3x3)value;
                    double[] row = new double[3];
                    for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
                        xmlRow = document.createElement("row");
                        MatrixUtilities.getRow(row, (Matrix3x3)m, rowIndex);
                        xmlRow.appendChild(document.createTextNode(ASG.encodeDoubleArray(row)));
                        xmlProperty.appendChild(xmlRow);
                    }
                } else if (Image.class.isAssignableFrom(propertyValueClass)) {
                    Image image = (Image)value;
                    xmlProperty.setAttribute("class", "java.awt.Image");
                    if (isTextAlwaysDesired) {
                        int width = ImageUtilities.getWidth(image);
                        int height = ImageUtilities.getHeight(image);
                        int[] pixels = ImageUtilities.getPixels(image, width, height);
                        xmlProperty.setAttribute("width", Integer.toString(width));
                        xmlProperty.setAttribute("height", Integer.toString(width));
                        int pixelIndex = 0;
                        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
                            org.w3c.dom.Element xmlRow2 = document.createElement("row");
                            xmlRow2.appendChild(document.createTextNode(ASG.encodeIntArray(pixels, pixelIndex, width, true)));
                            pixelIndex += width;
                            xmlProperty.appendChild(xmlRow2);
                        }
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageUtilities.write("png", baos, image);
                        String filename = image.hashCode() + ".png";
                        xmlProperty.setAttribute("filename", filename);
                        filenameToStreamMap.put(filename, baos);
                    }
                } else if (Color4f.class.isAssignableFrom(propertyValueClass)) {
                    xmlProperty.setAttribute("class", "edu.cmu.cs.dennisc.color.Color4f");
                    Color4f color = (Color4f)value;
                    org.w3c.dom.Element xmlRed = document.createElement("red");
                    xmlRed.appendChild(document.createTextNode(Float.toString(color.red)));
                    xmlProperty.appendChild(xmlRed);
                    org.w3c.dom.Element xmlGreen = document.createElement("green");
                    xmlGreen.appendChild(document.createTextNode(Float.toString(color.green)));
                    xmlProperty.appendChild(xmlGreen);
                    org.w3c.dom.Element xmlBlue = document.createElement("blue");
                    xmlBlue.appendChild(document.createTextNode(Float.toString(color.blue)));
                    xmlProperty.appendChild(xmlBlue);
                    org.w3c.dom.Element xmlAlpha = document.createElement("alpha");
                    xmlAlpha.appendChild(document.createTextNode(Float.toString(color.alpha)));
                    xmlProperty.appendChild(xmlAlpha);
                } else if (int[].class.isAssignableFrom(propertyValueClass)) {
                    array = (int[])value;
                    xmlProperty.setAttribute("class", "[I");
                    if (isTextAlwaysDesired || array.length < 32) {
                        xmlProperty.setAttribute("length", Integer.toString(array.length));
                        xmlProperty.appendChild(document.createTextNode(ASG.encodeIntArray((int[])array, false)));
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ASG.encodeIntArrayInBinary((int[])array, baos);
                        String filename = "int array " + array.hashCode() + ".bin";
                        xmlProperty.setAttribute("filename", filename);
                        filenameToStreamMap.put(filename, baos);
                    }
                } else if (double[].class.isAssignableFrom(propertyValueClass)) {
                    array = (double[])value;
                    xmlProperty.setAttribute("class", "[D");
                    if (isTextAlwaysDesired || array.length < 32) {
                        xmlProperty.setAttribute("length", Integer.toString(array.length));
                        xmlProperty.appendChild(document.createTextNode(ASG.encodeDoubleArray((double[])array)));
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ASG.encodeDoubleArrayInBinary((double[])array, baos);
                        String filename = "double array " + array.hashCode() + ".bin";
                        xmlProperty.setAttribute("filename", filename);
                        filenameToStreamMap.put(filename, baos);
                    }
                } else if (Vertex[].class.isAssignableFrom(propertyValueClass)) {
                    array = (Vertex[])value;
                    xmlProperty.setAttribute("class", "[Ledu.cmu.cs.dennisc.scenegraph.Vertex;");
                    if (isTextAlwaysDesired || array.length == 0) {
                        for (int i = 0; i < array.length; ++i) {
                            org.w3c.dom.Element xmlVertex = document.createElement("vertex");
                            Object vertex = array[i];
                            if (((Vertex)vertex).position != null) {
                                org.w3c.dom.Element xmlPosition = document.createElement("position");
                                xmlPosition.appendChild(document.createTextNode(ASG.encodeTuple3d(((Vertex)vertex).position)));
                                xmlVertex.appendChild(xmlPosition);
                            }
                            if (((Vertex)vertex).normal != null) {
                                org.w3c.dom.Element xmlNormal = document.createElement("normal");
                                xmlNormal.appendChild(document.createTextNode(ASG.encodeTuple3f(((Vertex)vertex).normal)));
                                xmlVertex.appendChild(xmlNormal);
                            }
                            if (((Vertex)vertex).diffuseColor != null) {
                                org.w3c.dom.Element xmlDiffuseColor = document.createElement("diffuseColor");
                                xmlDiffuseColor.appendChild(document.createTextNode(ASG.encodeColor4f(((Vertex)vertex).diffuseColor)));
                                xmlVertex.appendChild(xmlDiffuseColor);
                            }
                            if (((Vertex)vertex).textureCoordinate0 != null) {
                                org.w3c.dom.Element xmlTextureCoordinate0 = document.createElement("textureCoordinate0");
                                xmlTextureCoordinate0.appendChild(document.createTextNode(ASG.encodeTexCoord2f(((Vertex)vertex).textureCoordinate0)));
                                xmlVertex.appendChild(xmlTextureCoordinate0);
                            }
                            xmlProperty.appendChild(xmlVertex);
                        }
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ASG.encodeVertexArrayInBinary((Vertex[])array, baos);
                        String filename = "Vertex array " + array.hashCode() + ".bin";
                        xmlProperty.setAttribute("filename", filename);
                        filenameToStreamMap.put(filename, baos);
                    }
                } else {
                    xmlProperty.setAttribute("class", propertyValueClass.getName());
                    xmlProperty.appendChild(document.createTextNode(value.toString()));
                }
            }
            xmlElement.appendChild(xmlProperty);
        }
        return xmlElement;
    }

    private static org.w3c.dom.Element encodeComponent(Component component, Document document, String s, HashMap<String, ByteArrayOutputStream> filenameToStreamMap, HashMap<String, Element> keyToElementToBeEncodedMap, boolean isTextAlwaysDesired) {
        org.w3c.dom.Element xmlComponent = ASG.encodeElement(component, document, s, filenameToStreamMap, keyToElementToBeEncodedMap, isTextAlwaysDesired);
        if (component instanceof Composite) {
            Composite sgComposite = (Composite)component;
            for (Component sgComponent : sgComposite.accessComponents()) {
                xmlComponent.appendChild(ASG.encodeComponent(sgComponent, document, "child", filenameToStreamMap, keyToElementToBeEncodedMap, isTextAlwaysDesired));
            }
        }
        return xmlComponent;
    }

    private static void encodeInternal(Component component, OutputStream os, HashMap<String, ByteArrayOutputStream> filenameToStreamMap, boolean isTextAlwaysDesired) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            HashMap<String, Element> keyToElementToBeEncodedMap = new HashMap<String, Element>();
            org.w3c.dom.Element rootNode = ASG.encodeComponent(component, document, "root", filenameToStreamMap, keyToElementToBeEncodedMap, isTextAlwaysDesired);
            rootNode.setAttribute("version", Double.toString(1.0));
            while (keyToElementToBeEncodedMap.size() > 0) {
                HashMap<String, Element> tempCopy = new HashMap<String, Element>(keyToElementToBeEncodedMap);
                for (String key : tempCopy.keySet()) {
                    Element element = tempCopy.get(key);
                    rootNode.appendChild(ASG.encodeElement(element, document, "element", filenameToStreamMap, keyToElementToBeEncodedMap, isTextAlwaysDesired));
                    keyToElementToBeEncodedMap.remove(key);
                }
            }
            document.appendChild(rootNode);
            document.getDocumentElement().normalize();
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                trans.transform(new DOMSource(document), new StreamResult(os));
            }
            catch (TransformerException te) {
                throw new RuntimeException(te);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    public static void encode(Component component, OutputStream os) {
        HashMap<String, ByteArrayOutputStream> filenameToStreamMap = new HashMap<String, ByteArrayOutputStream>();
        ByteArrayOutputStream rootBAOS = new ByteArrayOutputStream();
        ASG.encodeInternal(component, rootBAOS, filenameToStreamMap, false);
        filenameToStreamMap.put(ROOT_FILENAME, rootBAOS);
        ZipOutputStream zos = os instanceof ZipOutputStream ? (ZipOutputStream)os : new ZipOutputStream(os);
        CRC32 crc32 = new CRC32();
        try {
            for (String filename : filenameToStreamMap.keySet()) {
                int method;
                ByteArrayOutputStream baos = filenameToStreamMap.get(filename);
                baos.flush();
                byte[] ba = baos.toByteArray();
                ZipEntry zipEntry = new ZipEntry(filename);
                if (filename.endsWith(".png")) {
                    crc32.reset();
                    crc32.update(ba);
                    zipEntry.setCrc(crc32.getValue());
                    zipEntry.setSize(ba.length);
                    method = 0;
                } else {
                    method = 8;
                }
                zos.setMethod(method);
                zos.putNextEntry(zipEntry);
                zos.write(ba, 0, ba.length);
                zos.closeEntry();
            }
            zos.flush();
            zos.finish();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encode(Component component, File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            ASG.encode(component, os);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void encode(Component component, String path) {
        ASG.encode(component, new File(path));
    }

    private static org.w3c.dom.Element getFirstChild(Node node, String tag) {
        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!(childNode instanceof org.w3c.dom.Element) || !childNode.getNodeName().equals(tag)) continue;
            return (org.w3c.dom.Element)childNode;
        }
        return null;
    }

    private static org.w3c.dom.Element[] getChildren(Node node, String tag) {
        Vector<org.w3c.dom.Element> vector = new Vector<org.w3c.dom.Element>();
        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!(childNode instanceof org.w3c.dom.Element) || !childNode.getNodeName().equals(tag)) continue;
            vector.addElement((org.w3c.dom.Element)childNode);
        }
        Object[] array = new org.w3c.dom.Element[vector.size()];
        vector.copyInto(array);
        return array;
    }

    private static String getNodeText(Node node) {
        StringBuffer propertyTextBuffer = new StringBuffer();
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Text textNode = (Text)children.item(j);
            propertyTextBuffer.append(textNode.getData().trim());
        }
        return propertyTextBuffer.toString();
    }

    private static Object valueOf(Class<?> cls, String text) {
        if (String.class.isAssignableFrom(cls)) {
            return text;
        }
        if (cls.equals(Double.class) && text.equals("Infinity")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (cls.equals(Double.class) && text.equals("NaN")) {
            return new Double(Double.NaN);
        }
        Class[] parameterTypes = new Class[]{String.class};
        try {
            Method valueOfMethod = cls.getMethod("valueOf", parameterTypes);
            int modifiers = valueOfMethod.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                Object[] parameters = new Object[]{text};
                return valueOfMethod.invoke(null, parameters);
            }
            throw new RuntimeException("valueOf method not public static.");
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("NoSuchMethodException: class[" + cls.getName() + "]; method[" + text + "]");
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException: " + cls + " " + text);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("java.lang.reflect.InvocationTargetException: " + cls + " " + text);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element decodeElement(org.w3c.dom.Element xmlElement, HashMap<String, InputStream> filenameToStreamMap, HashMap<Integer, Element> keyToElementMap, Vector<AbstractPropertyReference> referencesToBeResolved) {
        String className = xmlElement.getAttribute("class");
        Integer elementKey = Integer.parseInt(xmlElement.getAttribute("key"));
        String elementName = xmlElement.getAttribute("name");
        className = ASG.convertClassnameIfNecessary(className);
        Element sgElement = (Element)ReflectionUtilities.newInstance(className);
        sgElement.setName(elementName);
        keyToElementMap.put(elementKey, sgElement);
        org.w3c.dom.Element[] xmlProperties = ASG.getChildren(xmlElement, "property");
        for (int propertyIndex = 0; propertyIndex < xmlProperties.length; ++propertyIndex) {
            org.w3c.dom.Element xmlProperty = xmlProperties[propertyIndex];
            String propertyName = xmlProperty.getAttribute("name");
            if (ASG.isDeadProperty(propertyName = ASG.convertPropertyIfNecessary(propertyName))) continue;
            Property<?> property = sgElement.getPropertyNamed(propertyName);
            if (xmlProperty.hasAttribute("class")) {
                void var15_15;
                String propertyValueClassname = xmlProperty.getAttribute("class");
                propertyValueClassname = ASG.convertClassnameIfNecessary(propertyValueClassname);
                Class<?> propertyValueClass = ReflectionUtilities.getClassForName(propertyValueClassname);
                if (xmlProperty.hasAttribute("filename")) {
                    String filename = xmlProperty.getAttribute("filename");
                    InputStream is = filenameToStreamMap.get(filename);
                    if (is == null) throw new RuntimeException();
                    if (Image.class.isAssignableFrom(propertyValueClass)) {
                        String ext = FileUtilities.getExtension(filename);
                        String string = ImageUtilities.getCodecNameForExtension(ext);
                        BufferedImage bufferedImage = ImageUtilities.read(string, is);
                    } else if (Vertex[].class.isAssignableFrom(propertyValueClass)) {
                        Vertex[] vertexArray = ASG.decodeVertexArrayInBinary(is);
                    } else if (int[].class.isAssignableFrom(propertyValueClass)) {
                        int[] nArray = ASG.decodeIntArrayInBinary(is);
                    } else {
                        if (!double[].class.isAssignableFrom(propertyValueClass)) throw new RuntimeException();
                        double[] dArray = ASG.decodeDoubleArrayInBinary(is);
                    }
                } else if (AffineMatrix4x4.class.isAssignableFrom(propertyValueClass)) {
                    void var19_63;
                    AffineMatrix4x4 m = AffineMatrix4x4.createNaN();
                    org.w3c.dom.Element[] xmlRows = ASG.getChildren(xmlProperty, "row");
                    double[] row = new double[4];
                    boolean bl = false;
                    while (var19_63 < 4) {
                        ASG.decodeDoubleArray(ASG.getNodeText(xmlRows[var19_63]), row);
                        MatrixUtilities.setRow(m, (int)var19_63, row);
                        ++var19_63;
                    }
                    AffineMatrix4x4 affineMatrix4x4 = m;
                } else if (Matrix3x3.class.isAssignableFrom(propertyValueClass)) {
                    void var19_65;
                    Matrix3x3 m = Matrix3x3.createNaN();
                    org.w3c.dom.Element[] xmlRows = ASG.getChildren(xmlProperty, "row");
                    double[] row = new double[3];
                    boolean bl = false;
                    while (var19_65 < 3) {
                        ASG.decodeDoubleArray(ASG.getNodeText(xmlRows[var19_65]), row);
                        MatrixUtilities.setRow(m, (int)var19_65, row);
                        ++var19_65;
                    }
                    Matrix3x3 matrix3x3 = m;
                } else if (Image.class.isAssignableFrom(propertyValueClass)) {
                    int width = Integer.parseInt(xmlProperty.getAttribute("width"));
                    int height = Integer.parseInt(xmlProperty.getAttribute("height"));
                    org.w3c.dom.Element[] xmlRows = ASG.getChildren(xmlProperty, "row");
                    int[] nArray = new int[width * height];
                    int pixelIndex = 0;
                    for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
                        String s = ASG.getNodeText(xmlRows[rowIndex]);
                        ASG.decodeIntArray(s, nArray, pixelIndex, width, true);
                        pixelIndex += width;
                    }
                    Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, nArray, 0, width));
                } else if (Color4f.class.isAssignableFrom(propertyValueClass)) {
                    Color4f sgColor = new Color4f();
                    sgColor.red = Float.parseFloat(ASG.getNodeText(ASG.getFirstChild(xmlProperty, "red")));
                    sgColor.green = Float.parseFloat(ASG.getNodeText(ASG.getFirstChild(xmlProperty, "green")));
                    sgColor.blue = Float.parseFloat(ASG.getNodeText(ASG.getFirstChild(xmlProperty, "blue")));
                    sgColor.alpha = Float.parseFloat(ASG.getNodeText(ASG.getFirstChild(xmlProperty, "alpha")));
                    Color4f color4f = sgColor;
                } else if (int[].class.isAssignableFrom(propertyValueClass)) {
                    int length = Integer.parseInt(xmlProperty.getAttribute("length"));
                    int[] array = new int[length];
                    ASG.decodeIntArray(ASG.getNodeText(xmlProperty), array, false);
                    int[] nArray = array;
                } else if (double[].class.isAssignableFrom(propertyValueClass)) {
                    int length = Integer.parseInt(xmlProperty.getAttribute("length"));
                    double[] array = new double[length];
                    ASG.decodeDoubleArray(ASG.getNodeText(xmlProperty), array);
                    double[] dArray = array;
                } else if (Point3[].class.isAssignableFrom(propertyValueClass)) {
                    org.w3c.dom.Element[] xmlPoints = ASG.getChildren(xmlProperty, "point");
                    Point3[] array = new Point3[xmlPoints.length];
                    for (int tupleIndex = 0; tupleIndex < xmlPoints.length; ++tupleIndex) {
                        Point3 point3 = new Point3();
                        ASG.decodeTuple3d(ASG.getNodeText(xmlPoints[tupleIndex]), point3);
                        array[tupleIndex] = point3;
                    }
                    Point3[] point3Array = array;
                } else if (Vector3f[].class.isAssignableFrom(propertyValueClass)) {
                    org.w3c.dom.Element[] xmlNormals = ASG.getChildren(xmlProperty, "normal");
                    Vector3f[] array = new Vector3f[xmlNormals.length];
                    for (int tupleIndex = 0; tupleIndex < xmlNormals.length; ++tupleIndex) {
                        Vector3f vector3f = new Vector3f();
                        ASG.decodeTuple3f(ASG.getNodeText(xmlNormals[tupleIndex]), vector3f);
                        array[tupleIndex] = vector3f;
                    }
                    Vector3f[] vector3fArray = array;
                } else if (Vector2f[].class.isAssignableFrom(propertyValueClass)) {
                    org.w3c.dom.Element[] xmlTextureCoords = ASG.getChildren(xmlProperty, "textureCoordinate");
                    Vector2f[] array = new Vector2f[xmlTextureCoords.length];
                    for (int tupleIndex = 0; tupleIndex < xmlTextureCoords.length; ++tupleIndex) {
                        Vector2f vector2f = new Vector2f();
                        ASG.decodeTuple2f(ASG.getNodeText(xmlTextureCoords[tupleIndex]), vector2f);
                        array[tupleIndex] = vector2f;
                    }
                    Vector2f[] vector2fArray = array;
                } else if (Vertex[].class.isAssignableFrom(propertyValueClass)) {
                    org.w3c.dom.Element[] xmlVertices = ASG.getChildren(xmlProperty, "vertex");
                    Vertex[] array = new Vertex[xmlVertices.length];
                    for (int vertexIndex = 0; vertexIndex < xmlVertices.length; ++vertexIndex) {
                        org.w3c.dom.Element xmlTextureCoordinate0;
                        org.w3c.dom.Element xmlDiffuseColor;
                        org.w3c.dom.Element xmlNormal;
                        Vertex vertex = new Vertex();
                        org.w3c.dom.Element xmlVertex = xmlVertices[vertexIndex];
                        org.w3c.dom.Element xmlPosition = ASG.getFirstChild(xmlVertex, "position");
                        if (xmlPosition != null) {
                            vertex.position.setNaN();
                            ASG.decodeTuple3d(ASG.getNodeText(xmlPosition), vertex.position);
                        }
                        if ((xmlNormal = ASG.getFirstChild(xmlVertex, "normal")) != null) {
                            vertex.normal.setNaN();
                            ASG.decodeTuple3f(ASG.getNodeText(xmlNormal), vertex.normal);
                        }
                        if ((xmlDiffuseColor = ASG.getFirstChild(xmlVertex, "diffuseColor")) != null) {
                            vertex.diffuseColor.setNaN();
                            ASG.decodeColor4f(ASG.getNodeText(xmlDiffuseColor), vertex.diffuseColor);
                        }
                        if ((xmlTextureCoordinate0 = ASG.getFirstChild(xmlVertex, "textureCoordinate0")) != null) {
                            vertex.textureCoordinate0.setNaN();
                            ASG.decodeTexCoord2f(ASG.getNodeText(xmlTextureCoordinate0), vertex.textureCoordinate0);
                        }
                        array[vertexIndex] = vertex;
                    }
                    Vertex[] vertexArray = array;
                } else {
                    Object object = ASG.valueOf(propertyValueClass, ASG.getNodeText(xmlProperty));
                }
                property.setValue(sgElement, var15_15);
                continue;
            }
            if (xmlProperty.hasAttribute("key")) {
                Integer key = Integer.parseInt(xmlProperty.getAttribute("key"));
                referencesToBeResolved.addElement(new PropertyReferenceToElement(sgElement, property, key));
                continue;
            }
            property.setValue(sgElement, null);
        }
        return sgElement;
    }

    private static Component decodeComponent(org.w3c.dom.Element xmlComponent, HashMap<String, InputStream> filenameToStreamMap, HashMap<Integer, Element> keyToElementMap, Vector<AbstractPropertyReference> referencesToBeResolved) {
        Component sgComponent = (Component)ASG.decodeElement(xmlComponent, filenameToStreamMap, keyToElementMap, referencesToBeResolved);
        org.w3c.dom.Element[] xmlChildren = ASG.getChildren(xmlComponent, "child");
        for (int i = 0; i < xmlChildren.length; ++i) {
            ASG.decodeComponent(xmlChildren[i], filenameToStreamMap, keyToElementMap, referencesToBeResolved).setParent((Composite)sgComponent);
        }
        return sgComponent;
    }

    private static Component decodeInternal(InputStream is, HashMap<String, InputStream> filenameToStreamMap) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            org.w3c.dom.Element xmlRoot = document.getDocumentElement();
            HashMap<Integer, Element> keyToElementMap = new HashMap<Integer, Element>();
            Vector<AbstractPropertyReference> referencesToBeResolved = new Vector<AbstractPropertyReference>();
            Component sgRoot = ASG.decodeComponent(xmlRoot, filenameToStreamMap, keyToElementMap, referencesToBeResolved);
            org.w3c.dom.Element[] xmlElements = ASG.getChildren(xmlRoot, "element");
            for (int i = 0; i < xmlElements.length; ++i) {
                ASG.decodeElement(xmlElements[i], filenameToStreamMap, keyToElementMap, referencesToBeResolved);
            }
            for (AbstractPropertyReference propertyReference : referencesToBeResolved) {
                propertyReference.resolve(keyToElementMap);
            }
            return sgRoot;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (SAXException saxe) {
            throw new RuntimeException(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    public static Component decode(InputStream is, HashMap<String, InputStream> filenameToStreamMap) {
        BufferedInputStream bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        return ASG.decodeInternal(bis, filenameToStreamMap);
    }

    public static Component decodeZip(InputStream is) {
        ZipInputStream zis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
        HashMap<String, InputStream> filenameToStreamMap = new HashMap<String, InputStream>();
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                int count;
                String name = zipEntry.getName();
                if (zipEntry.isDirectory()) continue;
                int BUFFER_SIZE = 2048;
                byte[] buffer = new byte[2048];
                ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
                while ((count = zis.read(buffer, 0, 2048)) != -1) {
                    baos.write(buffer, 0, count);
                }
                zis.closeEntry();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                filenameToStreamMap.put(name, bais);
            }
            InputStream rootIS = (InputStream)filenameToStreamMap.get(ROOT_FILENAME);
            if (rootIS == null) {
                throw new RuntimeException(ROOT_FILENAME);
            }
            filenameToStreamMap.remove(ROOT_FILENAME);
            return ASG.decode(rootIS, filenameToStreamMap);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Component decode(File file) {
        try {
            try {
                ZipFile zipFile = new ZipFile(file);
                zipFile.close();
                return ASG.decodeZip(new ZipInputStream(new FileInputStream(file)));
            }
            catch (ZipException ze) {
                HashMap<String, InputStream> filenameToStreamMap = new HashMap<String, InputStream>();
                return ASG.decode(new FileInputStream(file), filenameToStreamMap);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Component decode(String path) {
        return ASG.decode(new File(path));
    }
}

