/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.io;

import edu.cmu.cs.dennisc.scenegraph.Vertex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BIN {
    public static Vertex[] loadVertices(InputStream is) throws IOException {
        Vertex[] vertices = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        int version = dis.readInt();
        if (version == 1) {
            int vertexCount = dis.readInt();
            vertices = new Vertex[vertexCount];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = new Vertex();
                vertices[i].position.x = dis.readDouble();
                vertices[i].position.y = dis.readDouble();
                vertices[i].position.z = dis.readDouble();
                vertices[i].normal.x = (float)dis.readDouble();
                vertices[i].normal.y = (float)dis.readDouble();
                vertices[i].normal.z = (float)dis.readDouble();
                vertices[i].textureCoordinate0.u = (float)dis.readDouble();
                vertices[i].textureCoordinate0.v = (float)dis.readDouble();
            }
        } else if (version == 2) {
            int vertexCount = dis.readInt();
            vertices = new Vertex[vertexCount];
            for (int i = 0; i < vertices.length; ++i) {
                int format = dis.readInt();
                vertices[i] = new Vertex();
                if ((format & 1) != 0) {
                    vertices[i].position.x = dis.readDouble();
                    vertices[i].position.y = dis.readDouble();
                    vertices[i].position.z = dis.readDouble();
                }
                if ((format & 2) != 0) {
                    vertices[i].normal.x = (float)dis.readDouble();
                    vertices[i].normal.y = (float)dis.readDouble();
                    vertices[i].normal.z = (float)dis.readDouble();
                }
                if ((format & 4) != 0) {
                    vertices[i].diffuseColor.red = (float)dis.readDouble();
                    vertices[i].diffuseColor.green = (float)dis.readDouble();
                    vertices[i].diffuseColor.blue = (float)dis.readDouble();
                    vertices[i].diffuseColor.alpha = (float)dis.readDouble();
                }
                if ((format & 8) != 0) {
                    // empty if block
                }
                if ((format & 0x10) == 0) continue;
                vertices[i].textureCoordinate0.u = (float)dis.readDouble();
                vertices[i].textureCoordinate0.v = (float)dis.readDouble();
            }
        } else if (version == 3) {
            int vertexCount = dis.readInt();
            vertices = new Vertex[vertexCount];
            for (int i = 0; i < vertices.length; ++i) {
                int format = dis.readInt();
                vertices[i] = new Vertex();
                if ((format & 1) != 0) {
                    vertices[i].position.x = dis.readDouble();
                    vertices[i].position.y = dis.readDouble();
                    vertices[i].position.z = dis.readDouble();
                }
                if ((format & 2) != 0) {
                    vertices[i].normal.x = (float)dis.readDouble();
                    vertices[i].normal.y = (float)dis.readDouble();
                    vertices[i].normal.z = (float)dis.readDouble();
                }
                if ((format & 4) != 0) {
                    vertices[i].diffuseColor.red = dis.readFloat();
                    vertices[i].diffuseColor.green = dis.readFloat();
                    vertices[i].diffuseColor.blue = dis.readFloat();
                    vertices[i].diffuseColor.alpha = dis.readFloat();
                }
                if ((format & 8) != 0) {
                    vertices[i].specularHighlightColor.red = dis.readFloat();
                    vertices[i].specularHighlightColor.green = dis.readFloat();
                    vertices[i].specularHighlightColor.blue = dis.readFloat();
                    vertices[i].specularHighlightColor.alpha = dis.readFloat();
                }
                if ((format & 0x10) == 0) continue;
                vertices[i].textureCoordinate0.u = dis.readFloat();
                vertices[i].textureCoordinate0.v = dis.readFloat();
            }
        } else {
            throw new RuntimeException("invalid file version: " + version);
        }
        return vertices;
    }

    public static void storeVertices(Vertex[] vertices, OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(3);
        dos.writeInt(vertices.length);
        for (int i = 0; i < vertices.length; ++i) {
            int format = vertices[i].getFormat();
            dos.writeInt(format);
            if ((format & 1) != 0) {
                dos.writeDouble(vertices[i].position.x);
                dos.writeDouble(vertices[i].position.y);
                dos.writeDouble(vertices[i].position.z);
            }
            if ((format & 2) != 0) {
                dos.writeDouble(vertices[i].normal.x);
                dos.writeDouble(vertices[i].normal.y);
                dos.writeDouble(vertices[i].normal.z);
            }
            if ((format & 4) != 0) {
                dos.writeFloat(vertices[i].diffuseColor.red);
                dos.writeFloat(vertices[i].diffuseColor.green);
                dos.writeFloat(vertices[i].diffuseColor.blue);
                dos.writeFloat(vertices[i].diffuseColor.alpha);
            }
            if ((format & 8) != 0) {
                dos.writeFloat(vertices[i].specularHighlightColor.red);
                dos.writeFloat(vertices[i].specularHighlightColor.green);
                dos.writeFloat(vertices[i].specularHighlightColor.blue);
                dos.writeFloat(vertices[i].specularHighlightColor.alpha);
            }
            if ((format & 0x10) == 0) continue;
            dos.writeFloat(vertices[i].textureCoordinate0.u);
            dos.writeFloat(vertices[i].textureCoordinate0.v);
        }
        dos.flush();
    }

    public static int[] loadTriangleData(InputStream is) throws IOException {
        int[] indices = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        int version = dis.readInt();
        if (version == 1) {
            int faceCount = dis.readInt();
            int verticesPerFace = dis.readInt();
            indices = new int[faceCount * verticesPerFace];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = dis.readInt();
            }
        } else if (version == 2) {
            int indicesCount = dis.readInt();
            indices = new int[indicesCount];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = dis.readInt();
            }
        } else {
            throw new RuntimeException("invalid file version: " + version);
        }
        return indices;
    }

    public static void storeTriangleData(int[] indices, OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(2);
        dos.writeInt(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            dos.writeInt(indices[i]);
        }
        dos.flush();
    }
}

