/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.io;

import edu.cmu.cs.dennisc.scenegraph.Vertex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VFB {
    public static Vertex[] loadVertices(InputStream is) throws IOException, FileNotFoundException {
        return (Vertex[])VFB.load(new BufferedInputStream(is))[0];
    }

    public static int[] loadIndices(InputStream is) throws IOException, FileNotFoundException {
        return (int[])VFB.load(new BufferedInputStream(is))[1];
    }

    public static Object[] load(BufferedInputStream bis) throws IOException, FileNotFoundException {
        int nByteCount = bis.available();
        byte[] byteArray = new byte[nByteCount];
        bis.read(byteArray);
        for (int nByteIndex = 0; nByteIndex < nByteCount; nByteIndex += 4) {
            byte b = byteArray[nByteIndex];
            byteArray[nByteIndex] = byteArray[nByteIndex + 3];
            byteArray[nByteIndex + 3] = b;
            b = byteArray[nByteIndex + 1];
            byteArray[nByteIndex + 1] = byteArray[nByteIndex + 2];
            byteArray[nByteIndex + 2] = b;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        DataInputStream dis = new DataInputStream(bais);
        Object[] verticesAndIndices = new Object[]{null, null};
        int nVersion = dis.readInt();
        if (nVersion == 1) {
            int vertexCount = dis.readInt();
            Vertex[] vertices = new Vertex[vertexCount];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = new Vertex();
                vertices[i].position.x = -dis.readFloat();
                vertices[i].position.y = dis.readFloat();
                vertices[i].position.z = dis.readFloat();
                vertices[i].normal.x = -dis.readFloat();
                vertices[i].normal.y = dis.readFloat();
                vertices[i].normal.z = dis.readFloat();
                vertices[i].textureCoordinate0.u = dis.readFloat();
                vertices[i].textureCoordinate0.v = dis.readFloat();
            }
            int faceCount = dis.readInt();
            dis.readInt();
            int verticesPerFace = dis.readInt();
            int[] indices = new int[faceCount * 3];
            int i = 0;
            for (int f = 0; f < faceCount; ++f) {
                int length = verticesPerFace == 0 ? dis.readInt() : verticesPerFace;
                indices[i + 0] = dis.readInt();
                indices[i + 1] = dis.readInt();
                indices[i + 2] = dis.readInt();
                i += 3;
                for (int lcv = 3; lcv < length; ++lcv) {
                    dis.readInt();
                }
            }
            verticesAndIndices[0] = vertices;
            verticesAndIndices[1] = indices;
        }
        return verticesAndIndices;
    }

    private static void store(BufferedOutputStream bos, int i) throws IOException {
        bos.write((byte)(i & 0xFF));
        bos.write((byte)(i >> 8 & 0xFF));
        bos.write((byte)(i >> 16 & 0xFF));
        bos.write((byte)(i >> 24 & 0xFF));
    }

    private static void store(BufferedOutputStream bos, float f) throws IOException {
        VFB.store(bos, Float.floatToIntBits(f));
    }

    public static void store(OutputStream os, Vertex[] vertices, int[] indices) throws IOException {
        int i;
        BufferedOutputStream bos = new BufferedOutputStream(os);
        VFB.store(bos, 1);
        if (vertices != null) {
            VFB.store(bos, vertices.length);
            for (i = 0; i < vertices.length; ++i) {
                VFB.store(bos, (float)vertices[i].position.x);
                VFB.store(bos, (float)vertices[i].position.y);
                VFB.store(bos, (float)vertices[i].position.z);
                VFB.store(bos, vertices[i].normal.x);
                VFB.store(bos, vertices[i].normal.y);
                VFB.store(bos, vertices[i].normal.z);
                VFB.store(bos, vertices[i].textureCoordinate0.u);
                VFB.store(bos, vertices[i].textureCoordinate0.v);
            }
        } else {
            VFB.store(bos, 0);
        }
        if (indices != null) {
            VFB.store(bos, indices.length / 3);
            VFB.store(bos, indices.length);
            VFB.store(bos, 3);
            for (i = 0; i < indices.length; i += 3) {
                VFB.store(bos, indices[i + 2]);
                VFB.store(bos, indices[i + 1]);
                VFB.store(bos, indices[i]);
            }
        } else {
            VFB.store(bos, 0);
        }
        bos.flush();
    }
}

