/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.scale;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.pattern.Criterion;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.Visual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleUtilities {
    private static void applyScale(Component sgRoot, Component sgComponent, Vector3 axis, Criterion<Component> inclusionCriterion) {
        if (inclusionCriterion == null || inclusionCriterion.accept(sgComponent)) {
            if (sgComponent instanceof Composite) {
                Transformable sgTransformable;
                Composite sgComposite = (Composite)sgComponent;
                if (sgComposite instanceof Transformable && sgRoot != (sgTransformable = (Transformable)sgComposite)) {
                    AffineMatrix4x4 m = (AffineMatrix4x4)sgTransformable.localTransformation.getValue();
                    m.translation.multiply(axis);
                    sgTransformable.localTransformation.setValue(m);
                }
                int N = sgComposite.getComponentCount();
                for (int i = 0; i < N; ++i) {
                    ScaleUtilities.applyScale(sgRoot, sgComposite.getComponentAt(i), axis, inclusionCriterion);
                }
            } else if (sgComponent instanceof Visual) {
                Visual sgVisual = (Visual)sgComponent;
                Matrix3x3 scale = (Matrix3x3)sgVisual.scale.getValue();
                edu.cmu.cs.dennisc.math.ScaleUtilities.applyScale(scale, (Tuple3)axis);
                sgVisual.scale.setValue(scale);
            }
        }
    }

    public static void applyScale(Component sgComponent, Vector3 axis, Criterion<Component> inclusionCriterion) {
        ScaleUtilities.applyScale(sgComponent, sgComponent, axis, inclusionCriterion);
    }
}

