/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.util;

import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.scenegraph.Cylinder;
import edu.cmu.cs.dennisc.scenegraph.SingleAppearance;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.util.Arrow;
import java.util.HashMap;
import java.util.Map;

public class ExtravagantAxes
extends Transformable {
    private static Map<Cylinder.BottomToTopAxis, SingleAppearance> s_axisToSGAppearanceMap = new HashMap<Cylinder.BottomToTopAxis, SingleAppearance>();

    private Arrow createArrow(double unit, double lengthFactor, Cylinder.BottomToTopAxis bottomToTopAxis) {
        double lengthCylinder = unit * lengthFactor * 0.8;
        double radiusCylinder = unit * 0.05;
        double lengthCone = unit * lengthFactor * 0.2;
        double radiusCone = radiusCylinder * 1.2;
        return new Arrow(lengthCylinder, radiusCylinder, lengthCone, radiusCone, bottomToTopAxis, s_axisToSGAppearanceMap.get((Object)bottomToTopAxis), false);
    }

    public ExtravagantAxes(double unitLength, double forwardFactor) {
        Arrow sgXAxis = this.createArrow(unitLength, 1.0, Cylinder.BottomToTopAxis.POSITIVE_X);
        Arrow sgYAxis = this.createArrow(unitLength, 1.0, Cylinder.BottomToTopAxis.POSITIVE_Y);
        Arrow sgZAxis = this.createArrow(unitLength, 1.0, Cylinder.BottomToTopAxis.POSITIVE_Z);
        Arrow sgFAxis = this.createArrow(unitLength, 2.0, Cylinder.BottomToTopAxis.NEGATIVE_Z);
        sgXAxis.setParent(this);
        sgYAxis.setParent(this);
        sgZAxis.setParent(this);
        sgFAxis.setParent(this);
    }

    public ExtravagantAxes(double unitLength) {
        this(unitLength, 2.0);
    }

    static {
        SingleAppearance sgRedAppearance = new SingleAppearance();
        SingleAppearance sgGreenAppearance = new SingleAppearance();
        SingleAppearance sgBlueAppearance = new SingleAppearance();
        SingleAppearance sgWhiteAppearance = new SingleAppearance();
        sgRedAppearance.setDiffuseColor(Color4f.RED);
        sgGreenAppearance.setDiffuseColor(Color4f.GREEN);
        sgBlueAppearance.setDiffuseColor(Color4f.BLUE);
        sgWhiteAppearance.setDiffuseColor(Color4f.WHITE);
        s_axisToSGAppearanceMap.put(Cylinder.BottomToTopAxis.POSITIVE_X, sgRedAppearance);
        s_axisToSGAppearanceMap.put(Cylinder.BottomToTopAxis.POSITIVE_Y, sgGreenAppearance);
        s_axisToSGAppearanceMap.put(Cylinder.BottomToTopAxis.POSITIVE_Z, sgBlueAppearance);
        s_axisToSGAppearanceMap.put(Cylinder.BottomToTopAxis.NEGATIVE_Z, sgWhiteAppearance);
    }
}

