/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.util;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.polynomial.HermiteCubic;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.LineStrip;
import edu.cmu.cs.dennisc.scenegraph.ShadingStyle;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import edu.cmu.cs.dennisc.scenegraph.util.Connection;

public class ModestConnection
extends Connection {
    private LineStrip m_sgLineStrip = new LineStrip();

    public ModestConnection() {
        Vertex[] vertices = new Vertex[32];
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = Vertex.createXYZ(0.0, 0.0, 0.0);
        }
        this.m_sgLineStrip.vertices.setValue(vertices);
        this.geometries.setValue(new Geometry[]{this.m_sgLineStrip});
        this.getSGFrontFacingAppearance().setShadingStyle(ShadingStyle.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Vertex[] vertices;
        AffineMatrix4x4 m = this.getTarget().getTransformation(this);
        double s = m.translation.calculateMagnitude();
        HermiteCubic x = new HermiteCubic(0.0, m.translation.x, 0.0, (s *= 2.0) * m.orientation.backward.x);
        HermiteCubic y = new HermiteCubic(0.0, m.translation.y, 0.0, s * m.orientation.backward.y);
        HermiteCubic z = new HermiteCubic(0.0, m.translation.z, -s, -s * m.orientation.backward.z);
        Vertex[] vertexArray = vertices = (Vertex[])this.m_sgLineStrip.vertices.getValue();
        synchronized (vertices) {
            double tDelta;
            double t = tDelta = 1.0 / (double)(vertices.length - 1);
            for (int i = 1; i < vertices.length; ++i) {
                vertices[i].position.set(x.evaluate(t), y.evaluate(t), z.evaluate(t));
                t += tDelta;
            }
            this.m_sgLineStrip.vertices.touch();
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return;
        }
    }
}

