/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.pattern.Validator;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputPane<E>
extends JPanel {
    private List<Validator> m_validators = new LinkedList<Validator>();
    private JButton m_okButton;
    private JDialog m_dialog;
    private boolean m_isOK = false;

    public InputPane() {
    }

    public InputPane(Validator ... validators) {
        for (Validator validator : validators) {
            this.m_validators.add(validator);
        }
    }

    public void updateSizeIfNecessary() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (Component component : InputPane.this.getComponents()) {
                    component.invalidate();
                }
                InputPane.this.revalidate();
                if (InputPane.this.m_dialog != null) {
                    Dimension actualSize = InputPane.this.m_dialog.getSize();
                    Dimension preferredSize = InputPane.this.m_dialog.getPreferredSize();
                    if (actualSize.width < preferredSize.width || actualSize.height < preferredSize.height) {
                        InputPane.this.m_dialog.setSize(Math.max(actualSize.width, preferredSize.width), Math.max(actualSize.height, preferredSize.height));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOKButtonValidator(Validator validator) {
        List<Validator> list = this.m_validators;
        synchronized (list) {
            this.m_validators.add(validator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOKButtonValidator(Validator validator) {
        List<Validator> list = this.m_validators;
        synchronized (list) {
            this.m_validators.remove(validator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Validator> getOKButtonValidators() {
        List<Validator> list = this.m_validators;
        synchronized (list) {
            return this.m_validators;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOKButtonValid() {
        List<Validator> list = this.m_validators;
        synchronized (list) {
            for (Validator validator : this.m_validators) {
                if (validator.isValid()) continue;
                return false;
            }
            return true;
        }
    }

    public void updateOKButton() {
        if (this.m_okButton != null) {
            this.m_okButton.setEnabled(this.isOKButtonValid());
        }
    }

    public void fireOKButtonIfPossible() {
        if (this.m_okButton != null && this.m_okButton.isEnabled()) {
            this.m_okButton.doClick();
        }
    }

    public void setOKButton(JButton okButton) {
        this.m_okButton = okButton;
        this.updateOKButton();
    }

    protected void setOK(boolean isOK) {
        this.m_isOK = isOK;
    }

    protected abstract E getActualInputValue();

    public final E getInputValue() {
        if (this.m_isOK) {
            return this.getActualInputValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E showInJDialog(Component ownerComponent, String title, boolean isModal) {
        Component root = SwingUtilities.getRoot(ownerComponent);
        final JDialog dialog = root instanceof Frame ? new JDialog((Frame)root) : (root instanceof Dialog ? new JDialog((Dialog)root) : new JDialog());
        dialog.setTitle(title);
        dialog.setModal(isModal);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InputPane.this.setOK(true);
                dialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InputPane.this.setOK(false);
                dialog.setVisible(false);
            }
        });
        JPanel panel = new JPanel();
        panel.add(okButton);
        panel.add(cancelButton);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.getContentPane().add((Component)panel, "South");
        this.setOKButton(okButton);
        this.m_isOK = false;
        this.revalidate();
        dialog.pack();
        dialog.pack();
        Dimension size = dialog.getSize();
        size.width = Math.max(size.width, 480);
        size.width += 8;
        size.height += 8;
        dialog.setSize(size);
        assert (this.m_dialog == null);
        this.m_dialog = dialog;
        try {
            E rv;
            this.m_dialog.setVisible(true);
            E e = rv = this.getInputValue();
            return e;
        }
        finally {
            this.setOKButton(null);
            this.m_dialog = null;
        }
    }

    public E showInJDialog(Component ownerComponent, String title) {
        return this.showInJDialog(ownerComponent, title, true);
    }

    public E showInJDialog(Component ownerComponent) {
        return this.showInJDialog(ownerComponent, null);
    }
}

