/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SpringPane
extends JPanel {
    private SpringLayout springLayout = new SpringLayout();

    public SpringPane() {
        this.setLayout(this.springLayout);
    }

    protected SpringLayout getSpringLayout() {
        return this.springLayout;
    }

    protected void putConstraint(Component component, Horizontal horizontal, int x, Vertical vertical, int y) {
        String horizontalConstraint = horizontal.getInternal();
        String verticalConstraint = vertical.getInternal();
        if (horizontalConstraint != null) {
            this.springLayout.putConstraint(horizontalConstraint, component, x, horizontalConstraint, (Component)this);
        } else {
            this.springLayout.putConstraint("West", component, new HorizontalCenterSpring(component, x), "West", (Component)this);
        }
        if (verticalConstraint != null) {
            this.springLayout.putConstraint(verticalConstraint, component, y, verticalConstraint, (Component)this);
        } else {
            this.springLayout.putConstraint("North", component, new VerticalCenterSpring(component, y), "North", (Component)this);
        }
    }

    public void add(Component component, Horizontal horizontal, int x, Vertical vertical, int y) {
        this.putConstraint(component, horizontal, x, vertical, y);
        this.add(component);
    }

    abstract class CenterSpring
    extends Spring {
        private Component component;
        private int offset;

        public CenterSpring(Component component, int offset) {
            this.component = component;
            this.offset = offset;
        }

        public int getValue() {
            return this.getPreferredValue();
        }

        public void setValue(int value) {
        }

        protected abstract int getValue(Dimension var1);

        public int getPreferredValue() {
            int macro = this.getValue(SpringPane.this.getSize());
            Dimension size = this.component.isValid() ? this.component.getSize() : this.component.getPreferredSize();
            int micro = this.getValue(size);
            return this.offset + (macro - micro) / 2;
        }

        public int getMinimumValue() {
            return this.getPreferredValue();
        }

        public int getMaximumValue() {
            return this.getPreferredValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Horizontal {
        WEST("West"),
        CENTER(null),
        EAST("East");

        private String internal;

        private Horizontal(String internal) {
            this.internal = internal;
        }

        public String getInternal() {
            return this.internal;
        }
    }

    class HorizontalCenterSpring
    extends CenterSpring {
        public HorizontalCenterSpring(Component component, int offset) {
            super(component, offset);
        }

        protected int getValue(Dimension dimension) {
            return dimension.width;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Vertical {
        NORTH("North"),
        CENTER(null),
        SOUTH("South");

        private String internal;

        private Vertical(String internal) {
            this.internal = internal;
        }

        public String getInternal() {
            return this.internal;
        }
    }

    class VerticalCenterSpring
    extends CenterSpring {
        public VerticalCenterSpring(Component component, int offset) {
            super(component, offset);
        }

        protected int getValue(Dimension dimension) {
            return dimension.height;
        }
    }
}

