/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.lang.SystemUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.MenuDragMouseEvent;

public class SwingUtilities {
    private static Container container = new Container();
    private static BufferedImage s_bufferedImage = null;

    public static void doLayoutTree(Component c) {
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component component : container.getComponents()) {
                SwingUtilities.doLayoutTree(component);
            }
        }
        c.doLayout();
    }

    public static void invalidateTree(Component c) {
        c.invalidate();
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component component : container.getComponents()) {
                SwingUtilities.invalidateTree(component);
            }
        }
    }

    public static void validateTree(Component c) {
        c.invalidate();
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component component : container.getComponents()) {
                SwingUtilities.validateTree(component);
            }
        }
    }

    public static void revalidateTree(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.revalidate();
        }
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component component : container.getComponents()) {
                SwingUtilities.validateTree(component);
            }
        }
    }

    private static void paint(Graphics g, Component c, Container p, int x, int y) {
        Dimension size = c.getPreferredSize();
        g.translate(x, y);
        javax.swing.SwingUtilities.paintComponent(g, c, p, 0, 0, size.width, size.height);
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component component : container.getComponents()) {
                SwingUtilities.paint(g, component, p, component.getX(), component.getY());
            }
        }
        g.translate(-x, -y);
    }

    private static void paint(Graphics g, Component c, Container p) {
        SwingUtilities.paint(g, c, p, 0, 0);
    }

    public static Icon createIcon(Component component) {
        Icon rv;
        Dimension size = component.getPreferredSize();
        if (size.width > 0 && size.height > 0) {
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            Graphics g = image.getGraphics();
            SwingUtilities.paint(g, component, container);
            g.dispose();
            rv = new ImageIcon(image);
        } else {
            rv = new Icon(){

                public int getIconWidth() {
                    return 24;
                }

                public int getIconHeight() {
                    return 12;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            };
        }
        return rv;
    }

    public static Frame getRootFrame(Component c) {
        Component root = javax.swing.SwingUtilities.getRoot(c);
        if (root instanceof Frame) {
            return (Frame)root;
        }
        return null;
    }

    public static JFrame getRootJFrame(Component c) {
        Component root = javax.swing.SwingUtilities.getRoot(c);
        if (root instanceof JFrame) {
            return (JFrame)root;
        }
        return null;
    }

    public static Dialog getRootDialog(Component c) {
        Component root = javax.swing.SwingUtilities.getRoot(c);
        if (root instanceof Dialog) {
            return (Dialog)root;
        }
        return null;
    }

    public static JDialog getRootJDialog(Component c) {
        Component root = javax.swing.SwingUtilities.getRoot(c);
        if (root instanceof JDialog) {
            return (JDialog)root;
        }
        return null;
    }

    public static boolean isQuoteControlUnquoteDown(InputEvent e) {
        if (SystemUtilities.isWindows()) {
            return e.isControlDown();
        }
        return e.isAltDown();
    }

    public static Graphics getGraphics() {
        if (s_bufferedImage == null) {
            s_bufferedImage = new BufferedImage(1, 1, 5);
        }
        return s_bufferedImage.getGraphics();
    }

    public static void showMessageDialogInScrollableUneditableTextArea(Component owner, String text, String title, int messageType, final int maxPreferredWidth, final int maxPreferredHeight) {
        assert (messageType == 0 || messageType == 1 || messageType == 2 || messageType == -1);
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        JOptionPane.showMessageDialog(owner, new JScrollPane(textArea){

            public Dimension getPreferredSize() {
                Dimension rv = super.getPreferredSize();
                rv.width = Math.min(rv.width, maxPreferredWidth);
                rv.height = Math.min(rv.height, maxPreferredHeight);
                return rv;
            }
        }, title, messageType);
    }

    public static void showMessageDialogInScrollableUneditableTextArea(Component owner, String text, String title, int messageType) {
        SwingUtilities.showMessageDialogInScrollableUneditableTextArea(owner, text, title, messageType, 640, 480);
    }

    public static MouseEvent convertMouseEvent(Component source, MouseEvent sourceEvent, Component destination) {
        int modifiers = sourceEvent.getModifiers();
        int modifiersEx = sourceEvent.getModifiersEx();
        int modifiersComplete = modifiers | modifiersEx;
        MouseEvent me = javax.swing.SwingUtilities.convertMouseEvent(source, sourceEvent, destination);
        if (me instanceof MouseWheelEvent) {
            MouseWheelEvent mwe = (MouseWheelEvent)me;
            return new MouseWheelEvent(me.getComponent(), me.getID(), me.getWhen(), modifiersComplete, me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), mwe.getScrollType(), mwe.getScrollAmount(), mwe.getWheelRotation());
        }
        if (me instanceof MenuDragMouseEvent) {
            MenuDragMouseEvent mdme = (MenuDragMouseEvent)me;
            return new MenuDragMouseEvent(me.getComponent(), me.getID(), me.getWhen(), modifiersComplete, me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), mdme.getPath(), mdme.getMenuSelectionManager());
        }
        return new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), modifiersComplete, me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
    }
}

