/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.awt.BevelState;
import edu.cmu.cs.dennisc.awt.ColorUtilities;
import edu.cmu.cs.dennisc.awt.ShapeUtilties;
import edu.cmu.cs.dennisc.swing.event.TabEvent;
import edu.cmu.cs.dennisc.swing.event.TabListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

public class Tab
extends JComponent {
    private static final Color CLOSE_BUTTON_BASE_COLOR = new Color(127, 63, 63);
    private static final Color CLOSE_BUTTON_HIGHLIGHT_COLOR = ColorUtilities.shiftHSB(CLOSE_BUTTON_BASE_COLOR, 0.0, 0.0, 0.25);
    private static final Color CLOSE_BUTTON_PRESS_COLOR = ColorUtilities.shiftHSB(CLOSE_BUTTON_BASE_COLOR, 0.0, 0.0, -0.125);
    private CloseButton m_closeButton = new CloseButton();
    private CloseButtonMouseAdapter m_closeButtonMouseAdapter = null;
    private JComponent m_title;
    private JComponent m_component;
    private boolean m_isSelected;
    private boolean m_isClosable = false;
    private final int EAST_PAD = 30;
    private List<TabListener> m_tabListeners = new LinkedList<TabListener>();

    public Tab(JComponent title, JComponent component) {
        this.m_component = component;
        this.m_title = title;
        int SIZE = this.m_title.getFont().getSize() * 7 / 4;
        this.m_closeButton.setMinimumSize(new Dimension(SIZE, SIZE));
        this.m_closeButton.setPreferredSize(new Dimension(SIZE, SIZE));
        this.m_closeButton.setMaximumSize(new Dimension(SIZE, SIZE));
        this.setLayout(new BoxLayout(this, 0));
        this.add(new Box.Filler(new Dimension(0, 0), new Dimension(5, 0), new Dimension(5, 0)));
        this.add(this.m_title);
        this.add(new Box.Filler(new Dimension(0, 0), new Dimension(5, 0), new Dimension(Short.MAX_VALUE, 0)));
        this.add(this.m_closeButton);
        this.add(Box.createRigidArea(new Dimension(30, 0)));
        MouseAdapter mouseAdapter = new MouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.setBorder(new EmptyBorder(2, 0, 0, 0));
    }

    public boolean isClosable() {
        return this.m_isClosable;
    }

    public void setClosable(boolean isClosable) {
        this.m_isClosable = isClosable;
        if (this.m_isClosable && this.m_closeButtonMouseAdapter == null) {
            this.m_closeButtonMouseAdapter = new CloseButtonMouseAdapter();
            this.m_closeButton.addMouseListener(this.m_closeButtonMouseAdapter);
            this.m_closeButton.addMouseMotionListener(this.m_closeButtonMouseAdapter);
        }
    }

    public void addTabListener(TabListener tabListener) {
        this.m_tabListeners.add(tabListener);
    }

    public void removeTabListener(TabListener tabListener) {
        this.m_tabListeners.remove(tabListener);
    }

    private void fireSelected() {
        TabEvent e = new TabEvent(this);
        for (TabListener tabListener : this.m_tabListeners) {
            tabListener.tabSelected(e);
        }
    }

    private void fireClosed() {
        TabEvent e = new TabEvent(this);
        for (TabListener tabListener : this.m_tabListeners) {
            tabListener.tabClosed(e);
        }
    }

    public JComponent getTabPane() {
        return this.m_component;
    }

    public boolean isSelected() {
        return this.m_isSelected;
    }

    public void setSelected(boolean isSelected) {
        if (this.m_isSelected != isSelected) {
            this.m_isSelected = isSelected;
            if (this.m_isSelected) {
                this.fireSelected();
            }
            this.repaint();
        }
    }

    public Color getBackground() {
        Color rv = super.getBackground();
        if (rv != null && !this.isSelected()) {
            int GRAY_SCALE = 96;
            rv = new Color((rv.getRed() + 96) / 2, (rv.getGreen() + 96) / 2, (rv.getBlue() + 96) / 2);
        }
        return rv;
    }

    protected void paintComponent(Graphics g) {
        float xA;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        float x0 = this.getWidth() - 30;
        float x1 = this.getWidth();
        float cx0 = x0 + 15.0f;
        float cx1 = x1 - 20.0f;
        float y0 = 0.0f;
        float y1 = this.getHeight();
        float cy0 = y0;
        float cy1 = y1;
        float yA = xA = (float)this.getHeight() * 0.3f;
        GeneralPath path = new GeneralPath();
        path.moveTo(x1, y1);
        path.curveTo(cx1, cy1, cx0, cy0, x0, y0);
        path.lineTo(xA, 0.0f);
        path.quadTo(0.0f, 0.0f, 0.0f, yA);
        path.lineTo(0.0f, y1);
        Paint prevPaint = g2.getPaint();
        g2.setPaint(this.getBackground());
        ShapeUtilties.paint(g2, path, BevelState.RAISED);
        g2.setPaint(prevPaint);
    }

    class CloseButton
    extends JComponent {
        private boolean m_isShowing = false;
        private boolean m_isHighlighted = false;
        private boolean m_isPressed = false;

        CloseButton() {
        }

        public void setShowing(boolean isShowing) {
            if (this.m_isShowing != isShowing) {
                this.m_isShowing = isShowing;
                this.getParent().repaint();
            }
        }

        public boolean isHighlighted() {
            return this.m_isHighlighted;
        }

        public void setHighlighted(boolean isHighlighted) {
            if (this.m_isHighlighted != isHighlighted) {
                this.m_isHighlighted = isHighlighted;
                this.repaint();
            }
        }

        public boolean isPressed() {
            return this.m_isPressed;
        }

        public void setPressed(boolean isPressed) {
            if (this.m_isPressed != isPressed) {
                this.m_isPressed = isPressed;
                this.getParent().repaint();
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (Tab.this.m_isClosable && (this.isShowing() || this.isHighlighted() || this.isPressed())) {
                float size;
                Graphics2D g2 = (Graphics2D)g;
                float w = size = (float)Math.min(this.getWidth(), this.getHeight()) * 0.9f;
                float h = size * 0.25f;
                float x = -w * 0.5f;
                float y = -h * 0.5f;
                RoundRectangle2D.Float rr = new RoundRectangle2D.Float(x, y, w, h, h, h);
                Area area0 = new Area(rr);
                Area area1 = new Area(rr);
                AffineTransform m0 = new AffineTransform();
                m0.rotate(0.7853981633974483);
                area0.transform(m0);
                AffineTransform m1 = new AffineTransform();
                m1.rotate(2.356194490192345);
                area1.transform(m1);
                area0.add(area1);
                AffineTransform m = new AffineTransform();
                m.translate(this.getWidth() / 2, this.getHeight() / 2);
                area0.transform(m);
                Paint prevPaint = g2.getPaint();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.isHighlighted()) {
                    if (this.isPressed()) {
                        g2.setPaint(CLOSE_BUTTON_PRESS_COLOR);
                    } else {
                        g2.setPaint(CLOSE_BUTTON_HIGHLIGHT_COLOR);
                    }
                } else {
                    g2.setPaint(Color.WHITE);
                }
                g2.fill(area0);
                g2.setPaint(Color.BLACK);
                g2.draw(area0);
                g2.setPaint(prevPaint);
            }
        }
    }

    private class CloseButtonMouseAdapter
    implements MouseListener,
    MouseMotionListener {
        private CloseButtonMouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            Tab.this.m_closeButton.setHighlighted(true);
        }

        public void mouseExited(MouseEvent e) {
            Tab.this.m_closeButton.setHighlighted(false);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            Tab.this.m_closeButton.setPressed(true);
        }

        public void mouseReleased(MouseEvent e) {
            Tab.this.m_closeButton.setPressed(false);
            if (Tab.this.m_isClosable && Tab.this.m_closeButton.isHighlighted()) {
                Tab.this.fireClosed();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    class MouseAdapter
    implements MouseListener,
    MouseMotionListener {
        MouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            if (Tab.this.m_isClosable) {
                Tab.this.m_closeButton.setShowing(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (Tab.this.m_isClosable) {
                Tab.this.m_closeButton.setShowing(false);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            Tab.this.setSelected(true);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

