/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing.plaf;

import edu.cmu.cs.dennisc.awt.ColorUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;

class CloseIcon
implements Icon {
    private static final Color BASE_COLOR = new Color(127, 63, 63);
    private static final Color HIGHLIGHT_COLOR = ColorUtilities.shiftHSB(BASE_COLOR, 0.0, 0.0, 0.25);
    private static final Color PRESS_COLOR = ColorUtilities.shiftHSB(BASE_COLOR, 0.0, 0.0, -0.125);
    private boolean isFilled = false;
    private boolean isHighlighted = false;
    private boolean isPressed = false;

    CloseIcon() {
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFilled(boolean isFilled) {
        this.isFilled = isFilled;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setHighlighted(boolean isHighlighted) {
        if (this.isHighlighted != isHighlighted) {
            this.isHighlighted = isHighlighted;
        }
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public void setPressed(boolean isPressed) {
        if (this.isPressed != isPressed) {
            this.isPressed = isPressed;
        }
    }

    public int getIconWidth() {
        return 14;
    }

    public int getIconHeight() {
        return this.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x0, int y0) {
        float size;
        Graphics2D g2 = (Graphics2D)g;
        float w = size = (float)Math.min(this.getIconWidth(), this.getIconWidth()) * 0.9f;
        float h = size * 0.25f;
        float xC = -w * 0.5f;
        float yC = -h * 0.5f;
        RoundRectangle2D.Float rr = new RoundRectangle2D.Float(xC, yC, w, h, h, h);
        Area area0 = new Area(rr);
        Area area1 = new Area(rr);
        AffineTransform m0 = new AffineTransform();
        m0.rotate(0.7853981633974483);
        area0.transform(m0);
        AffineTransform m1 = new AffineTransform();
        m1.rotate(2.356194490192345);
        area1.transform(m1);
        area0.add(area1);
        AffineTransform m = new AffineTransform();
        m.translate(x0 + this.getIconWidth() / 2, y0 + this.getIconWidth() / 2);
        area0.transform(m);
        Paint prevPaint = g2.getPaint();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isHighlighted()) {
            if (this.isPressed()) {
                g2.setPaint(PRESS_COLOR);
            } else {
                g2.setPaint(HIGHLIGHT_COLOR);
            }
        } else {
            g2.setPaint(Color.WHITE);
        }
        if (this.isFilled) {
            g2.fill(area0);
            g2.setPaint(Color.BLACK);
        } else {
            g2.setPaint(Color.DARK_GRAY);
        }
        g2.draw(area0);
        g2.setPaint(prevPaint);
    }
}

