/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing.plaf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListUI<E>
extends javax.swing.plaf.ListUI {
    private JList list;
    private ListModel model;
    private ButtonGroup group;
    private GridBagConstraints gbc;
    private ListDataListener listDataAdapter = new ListDataListener(){

        public void contentsChanged(ListDataEvent e) {
            ListUI.this.refresh();
        }

        public void intervalAdded(ListDataEvent e) {
            for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                ListUI.this.add(i);
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                ListUI.this.remove(i);
            }
        }
    };
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
        }
    };
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent e) {
            if ("model".equals(e.getPropertyName())) {
                ListUI.this.refresh();
            }
        }
    };

    protected abstract AbstractButton createComponentFor(int var1, E var2);

    protected abstract void updateIndex(AbstractButton var1, int var2);

    private void updateIndices() {
        this.list.revalidate();
        this.list.repaint();
        int i = 0;
        Enumeration<AbstractButton> e = this.group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            this.updateIndex(b, i);
            ++i;
        }
    }

    private void add(final int i) {
        if (this.list != null) {
            Object value = this.model.getElementAt(i);
            AbstractButton button = this.createComponentFor(i, value);
            button.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && ListUI.this.list != null) {
                        ListSelectionModel model = ListUI.this.list.getSelectionModel();
                        model.setSelectionInterval(i, i);
                    }
                }
            });
            this.group.add(button);
            this.list.add(button, this.gbc, i);
            this.updateIndices();
        }
    }

    private void remove(int i) {
        if (this.list != null) {
            AbstractButton button = (AbstractButton)this.list.getComponent(i);
            this.group.remove(button);
            this.list.remove(button);
            this.updateIndices();
        }
    }

    private void refresh() {
        if (this.list != null) {
            if (this.model != this.list.getModel()) {
                if (this.model != null) {
                    this.model.removeListDataListener(this.listDataAdapter);
                }
                this.model = this.list.getModel();
                if (this.model != null) {
                    this.model.addListDataListener(this.listDataAdapter);
                }
            }
            this.list.removeAll();
            this.group = new ButtonGroup();
            int N = this.model.getSize();
            for (int i = 0; i < N; ++i) {
                this.add(i);
            }
            this.gbc.weighty = 1.0;
            this.list.add(Box.createGlue(), this.gbc);
            this.gbc.weighty = 0.0;
            this.list.revalidate();
            this.list.repaint();
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.list = (JList)c;
        this.list.setLayout(new GridBagLayout());
        this.group = new ButtonGroup();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.refresh();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.model.removeListDataListener(this.listDataAdapter);
        this.model = null;
        this.group = null;
        this.gbc = null;
        this.list.setLayout(null);
        this.list.removeAll();
        this.list = null;
        super.uninstallUI(c);
    }

    public Rectangle getCellBounds(JList list, int index1, int index2) {
        Rectangle rv = null;
        int N = list.getComponentCount() - 1;
        if (0 <= index1 && index1 < N && 0 <= index2 && index2 < N) {
            for (int i = index1; i <= index2; ++i) {
                Component c = list.getComponent(i);
                rv = rv != null ? rv.union(c.getBounds()) : c.getBounds();
            }
        }
        return rv;
    }

    public Point indexToLocation(JList list, int index) {
        return list.getComponent(index).getLocation();
    }

    public int locationToIndex(JList list, Point location) {
        int N = list.getComponentCount() - 1;
        for (int i = 0; i < N; ++i) {
            Component c = list.getComponent(i);
            if (!c.contains(location)) continue;
            return i;
        }
        return -1;
    }
}

