/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing.plaf;

import edu.cmu.cs.dennisc.lang.SystemUtilities;
import edu.cmu.cs.dennisc.swing.plaf.CloseIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class TabbedPaneUI
extends BasicTabbedPaneUI {
    private static final int NORTH_AREA_PAD = 8;
    private static final int EAST_TAB_PAD = 48;
    private Stroke selectedStroke = new BasicStroke(3.0f);
    private Stroke normalStroke = new BasicStroke(1.0f);
    private CloseIcon closeIcon = new CloseIcon();
    private Color contentAreaColor;
    private CloseIconMouseAdapter closeIconMouseAdapter = new CloseIconMouseAdapter();

    public TabbedPaneUI(Color contentAreaColor) {
        this.contentAreaColor = contentAreaColor;
    }

    protected void installDefaults() {
        super.installDefaults();
        Font normalFont = this.tabPane.getFont();
        this.tabPane.setFont(normalFont.deriveFont(2));
        this.tabAreaInsets.set(0, 0, 0, 0);
        this.tabInsets.set(3, 2, 3, 2);
        this.selectedTabPadInsets.set(0, 0, 0, 0);
        if (SystemUtilities.isMac()) {
            this.contentBorderInsets.set(0, 0, 0, 0);
        } else {
            this.contentBorderInsets.set(2, 2, 0, 0);
        }
    }

    private GeneralPath addToPath(GeneralPath rv, float x, float y, float width, float height, float a, boolean isContinuation) {
        float x0 = x + width - 24.0f;
        float x1 = x + width + 48.0f;
        float cx0 = x0 + 36.0f;
        float cx1 = x0;
        float y0 = y + 8.0f;
        float y1 = y + height;
        float cy0 = y0;
        float cy1 = y1;
        float xA = x + a;
        float yA = y + a;
        if (isContinuation) {
            rv.lineTo(x1, y1);
        } else {
            rv.moveTo(x1, y1);
        }
        rv.curveTo(cx1, cy1, cx0, cy0, x0, y0);
        rv.lineTo(xA, y0);
        rv.quadTo(x, y0, x, yA);
        rv.lineTo(x, y1);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
        Graphics2D g2 = (Graphics2D)g;
        Color prev = g.getColor();
        try {
            g.setColor(this.shadow);
            g2.setStroke(this.normalStroke);
            GeneralPath path = this.addToPath(new GeneralPath(), x, y, width, height, (float)height * 0.4f, false);
            g2.draw(path);
        }
        finally {
            g.setColor(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
        Color prev = g.getColor();
        try {
            int tabRolloverIndex = this.getRolloverTab();
            Component component = this.tabPane.getComponentAt(tabIndex);
            Color color = component.getBackground();
            if (!isSelected) {
                color = color.darker();
                if (tabIndex != tabRolloverIndex) {
                    color = color.darker();
                }
            }
            g.setColor(color);
            Graphics2D g2 = (Graphics2D)g;
            GeneralPath path = this.addToPath(new GeneralPath(), x, y, width, height, (float)height * 0.4f, false);
            g2.fill(path);
            if (this.isCloseButtonDesiredAt(tabIndex)) {
                if (this.getRolloverTab() == tabIndex) {
                    this.closeIcon.setFilled(true);
                } else {
                    this.closeIcon.setFilled(false);
                }
                this.closeIcon.paintIcon(this.tabPane, g2, x + width - 24, y + height / 2 - 4);
            }
        }
        finally {
            g.setColor(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Color prev = g.getColor();
        try {
            g.setColor(this.contentAreaColor);
            Rectangle bounds = g.getClipBounds();
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        finally {
            g.setColor(prev);
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    private void repaintTab(int index) {
        if (index >= 0) {
            Rectangle bounds = this.getTabBounds(index, new Rectangle());
            bounds.x -= 48;
            bounds.width += 96;
            this.tabPane.repaint(bounds);
        }
    }

    protected void setRolloverTab(int nextRollOverTab) {
        int prevRollOverTab = this.getRolloverTab();
        super.setRolloverTab(nextRollOverTab);
        if (prevRollOverTab != nextRollOverTab) {
            this.repaintTab(prevRollOverTab);
            this.repaintTab(nextRollOverTab);
        }
    }

    protected boolean isCloseButtonDesiredAt(int index) {
        return true;
    }

    protected void closeTab(int index, MouseEvent e) {
        this.tabPane.remove(index);
    }

    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseListener(this.closeIconMouseAdapter);
        this.tabPane.addMouseMotionListener(this.closeIconMouseAdapter);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseListener(this.closeIconMouseAdapter);
        this.tabPane.removeMouseMotionListener(this.closeIconMouseAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color prev = g.getColor();
        try {
            Component component = this.tabPane.getSelectedComponent();
            if (component != null) {
                g.setColor(component.getBackground());
                g.fillRect(x, y, w, h);
                if (selectedIndex >= 0) {
                    Rectangle boundsTab = this.getTabBounds(this.tabPane, selectedIndex);
                    int xA = boundsTab.x;
                    float Y_DELTA = 0.0f;
                    float y0 = (float)y - 0.0f;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(x + w, y0);
                    this.addToPath(path, xA, y0 - (float)boundsTab.height + 0.0f, boundsTab.width, (float)boundsTab.height - 0.0f, (float)boundsTab.height * 0.4f, true);
                    path.lineTo(x, y0);
                    path.lineTo(x, y + h);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setStroke(this.selectedStroke);
                    g.setColor(this.lightHighlight);
                    g2.draw(path);
                }
            }
        }
        finally {
            g.setColor(prev);
        }
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int rv = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        return rv + 8;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int rv = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        return rv += 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color prev = g.getColor();
        try {
            g.setColor(Color.BLACK);
            int x = textRect.x;
            g.drawString(title, x -= 12, textRect.y + textRect.height);
        }
        finally {
            g.setColor(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            int x = iconRect.x;
            x -= 12;
            int y = iconRect.y;
            y += 8;
            Color prev = g.getColor();
            try {
                icon.paintIcon(this.tabPane, g, x, y);
            }
            finally {
                g.setColor(prev);
            }
        } else {
            super.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
    }

    class CloseIconMouseAdapter
    implements MouseListener,
    MouseMotionListener {
        private Rectangle buffer = new Rectangle();

        CloseIconMouseAdapter() {
        }

        private int getTabIndex(MouseEvent e) {
            return TabbedPaneUI.this.tabForCoordinate(TabbedPaneUI.this.tabPane, e.getX(), e.getY());
        }

        private boolean isWithinCloseIcon(MouseEvent e) {
            if (TabbedPaneUI.this.tabPane.isEnabled()) {
                int index = this.getTabIndex(e);
                TabbedPaneUI.this.setRolloverTab(index);
                if (index >= 0 && TabbedPaneUI.this.isCloseButtonDesiredAt(index)) {
                    TabbedPaneUI.this.getTabBounds(index, this.buffer);
                    int xMin = this.buffer.x + this.buffer.width - 24;
                    int xMax = xMin + TabbedPaneUI.this.closeIcon.getIconWidth();
                    int yMin = this.buffer.y + this.buffer.height / 2 - 4;
                    int yMax = yMin + TabbedPaneUI.this.closeIcon.getIconHeight();
                    return xMin < e.getX() && e.getX() < xMax && yMin < e.getY() && e.getY() < yMax;
                }
            }
            return false;
        }

        private void updateRollover(MouseEvent e) {
            TabbedPaneUI.this.closeIcon.setHighlighted(this.isWithinCloseIcon(e));
            TabbedPaneUI.this.repaintTab(this.getTabIndex(e));
        }

        public void mouseEntered(MouseEvent e) {
            this.updateRollover(e);
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TabbedPaneUI.this.closeIcon.setPressed(this.isWithinCloseIcon(e));
            TabbedPaneUI.this.tabPane.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (TabbedPaneUI.this.closeIcon.isPressed() && this.isWithinCloseIcon(e)) {
                TabbedPaneUI.this.closeTab(this.getTabIndex(e), e);
            }
            TabbedPaneUI.this.closeIcon.setPressed(false);
            TabbedPaneUI.this.tabPane.repaint();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            this.updateRollover(e);
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

