/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.texture;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.image.ImageUtilities;
import edu.cmu.cs.dennisc.texture.MipMapGenerationPolicy;
import edu.cmu.cs.dennisc.texture.Texture;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class BufferedImageTexture
extends Texture {
    private BufferedImage m_bufferedImage = null;
    private boolean m_isMipMappingDesired = true;
    private boolean m_isPotentiallyAlphaBlended = false;

    public BufferedImage getBufferedImage() {
        return this.m_bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        if (this.m_bufferedImage != bufferedImage) {
            this.m_bufferedImage = bufferedImage;
            this.fireTextureChanged();
        }
    }

    public boolean isMipMappingDesired() {
        return this.m_isMipMappingDesired;
    }

    public void setMipMappingDesired(boolean isMipMappingDesired) {
        if (this.m_isMipMappingDesired != isMipMappingDesired) {
            this.m_isMipMappingDesired = isMipMappingDesired;
            this.fireTextureChanged();
        }
    }

    public boolean isPotentiallyAlphaBlended() {
        return this.m_isPotentiallyAlphaBlended;
    }

    public void setPotentiallyAlphaBlended(boolean isPotentiallyAlphaBlended) {
        if (this.m_isPotentiallyAlphaBlended != isPotentiallyAlphaBlended) {
            this.m_isPotentiallyAlphaBlended = isPotentiallyAlphaBlended;
            this.fireTextureChanged();
        }
    }

    public void decode(BinaryDecoder binaryDecoder) {
        byte[] buffer = binaryDecoder.decodeByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        this.setBufferedImage(ImageUtilities.read("png", bais));
    }

    public void encode(BinaryEncoder binaryEncoder) {
        assert (this.m_bufferedImage != null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageUtilities.write("png", baos, this.m_bufferedImage);
        binaryEncoder.encode(baos.toByteArray());
    }

    public int getWidth() {
        if (this.m_bufferedImage != null) {
            return this.m_bufferedImage.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.m_bufferedImage != null) {
            return this.m_bufferedImage.getHeight();
        }
        return 0;
    }

    public boolean isAnimated() {
        return false;
    }

    public MipMapGenerationPolicy getMipMapGenerationPolicy() {
        return MipMapGenerationPolicy.PAINT_EACH_INDIVIDUAL_LEVEL;
    }

    public void paint(Graphics2D g, int width, int height) {
        g.drawImage(this.m_bufferedImage, 0, 0, width, height, null);
    }
}

