/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.texture;

import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.image.ImageGenerator;
import edu.cmu.cs.dennisc.pattern.AbstractElement;
import edu.cmu.cs.dennisc.texture.event.TextureEvent;
import edu.cmu.cs.dennisc.texture.event.TextureListener;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Texture
extends AbstractElement
implements BinaryEncodableAndDecodable,
ImageGenerator {
    private Vector<TextureListener> m_textureListeners = new Vector();

    public boolean isValid() {
        return this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public abstract int getWidth();

    @Override
    public abstract int getHeight();

    @Override
    public abstract boolean isPotentiallyAlphaBlended();

    @Override
    public abstract boolean isMipMappingDesired();

    public void addTextureListener(TextureListener textureListener) {
        this.m_textureListeners.addElement(textureListener);
    }

    public void removeTextureListener(TextureListener textureListener) {
        this.m_textureListeners.removeElement(textureListener);
    }

    public Iterable<TextureListener> accessTextureListeners() {
        return this.m_textureListeners;
    }

    public void fireTextureChanged(TextureEvent textureEvent) {
        for (TextureListener hl : this.m_textureListeners) {
            hl.textureChanged(textureEvent);
        }
    }

    public void fireTextureChanged() {
        this.fireTextureChanged(new TextureEvent(this));
    }
}

