/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.texture;

import edu.cmu.cs.dennisc.image.ImageFactory;
import edu.cmu.cs.dennisc.texture.BufferedImageTexture;
import edu.cmu.cs.dennisc.texture.Texture;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.alice.virtualmachine.Resource;
import org.alice.virtualmachine.event.ResourceContentEvent;
import org.alice.virtualmachine.event.ResourceContentListener;
import org.alice.virtualmachine.resources.ImageResource;

public final class TextureFactory {
    private static Map<ImageResource, Texture> resourceToTextureMap = new HashMap<ImageResource, Texture>();
    private static ResourceContentListener resourceContentListener = new ResourceContentListener(){

        public void contentChanging(ResourceContentEvent e) {
        }

        public void contentChanged(ResourceContentEvent e) {
            Texture texture;
            ImageResource imageResource;
            BufferedImage bufferedImage;
            Resource resource = (Resource)e.getTypedSource();
            if (resource instanceof ImageResource && (bufferedImage = ImageFactory.getBufferedImage(imageResource = (ImageResource)resource)) != null && (texture = (Texture)resourceToTextureMap.get(e.getTypedSource())) instanceof BufferedImageTexture) {
                BufferedImageTexture bufferedImageTexture = (BufferedImageTexture)texture;
                TextureFactory.updateBufferedImageTexture(bufferedImageTexture, bufferedImage);
            }
        }
    };

    private TextureFactory() {
    }

    private static void updateBufferedImageTexture(BufferedImageTexture bufferedImageTexture, BufferedImage bufferedImage) {
        bufferedImageTexture.setBufferedImage(bufferedImage);
        boolean isPotenentiallyAlphaBlended = bufferedImage.getTransparency() == 3;
        bufferedImageTexture.setPotentiallyAlphaBlended(isPotenentiallyAlphaBlended);
    }

    public static Texture getTexture(ImageResource imageResource, boolean isMipMappingDesired) {
        assert (imageResource != null);
        Texture rv = resourceToTextureMap.get(imageResource);
        if (rv == null) {
            BufferedImage bufferedImage = ImageFactory.getBufferedImage(imageResource);
            if (bufferedImage != null) {
                BufferedImageTexture bufferedImageTexture = new BufferedImageTexture();
                bufferedImageTexture.setMipMappingDesired(isMipMappingDesired);
                TextureFactory.updateBufferedImageTexture(bufferedImageTexture, bufferedImage);
                rv = bufferedImageTexture;
                imageResource.addContentListener(resourceContentListener);
                resourceToTextureMap.put(imageResource, rv);
            } else {
                rv = null;
            }
        }
        return rv;
    }
}

