/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui;

import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.awt.EventInterceptor;
import edu.cmu.cs.dennisc.awt.event.KeyEventUtilities;
import edu.cmu.cs.dennisc.lang.SystemUtilities;
import edu.cmu.cs.dennisc.swing.SwingUtilities;
import edu.cmu.cs.dennisc.ui.DragStyle;
import edu.cmu.cs.dennisc.ui.UndoRedoManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DragAdapter
implements MouseListener,
MouseMotionListener,
KeyListener {
    private Animator m_animator;
    private UndoRedoManager m_undoRedoManager = null;
    private Component m_awtComponent = null;
    private DragStyle m_dragStyleCurrent;
    private Point m_current = new Point();
    private Point m_previous = new Point();
    private Point m_press = new Point();
    private boolean m_isActive = false;
    private List<EventInterceptor> m_eventInterceptors = new LinkedList<EventInterceptor>();
    private boolean m_isDragInProgress = false;

    public void addEventInterceptor(EventInterceptor eventInterceptor) {
        this.m_eventInterceptors.add(eventInterceptor);
    }

    public void removeEventInterceptor(EventInterceptor eventInterceptor) {
        this.m_eventInterceptors.add(eventInterceptor);
    }

    public Iterable<EventInterceptor> accessEventInterceptors() {
        return this.m_eventInterceptors;
    }

    protected Component getAWTComponent() {
        return this.m_awtComponent;
    }

    public void setAWTComponent(Component awtComponent) {
        if (this.m_awtComponent != null) {
            this.removeListeners(this.m_awtComponent);
        }
        this.m_awtComponent = awtComponent;
        if (this.m_awtComponent != null) {
            this.addListeners(awtComponent);
        }
    }

    protected boolean isAcceptable(MouseEvent e) {
        return (e.getModifiers() & 0x1C) != 0;
    }

    public Animator getAnimator() {
        return this.m_animator;
    }

    public void setAnimator(Animator animator) {
        this.m_animator = animator;
    }

    public UndoRedoManager getUndoRedoManager() {
        return this.m_undoRedoManager;
    }

    public void setUndoRedoManager(UndoRedoManager undoRedoManager) {
        this.m_undoRedoManager = undoRedoManager;
    }

    protected void addListeners(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addKeyListener(this);
    }

    protected void removeListeners(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeKeyListener(this);
    }

    protected abstract void handleMousePress(Point var1, DragStyle var2, boolean var3);

    protected abstract void handleMouseDrag(Point var1, int var2, int var3, int var4, int var5, DragStyle var6);

    protected abstract Point handleMouseRelease(Point var1, DragStyle var2, boolean var3);

    public boolean isDragInProgress() {
        return this.m_isDragInProgress;
    }

    private void invokeHandleMousePress(boolean isOriginalAsOpposedToStyleChange) {
        this.m_isDragInProgress = true;
        this.m_press.x = this.m_previous.x = this.m_current.x;
        this.m_press.y = this.m_previous.y = this.m_current.y;
        this.handleMousePress(this.m_current, this.m_dragStyleCurrent, isOriginalAsOpposedToStyleChange);
    }

    private void invokeHandleMouseDrag() {
        this.handleMouseDrag(this.m_current, this.m_current.x - this.m_press.x, this.m_current.y - this.m_press.y, this.m_current.x - this.m_previous.x, this.m_current.y - this.m_previous.y, this.m_dragStyleCurrent);
    }

    private Point invokeHandleMouseRelease(boolean isOriginalAsOpposedToStyleChange) {
        this.m_isDragInProgress = false;
        return this.handleMouseRelease(this.m_current, this.m_dragStyleCurrent, isOriginalAsOpposedToStyleChange);
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        boolean isIntercepted = false;
        for (EventInterceptor eventInterceptor : this.m_eventInterceptors) {
            if (!eventInterceptor.isEventIntercepted(e)) continue;
            isIntercepted = true;
            break;
        }
        if (isIntercepted) {
            this.m_isActive = false;
        } else {
            e.getComponent().requestFocus();
            this.m_isActive = this.isAcceptable(e);
        }
        if (this.m_isActive) {
            this.m_dragStyleCurrent = SwingUtilities.isQuoteControlUnquoteDown(e) ? (e.isShiftDown() ? DragStyle.CONTROL_SHIFT : DragStyle.CONTROL) : (e.isShiftDown() ? DragStyle.SHIFT : DragStyle.NORMAL);
            this.m_current.x = e.getX();
            this.m_current.y = e.getY();
            this.invokeHandleMousePress(true);
            this.invokeHandleMouseDrag();
        } else {
            this.m_dragStyleCurrent = null;
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (this.m_isActive) {
            this.m_previous.x = this.m_current.x;
            this.m_previous.y = this.m_current.y;
            this.m_current.x = e.getX();
            this.m_current.y = e.getY();
            this.invokeHandleMouseRelease(true);
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (this.m_isActive) {
            this.m_previous.x = this.m_current.x;
            this.m_previous.y = this.m_current.y;
            this.m_current.x = e.getX();
            this.m_current.y = e.getY();
            this.invokeHandleMouseDrag();
        }
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        if (this.m_isActive && SystemUtilities.isMac() && e.isControlDown()) {
            this.mouseDragged(e);
        }
    }

    protected void handleDragStyleChange(DragStyle from, DragStyle to) {
        Point p = this.invokeHandleMouseRelease(false);
        this.m_current.x = p.x;
        this.m_current.y = p.y;
        this.m_dragStyleCurrent = to;
        this.invokeHandleMousePress(false);
        this.invokeHandleMouseDrag();
    }

    private void addToDragStyleIfNecessary(int keyCode) {
        if (this.m_dragStyleCurrent != null) {
            if (keyCode == KeyEventUtilities.getQuoteControlUnquoteKey()) {
                if (!this.m_dragStyleCurrent.isControlDown()) {
                    if (this.m_dragStyleCurrent.isShiftDown()) {
                        this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.CONTROL_SHIFT);
                    } else {
                        this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.CONTROL);
                    }
                }
            } else if (keyCode == 16) {
                if (this.m_dragStyleCurrent.isControlDown()) {
                    this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.CONTROL_SHIFT);
                } else if (!this.m_dragStyleCurrent.isShiftDown()) {
                    this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.SHIFT);
                }
            }
        }
    }

    private void removeFromDragStyleIfNecessary(int keyCode) {
        if (this.m_dragStyleCurrent != null) {
            if (keyCode == KeyEventUtilities.getQuoteControlUnquoteKey()) {
                if (this.m_dragStyleCurrent.isControlDown()) {
                    if (this.m_dragStyleCurrent.isShiftDown()) {
                        this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.SHIFT);
                    } else {
                        this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.NORMAL);
                    }
                }
            } else if (keyCode == 16) {
                if (this.m_dragStyleCurrent.isControlDown()) {
                    this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.CONTROL);
                } else if (this.m_dragStyleCurrent.isShiftDown()) {
                    this.handleDragStyleChange(this.m_dragStyleCurrent, DragStyle.NORMAL);
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.addToDragStyleIfNecessary(e.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.removeFromDragStyleIfNecessary(e.getKeyCode());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

