/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.lookingglass;

import edu.cmu.cs.dennisc.awt.event.MouseEventUtilities;
import edu.cmu.cs.dennisc.clock.Clock;
import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.event.AutomaticDisplayEvent;
import edu.cmu.cs.dennisc.lookingglass.event.AutomaticDisplayListener;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassDisplayChangeEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassInitializeEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassListener;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassRenderEvent;
import edu.cmu.cs.dennisc.lookingglass.event.LookingGlassResizeEvent;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.rungekutta.RungeKuttaUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.ui.DragStyle;
import edu.cmu.cs.dennisc.ui.lookingglass.CameraNavigationFunction;
import edu.cmu.cs.dennisc.ui.lookingglass.CameraNavigationMode;
import edu.cmu.cs.dennisc.ui.lookingglass.OnscreenLookingGlassDragAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class CameraNavigationDragAdapter
extends OnscreenLookingGlassDragAdapter
implements MouseWheelListener,
LookingGlassListener {
    private CameraNavigationFunction m_function = new CameraNavigationFunction();
    private double m_tPrev = Double.NaN;
    private Cursor m_awtCursorPrev = null;
    private double m_metersPerMouseWheelTick = 1.0;
    private int m_sgCameraIndex = 0;
    private boolean isMultipleCameraWarningAlreadyDelivered = false;
    private CameraNavigationMode m_cameraNavigationMode = null;
    private int m_xPixel0 = -1;
    private int m_yPixel0 = -1;
    private int m_xPixelPrev = -1;
    private int m_yPixelPrev = -1;
    private boolean m_isEnabled = true;
    final int BOX_HALF_SIZE = 6;
    final int DASH_SIZE = 6;

    protected boolean isAcceptable(MouseEvent e) {
        return MouseEventUtilities.isQuoteRightUnquoteMouseButton(e);
    }

    public void setOnscreenLookingGlass(OnscreenLookingGlass onscreenLookingGlass) {
        super.setOnscreenLookingGlass(onscreenLookingGlass);
        onscreenLookingGlass.getLookingGlassFactory().addAutomaticDisplayListener(new AutomaticDisplayListener(){

            public void automaticDisplayCompleted(AutomaticDisplayEvent e) {
                CameraNavigationDragAdapter.this.handleDisplayed();
            }
        });
    }

    private void handleDisplayed() {
        AbstractCamera sgCamera = this.getSGCamera();
        if (sgCamera != null) {
            double tCurr = Clock.getCurrentTime();
            if (sgCamera != null) {
                if (Double.isNaN(this.m_tPrev)) {
                    this.m_tPrev = Clock.getCurrentTime();
                }
                double tDelta = tCurr - this.m_tPrev;
                this.update(tDelta);
            }
            this.m_tPrev = tCurr;
        }
    }

    public AbstractCamera getSGCamera() {
        OnscreenLookingGlass onscreenLookingGlass = this.getOnscreenLookingGlass();
        if (onscreenLookingGlass != null) {
            int cameraCount = onscreenLookingGlass.getCameraCount();
            if (cameraCount > 1 && !this.isMultipleCameraWarningAlreadyDelivered) {
                PrintUtilities.println("WARNING: onscreenLookingGlass.getCameraCount()", onscreenLookingGlass.getCameraCount());
                this.isMultipleCameraWarningAlreadyDelivered = true;
            }
            if (this.m_sgCameraIndex < cameraCount) {
                return onscreenLookingGlass.getCameraAt(this.m_sgCameraIndex);
            }
            return null;
        }
        return null;
    }

    public Transformable getSGCameraTransformable() {
        AbstractCamera sgCamera = this.getSGCamera();
        if (sgCamera != null) {
            return (Transformable)sgCamera.getParent();
        }
        return null;
    }

    public CameraNavigationMode getCameraNavigationMode() {
        return this.m_cameraNavigationMode;
    }

    public void startCameraNavigationMode(CameraNavigationMode cameraNavigationMode, int x, int y) {
        this.m_cameraNavigationMode = cameraNavigationMode;
        this.m_xPixel0 = x;
        this.m_yPixel0 = y;
        this.m_xPixelPrev = this.m_xPixel0;
        this.m_yPixelPrev = this.m_yPixel0;
    }

    public void stopCameraNavigationMode() {
        this.m_function.stopImmediately();
        this.m_cameraNavigationMode = null;
    }

    public void handleMouseDragged(int xPixel, int yPixel) {
        double TRANSLATION_XZ_FACTOR = 0.05;
        double TRANSLATION_Y_FACTOR = 0.05;
        double ORBIT_YAW_FACTOR = 0.02;
        double ORBIT_PITCH_FACTOR = 0.002;
        if (this.m_cameraNavigationMode != null) {
            if (this.m_cameraNavigationMode == CameraNavigationMode.ORBIT) {
                int xPixelDelta = xPixel - this.m_xPixelPrev;
                int yPixelDelta = yPixel - this.m_yPixelPrev;
                this.m_function.requestOrbit((double)xPixelDelta * 0.02, (double)(-yPixelDelta) * 0.002);
            } else if (this.m_cameraNavigationMode == CameraNavigationMode.TRANSLATE_XZ) {
                this.m_function.requestVelocity((double)(xPixel - this.m_xPixel0) * 0.05, 0.0, (double)(yPixel - this.m_yPixel0) * 0.05);
            } else if (this.m_cameraNavigationMode == CameraNavigationMode.TRANSLATE_Y) {
                this.m_function.requestVelocity(0.0, -((double)(yPixel - this.m_yPixel0) * 0.05), 0.0);
            }
            this.m_xPixelPrev = xPixel;
            this.m_yPixelPrev = yPixel;
        }
    }

    public void requestTarget(double x, double y, double z) {
        this.m_function.requestTarget(x, y, z);
    }

    public void requestTarget(Point3 target) {
        this.m_function.requestTarget(target.x, target.y, target.z);
    }

    public void requestYaw(Angle yaw) {
        this.m_function.requestYaw(yaw);
    }

    public void requestDistance(double distance) {
        this.m_function.requestDistance(distance);
    }

    public Angle getYawRequested() {
        return this.m_function.getYawRequested();
    }

    public Angle getPitchRequested() {
        return this.m_function.getPitchRequested();
    }

    public double getDistanceRequested() {
        return this.m_function.getDistanceRequested();
    }

    public Point3 accessTargetRequested() {
        return this.m_function.accessTargetRequested();
    }

    public Point3 getTargetRequested(Point3 rv) {
        return this.m_function.getTargetRequested(rv);
    }

    public Point3 getTargetRequested() {
        return this.m_function.getTargetRequested();
    }

    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.m_isEnabled = isEnabled;
    }

    public void update(double tDelta) {
        if (this.m_isEnabled) {
            RungeKuttaUtilities.rk4(this.m_function, 0.0, tDelta);
            this.getSGCameraTransformable().setLocalTransformation(this.m_function.getTransformation());
        }
    }

    private void paintBox(Graphics2D g) {
        g.setColor(Color.BLUE);
        g.drawRect(this.m_xPixel0 - 6, this.m_yPixel0 - 6, 13, 13);
        g.drawLine(this.m_xPixel0 - 6, this.m_yPixel0, this.m_xPixel0 - 6 - 6, this.m_yPixel0);
        g.drawLine(this.m_xPixel0 + 6 + 1, this.m_yPixel0, this.m_xPixel0 + 6 + 6 + 1, this.m_yPixel0);
        g.drawLine(this.m_xPixel0, this.m_yPixel0 - 6, this.m_xPixel0, this.m_yPixel0 - 6 - 6);
        g.drawLine(this.m_xPixel0, this.m_yPixel0 + 6 + 1, this.m_xPixel0, this.m_yPixel0 + 6 + 6 + 1);
    }

    private void paintDash(Graphics2D g) {
        g.setColor(Color.BLUE);
        g.drawLine(this.m_xPixel0 - 6 - 6, this.m_yPixel0, this.m_xPixel0 + 6 + 6, this.m_yPixel0);
    }

    private void paintArrow(Graphics2D g, int xPixelDelta, int yPixelDelta) {
        int[] xPoints = new int[]{0, 8, 8, 20, 20, 8, 8};
        int[] yPoints = new int[]{0, 10, 5, 5, -5, -5, -10};
        double theta = Math.atan2(yPixelDelta, xPixelDelta);
        g.translate(this.m_xPixelPrev, this.m_yPixelPrev);
        g.rotate(theta);
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(xPoints, yPoints, xPoints.length);
        g.setColor(Color.LIGHT_GRAY);
        g.drawPolygon(xPoints, yPoints, xPoints.length);
        g.rotate(-theta);
        g.translate(-this.m_xPixelPrev, -this.m_yPixelPrev);
    }

    public void paint(Graphics2D g) {
        if (this.m_cameraNavigationMode == CameraNavigationMode.TRANSLATE_XZ) {
            this.paintBox(g);
            this.paintArrow(g, this.m_xPixel0 - this.m_xPixelPrev, this.m_yPixel0 - this.m_yPixelPrev);
        } else if (this.m_cameraNavigationMode == CameraNavigationMode.TRANSLATE_Y) {
            this.paintDash(g);
            this.paintArrow(g, 0, this.m_yPixel0 - this.m_yPixelPrev);
        } else if (this.m_cameraNavigationMode == CameraNavigationMode.ORBIT) {
            g.setColor(Color.BLACK);
            int RADIUS = 10;
            g.drawOval(this.m_xPixel0 - 10, this.m_yPixel0 - 10, 21, 21);
        }
    }

    public void initialized(LookingGlassInitializeEvent e) {
    }

    public void resized(LookingGlassResizeEvent e) {
    }

    public void displayChanged(LookingGlassDisplayChangeEvent e) {
    }

    public void cleared(LookingGlassRenderEvent e) {
    }

    public void rendered(LookingGlassRenderEvent e) {
        this.paint(e.getGraphics2D());
    }

    protected void addListeners(Component component) {
        super.addListeners(component);
        this.getOnscreenLookingGlass().getAWTComponent().addMouseWheelListener(this);
    }

    protected void removeListeners(Component component) {
        super.removeListeners(component);
        this.getOnscreenLookingGlass().getAWTComponent().addMouseWheelListener(this);
    }

    protected void handleMousePress(Point current, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        CameraNavigationMode cameraNavigationMode = dragStyle.isControlDown() ? (dragStyle.isShiftDown() ? null : CameraNavigationMode.ORBIT) : (dragStyle.isShiftDown() ? CameraNavigationMode.TRANSLATE_Y : CameraNavigationMode.TRANSLATE_XZ);
        this.startCameraNavigationMode(cameraNavigationMode, current.x, current.y);
        if (isOriginalAsOpposedToStyleChange) {
            this.getOnscreenLookingGlass().addLookingGlassListener(this);
            this.m_awtCursorPrev = this.getAWTComponent().getCursor();
            this.getAWTComponent().setCursor(new Cursor(1));
        }
    }

    protected void handleMouseDrag(Point current, int xDeltaSince0, int yDeltaSince0, int xDeltaSincePrevious, int yDeltaSincePrevious, DragStyle dragStyle) {
        this.handleMouseDragged(current.x, current.y);
    }

    protected Point handleMouseRelease(Point rvCurrent, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        this.stopCameraNavigationMode();
        if (isOriginalAsOpposedToStyleChange) {
            this.getAWTComponent().setCursor(this.m_awtCursorPrev);
            this.getOnscreenLookingGlass().removeLookingGlassListener(this);
        }
        return rvCurrent;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.m_function.requestDistanceChange((double)e.getWheelRotation() * this.m_metersPerMouseWheelTick);
    }

    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        this.m_function.setKeyPressed(e.getKeyCode(), true);
    }

    public void keyReleased(KeyEvent e) {
        super.keyReleased(e);
        this.m_function.setKeyPressed(e.getKeyCode(), false);
    }
}

