/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.lookingglass;

import edu.cmu.cs.dennisc.awt.event.MouseEventUtilities;
import edu.cmu.cs.dennisc.lookingglass.PickObserver;
import edu.cmu.cs.dennisc.lookingglass.PickResult;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import edu.cmu.cs.dennisc.scenegraph.util.TransformationUtilities;
import edu.cmu.cs.dennisc.ui.DragStyle;
import edu.cmu.cs.dennisc.ui.lookingglass.OnscreenLookingGlassDragAdapter;
import edu.cmu.cs.dennisc.ui.scenegraph.SetPointOfViewAction;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ModelManipulationDragAdapter
extends OnscreenLookingGlassDragAdapter {
    private AbstractCamera m_sgCamera = null;
    private Transformable m_sgDragAcceptor = null;
    private Plane m_planeInAbsolute = new Plane();
    private Point3 m_xyzInAbsoluteAtPress = null;
    private Point3 m_xyzInDragAcceptorAtPress = null;
    private Vector3 m_offset = null;
    private AffineMatrix4x4 m_undoPOV;
    private double yDelta = 0.0;

    protected boolean isAcceptable(MouseEvent e) {
        return MouseEventUtilities.isQuoteLeftUnquoteMouseButton(e);
    }

    protected PickObserver getPickObserver() {
        return null;
    }

    protected void updateTranslation(Transformable sgDragAcceptor, Tuple3 xyz, ReferenceFrame asSeenBy) {
        if (sgDragAcceptor != null) {
            sgDragAcceptor.setTranslationOnly(xyz, asSeenBy);
        }
    }

    protected Transformable lookupDragAcceptor(Visual sgVisual) {
        Composite sgParent = sgVisual.getParent();
        if (sgParent instanceof Transformable) {
            return (Transformable)sgParent;
        }
        return null;
    }

    protected Transformable getDragAcceptor() {
        return this.m_sgDragAcceptor;
    }

    private Point3 getPointInPlane(Plane plane, int xPixel, int yPixel) {
        Ray ray = this.getOnscreenLookingGlass().getRayAtPixel(xPixel, yPixel, this.m_sgCamera);
        AffineMatrix4x4 m = this.m_sgCamera.getAbsoluteTransformation();
        ray.transform(m);
        double t = plane.intersect(ray);
        return ray.getPointAlong(t);
    }

    protected void handleMousePress(Point current, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        if (isOriginalAsOpposedToStyleChange) {
            PickResult pickResult = this.getOnscreenLookingGlass().pickFrontMost(current.x, current.y, false, this.getPickObserver());
            this.m_sgCamera = (AbstractCamera)pickResult.getSource();
            Visual sgVisual = pickResult.getVisual();
            if (sgVisual != null) {
                this.m_sgDragAcceptor = this.lookupDragAcceptor(sgVisual);
                if (this.m_sgDragAcceptor != null) {
                    this.m_undoPOV = this.m_sgDragAcceptor.getTransformation(AsSeenBy.SCENE);
                    this.m_xyzInAbsoluteAtPress = TransformationUtilities.transformToAbsolute_New(pickResult.getPositionInSource(), (Component)this.m_sgCamera);
                }
            }
            this.yDelta = 0.0;
        } else if (this.m_sgDragAcceptor != null) {
            Ray ray = this.getOnscreenLookingGlass().getRayAtPixel(current.x, current.y, this.m_sgCamera);
            ray.transform(this.m_sgCamera.getAbsoluteTransformation());
            double t = this.m_planeInAbsolute.intersect(ray);
            this.m_xyzInAbsoluteAtPress = ray.getPointAlong(t);
        }
        if (this.m_sgDragAcceptor != null) {
            AffineMatrix4x4 m = this.m_sgDragAcceptor.getAbsoluteTransformation();
            this.m_offset = Vector3.createSubtraction(this.m_xyzInAbsoluteAtPress, m.translation);
            this.m_xyzInDragAcceptorAtPress = this.m_sgDragAcceptor.transformTo_New(this.m_xyzInAbsoluteAtPress, (Component)this.m_sgDragAcceptor.getRoot());
            if (dragStyle.isShiftDown()) {
                AffineMatrix4x4 cameraAbsolute = this.m_sgCamera.getAbsoluteTransformation();
                Vector3 axis = Vector3.createSubtraction(cameraAbsolute.translation, this.m_xyzInAbsoluteAtPress);
                axis.normalize();
                this.m_planeInAbsolute.set(this.m_xyzInAbsoluteAtPress, axis);
            } else {
                this.m_planeInAbsolute.set(this.m_xyzInAbsoluteAtPress, Vector3.accessPositiveYAxis());
            }
        } else {
            this.m_planeInAbsolute.setNaN();
            this.m_xyzInAbsoluteAtPress = Point3.createNaN();
            this.m_xyzInDragAcceptorAtPress = null;
        }
    }

    protected void handleMouseDrag(Point current, int xDeltaSince0, int yDeltaSince0, int xDeltaSincePrevious, int yDeltaSincePrevious, DragStyle dragStyle) {
        if (this.m_sgDragAcceptor != null && !this.m_planeInAbsolute.isNaN() && !this.m_xyzInDragAcceptorAtPress.isNaN()) {
            if (dragStyle.isControlDown()) {
                this.m_sgDragAcceptor.applyRotationAboutYAxis(new AngleInRadians((double)xDeltaSincePrevious * 0.01));
            } else if (dragStyle.isShiftDown()) {
                if (this.m_sgDragAcceptor != null) {
                    Point3 t = this.m_sgDragAcceptor.getAbsoluteTransformation().translation;
                    final Point3 xyzInAbsolutePlane = this.getPointInPlane(this.m_planeInAbsolute, current.x, current.y);
                    this.yDelta += xyzInAbsolutePlane.y - t.y;
                    xyzInAbsolutePlane.subtract(this.m_offset);
                    xyzInAbsolutePlane.x = t.x;
                    xyzInAbsolutePlane.z = t.z;
                    this.getOnscreenLookingGlass().getLookingGlassFactory().invokeLater(new Runnable(){

                        public void run() {
                            ModelManipulationDragAdapter.this.updateTranslation(ModelManipulationDragAdapter.this.m_sgDragAcceptor, xyzInAbsolutePlane, AsSeenBy.SCENE);
                        }
                    });
                }
            } else {
                final Point3 xyzInAbsolutePlane = this.getPointInPlane(this.m_planeInAbsolute, current.x, current.y);
                xyzInAbsolutePlane.subtract(this.m_offset);
                this.getOnscreenLookingGlass().getLookingGlassFactory().invokeLater(new Runnable(){

                    public void run() {
                        ModelManipulationDragAdapter.this.updateTranslation(ModelManipulationDragAdapter.this.m_sgDragAcceptor, xyzInAbsolutePlane, AsSeenBy.SCENE);
                    }
                });
            }
        }
    }

    protected Point handleMouseRelease(Point rv, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        if (this.m_sgCamera == null || this.m_sgDragAcceptor != null) {
            // empty if block
        }
        if (isOriginalAsOpposedToStyleChange) {
            if (this.m_sgDragAcceptor != null) {
                AffineMatrix4x4 redoPOV = this.m_sgDragAcceptor.getTransformation(AsSeenBy.SCENE);
                if (this.getUndoRedoManager() != null) {
                    this.getUndoRedoManager().pushAlreadyRunActionOntoUndoStack(new SetPointOfViewAction(this.getAnimator(), this.m_sgDragAcceptor, AsSeenBy.SCENE, this.m_undoPOV, redoPOV));
                }
            }
            this.m_sgDragAcceptor = null;
            this.m_planeInAbsolute.setNaN();
        }
        return rv;
    }
}

