/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.lookingglass;

import edu.cmu.cs.dennisc.awt.event.MouseEventUtilities;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.ui.DragStyle;
import edu.cmu.cs.dennisc.ui.lookingglass.OnscreenLookingGlassDragAdapter;
import java.awt.Point;
import java.awt.event.MouseEvent;

public abstract class PlanarProjectionDragAdapter
extends OnscreenLookingGlassDragAdapter {
    private Plane m_bufferPlaneInAbsolute = new Plane();

    protected abstract Plane getPlaneInAbsolute(Plane var1);

    protected abstract void handlePointInAbsolute(Point3 var1);

    protected boolean isAcceptable(MouseEvent e) {
        return MouseEventUtilities.isQuoteLeftUnquoteMouseButton(e);
    }

    private Point3 getPointInAbsolutePlane(Point p) {
        Point3 rv;
        AbstractCamera sgCamera = this.getOnscreenLookingGlass().getCameraAtPixel(p.x, p.y);
        if (sgCamera != null) {
            Ray ray = this.getOnscreenLookingGlass().getRayAtPixel(p.x, p.y, sgCamera);
            AffineMatrix4x4 m = sgCamera.getAbsoluteTransformation();
            ray.transform(m);
            this.getPlaneInAbsolute(this.m_bufferPlaneInAbsolute);
            double t = this.m_bufferPlaneInAbsolute.intersect(ray);
            rv = ray.getPointAlong(t);
        } else {
            rv = null;
        }
        return rv;
    }

    protected void handleMousePress(Point current, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        if (isOriginalAsOpposedToStyleChange) {
            // empty if block
        }
    }

    protected void handleMouseDrag(Point current, int xDeltaSince0, int yDeltaSince0, int xDeltaSincePrevious, int yDeltaSincePrevious, DragStyle dragStyle) {
        Point3 xyzInAbsolute = this.getPointInAbsolutePlane(current);
        if (xyzInAbsolute != null) {
            this.handlePointInAbsolute(xyzInAbsolute);
        }
    }

    protected Point handleMouseRelease(Point rv, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        return rv;
    }
}

