/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtilities {
    private CollectionUtilities() {
    }

    public static <E> E[] createArray(Collection<E> collection, Class<E> cls, boolean isZeroLengthArrayDesiredForNull) {
        int size = collection != null ? collection.size() : (isZeroLengthArrayDesiredForNull ? 0 : -1);
        Object[] rv = size >= 0 ? (Object[])Array.newInstance(cls, size) : null;
        if (collection != null) {
            collection.toArray(rv);
        }
        return rv;
    }

    public static <E> E[] createArray(Collection<E> collection, Class<E> cls) {
        return CollectionUtilities.createArray(collection, cls, false);
    }

    public static <E> void set(Collection<E> collection, E ... array) {
        collection.clear();
        if (collection instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)collection;
            arrayList.ensureCapacity(array.length);
        }
        if (collection instanceof Vector) {
            Vector vector = (Vector)collection;
            vector.ensureCapacity(array.length);
        }
        for (E e : array) {
            collection.add(e);
        }
    }

    public static <E> ArrayList<E> createArrayList(E ... array) {
        ArrayList rv = new ArrayList();
        CollectionUtilities.set(rv, array);
        return rv;
    }

    public static <E> Vector<E> createVector(E ... array) {
        Vector rv = new Vector();
        CollectionUtilities.set(rv, array);
        return rv;
    }
}

