/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.zoot.AbstractEdit;
import edu.cmu.cs.dennisc.zoot.AbstractOperation;
import edu.cmu.cs.dennisc.zoot.BooleanStateContext;
import edu.cmu.cs.dennisc.zoot.BooleanStateOperation;
import edu.cmu.cs.dennisc.zoot.ZManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.Locale;
import java.util.UUID;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;

public abstract class AbstractBooleanStateOperation
extends AbstractOperation
implements BooleanStateOperation {
    private ButtonModel buttonModel = new JToggleButton.ToggleButtonModel();
    private ItemListener itemListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            boolean next;
            boolean prev;
            if (e.getStateChange() == 1) {
                prev = false;
                next = true;
            } else {
                prev = true;
                next = false;
            }
            ZManager.performIfAppropriate(AbstractBooleanStateOperation.this, (EventObject)e, false, prev, next);
        }
    };
    private String trueText = null;
    private String falseText = null;

    public AbstractBooleanStateOperation(UUID groupUUID, Boolean initialState) {
        super(groupUUID);
        this.buttonModel.setSelected(initialState);
        this.buttonModel.addItemListener(this.itemListener);
    }

    public Boolean getState() {
        return this.buttonModel.isSelected();
    }

    public ButtonModel getButtonModel() {
        return this.buttonModel;
    }

    public String getTrueText() {
        if (this.trueText != null) {
            return this.trueText;
        }
        return (String)this.getActionForConfiguringSwing().getValue("Name");
    }

    public void setTrueText(String trueText) {
        this.trueText = trueText;
    }

    public String getFalseText() {
        if (this.falseText != null) {
            return this.falseText;
        }
        return (String)this.getActionForConfiguringSwing().getValue("Name");
    }

    public void setFalseText(String falseText) {
        this.trueText = falseText;
    }

    public final void performStateChange(BooleanStateContext booleanStateContext) {
        class Edit
        extends AbstractEdit {
            private boolean prevValue;
            private boolean nextValue;

            public Edit(boolean prevValue, boolean nextValue) {
                this.prevValue = prevValue;
                this.nextValue = nextValue;
            }

            private void setValue(boolean value) {
                AbstractBooleanStateOperation.this.buttonModel.removeItemListener(AbstractBooleanStateOperation.this.itemListener);
                AbstractBooleanStateOperation.this.buttonModel.setSelected(value);
                AbstractBooleanStateOperation.this.handleStateChange(value);
                AbstractBooleanStateOperation.this.buttonModel.addItemListener(AbstractBooleanStateOperation.this.itemListener);
            }

            public void doOrRedo(boolean isDo) {
                this.setValue(this.nextValue);
            }

            public void undo() {
                this.setValue(this.prevValue);
            }

            protected StringBuffer updatePresentation(StringBuffer rv, Locale locale) {
                rv.append("boolean: ");
                rv.append(this.nextValue);
                return rv;
            }
        }
        booleanStateContext.commitAndInvokeDo(new Edit(booleanStateContext.getPreviousValue(), booleanStateContext.getNextValue()));
    }

    protected abstract void handleStateChange(boolean var1);
}

