/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.zoot.AbstractEdit;
import edu.cmu.cs.dennisc.zoot.AbstractOperation;
import edu.cmu.cs.dennisc.zoot.ItemSelectionContext;
import edu.cmu.cs.dennisc.zoot.ItemSelectionOperation;
import edu.cmu.cs.dennisc.zoot.ZManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Locale;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemSelectionOperation<E>
extends AbstractOperation
implements ItemSelectionOperation<E> {
    private ButtonGroup buttonGroup = new ButtonGroup();
    private Action[] actions;
    private ButtonModel[] buttonModels;
    private ComboBoxModel comboBoxModel;

    public AbstractItemSelectionOperation(UUID groupUUID, ComboBoxModel comboBoxModel) {
        super(groupUUID);
        this.comboBoxModel = comboBoxModel;
        int N = this.comboBoxModel.getSize();
        this.actions = new javax.swing.Action[N];
        this.buttonModels = new ButtonModel[N];
        Object selectedItem = comboBoxModel.getSelectedItem();
        for (int i = 0; i < N; ++i) {
            final Object item = this.comboBoxModel.getElementAt(i);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Action
            extends AbstractAction {
                public Action(int i, E item) {
                    this.putValue("Name", AbstractItemSelectionOperation.this.getNameFor(i, item));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            }
            this.actions[i] = new Action(i, item);
            this.buttonModels[i] = new JToggleButton.ToggleButtonModel();
            this.buttonModels[i].setGroup(this.buttonGroup);
            if (item == selectedItem) {
                this.buttonModels[i].setSelected(true);
            }
            this.buttonModels[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ZManager.performIfAppropriate(AbstractItemSelectionOperation.this, (EventObject)e, false, null, item);
                    }
                }
            });
        }
    }

    protected String getNameFor(int index, E item) {
        if (item != null) {
            return item.toString();
        }
        return "null";
    }

    @Override
    public KeyStroke getAcceleratorForConfiguringSwing(int index) {
        return null;
    }

    @Override
    public Action getActionForConfiguringSwing(int index) {
        return this.actions[index];
    }

    @Override
    public ButtonModel getButtonModelForConfiguringSwing(int index) {
        return this.buttonModels[index];
    }

    @Override
    public ComboBoxModel getComboBoxModel() {
        return this.comboBoxModel;
    }

    @Override
    public void handleKeyPressed(KeyEvent e) {
        int N = this.comboBoxModel.getSize();
        for (int i = 0; i < N; ++i) {
            KeyStroke acceleratorI = this.getAcceleratorForConfiguringSwing(i);
            if (acceleratorI == null || e.getKeyCode() != acceleratorI.getKeyCode() || e.getModifiersEx() != acceleratorI.getModifiers()) continue;
            this.getButtonModelForConfiguringSwing(i).setSelected(true);
        }
    }

    protected abstract void handleSelectionChange(E var1);

    @Override
    public final void performSelectionChange(ItemSelectionContext<E> context) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Edit
        extends AbstractEdit {
            private E prevValue;
            private E nextValue;

            public Edit(E prevValue, E nextValue) {
                this.prevValue = prevValue;
                this.nextValue = nextValue;
            }

            @Override
            public void doOrRedo(boolean isDo) {
                AbstractItemSelectionOperation.this.comboBoxModel.setSelectedItem(this.nextValue);
                AbstractItemSelectionOperation.this.handleSelectionChange(this.nextValue);
            }

            @Override
            public void undo() {
                AbstractItemSelectionOperation.this.comboBoxModel.setSelectedItem(this.prevValue);
                AbstractItemSelectionOperation.this.handleSelectionChange(this.prevValue);
            }

            @Override
            protected StringBuffer updatePresentation(StringBuffer rv, Locale locale) {
                rv.append("select ");
                rv.append(this.prevValue);
                rv.append(" ===> ");
                rv.append(this.nextValue);
                return rv;
            }
        }
        context.commitAndInvokeDo(new Edit(context.getPreviousSelection(), context.getNextSelection()));
    }
}

