/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.lang.ClassUtilities;
import edu.cmu.cs.dennisc.zoot.Edit;
import java.util.Locale;

public class CompositeEdit
implements Edit {
    private Edit[] edits;
    private boolean isDoToBeIgnored;
    private String presentation;

    public CompositeEdit(Edit[] edits, boolean isDoToBeIgnored, String presentation) {
        this.edits = edits;
        this.isDoToBeIgnored = isDoToBeIgnored;
        this.presentation = presentation;
    }

    public void doOrRedo(boolean isDo) {
        if (!isDo || !this.isDoToBeIgnored) {
            for (Edit edit : this.edits) {
                edit.doOrRedo(isDo);
            }
        }
    }

    public void undo() {
        int N = this.edits.length;
        for (int i = 0; i < N; ++i) {
            this.edits[N - 1 - i].undo();
        }
    }

    public boolean canRedo() {
        for (Edit edit : this.edits) {
            if (edit.canRedo()) continue;
            return false;
        }
        return true;
    }

    public boolean canUndo() {
        for (Edit edit : this.edits) {
            if (edit.canUndo()) continue;
            return false;
        }
        return true;
    }

    protected StringBuffer updatePresentation(StringBuffer rv, Locale locale) {
        return rv;
    }

    public final String getPresentation(Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.presentation);
        if (sb.length() == 0) {
            Class<?> cls = this.getClass();
            sb.append(ClassUtilities.getTrimmedClassName(cls));
        }
        return sb.toString();
    }

    public String getRedoPresentation(Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append("Redo:");
        this.updatePresentation(sb, locale);
        return sb.toString();
    }

    public String getUndoPresentation(Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append("Undo:");
        this.updatePresentation(sb, locale);
        return sb.toString();
    }
}

