/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.zoot.ZComponent;
import edu.cmu.cs.dennisc.zoot.ZDragComponent;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

abstract class Proxy
extends JPanel {
    private static BufferedImage image;
    private ZDragComponent dragComponent;
    private boolean isOverDropAcceptor = false;
    private boolean isCopyDesired = false;

    private static BufferedImage getOffscreenImage(int width, int height) {
        if (image == null || image.getWidth() != width || image.getHeight() != height) {
            image = new BufferedImage(width, height, 6);
        }
        return image;
    }

    public Proxy(ZDragComponent dragComponent) {
        this.dragComponent = dragComponent;
        this.setOpaque(false);
    }

    protected ZDragComponent getDragComponent() {
        return this.dragComponent;
    }

    protected Component getSubject() {
        return this.dragComponent.getSubject();
    }

    public int getProxyWidth() {
        return this.getSubject().getWidth();
    }

    public int getProxyHeight() {
        return this.getSubject().getHeight();
    }

    protected void fillBounds(Graphics2D g2) {
        Component subject = this.getSubject();
        int x = 0;
        int y = 0;
        int width = subject.getWidth();
        int height = subject.getHeight();
        if (subject instanceof ZComponent) {
            ZComponent component = (ZComponent)subject;
            component.fillBounds(g2, x, y, width, height);
        } else {
            g2.fillRect(x, y, width, height);
        }
    }

    protected abstract void paintProxy(Graphics2D var1);

    protected abstract float getAlpha();

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getProxyWidth();
        int height = this.getProxyHeight();
        if (width > 0 && height > 0) {
            BufferedImage image = Proxy.getOffscreenImage(width, height);
            Graphics2D g2Image = (Graphics2D)image.getGraphics();
            this.paintProxy(g2Image);
            g2Image.dispose();
            Graphics2D g2 = (Graphics2D)g;
            Composite prevComposite = g2.getComposite();
            float alpha = this.getAlpha();
            if (alpha < 0.99f) {
                g2.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
            }
            g2.drawImage(image, 0, 0, width, height, this);
            g2.dispose();
            g2.setComposite(prevComposite);
        }
    }

    public boolean isOverDropAcceptor() {
        return this.isOverDropAcceptor;
    }

    public void setOverDropAcceptor(boolean isOverDropAcceptor) {
        if (this.isOverDropAcceptor != isOverDropAcceptor) {
            this.isOverDropAcceptor = isOverDropAcceptor;
            this.repaint();
        }
    }

    public boolean isCopyDesired() {
        return this.isCopyDesired;
    }

    public void setCopyDesired(boolean isCopyDesired) {
        if (this.isCopyDesired != isCopyDesired) {
            this.isCopyDesired = isCopyDesired;
            this.repaint();
        }
    }

    public int getDropWidth() {
        return this.getWidth();
    }

    public int getDropHeight() {
        return this.getHeight();
    }
}

