/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.awt.event.MouseEventUtilities;
import edu.cmu.cs.dennisc.zoot.ActionOperation;
import edu.cmu.cs.dennisc.zoot.ZComponent;
import edu.cmu.cs.dennisc.zoot.ZManager;
import edu.cmu.cs.dennisc.zoot.event.ControlAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public abstract class ZControl
extends ZComponent {
    private ActionOperation leftButtonPressOperation;
    private ActionOperation leftButtonDoubleClickOperation;
    private ActionOperation popupOperation;
    private boolean isActive = false;
    private boolean isPressed = false;
    private ControlAdapter controlAdapter = null;
    private MouseEvent mousePressedEvent = null;
    private MouseEvent leftButtonPressedEvent = null;
    private float clickThreshold = 5.0f;
    private boolean isWithinClickThreshold = false;

    protected boolean isMouseListeningDesired() {
        return this.leftButtonPressOperation != null || this.leftButtonDoubleClickOperation != null || this.popupOperation != null;
    }

    public void addNotify() {
        super.addNotify();
        if (this.isMouseListeningDesired()) {
            this.controlAdapter = new ControlAdapter(this);
            this.addMouseListener(this.controlAdapter);
            this.addMouseMotionListener(this.controlAdapter);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.controlAdapter != null) {
            this.removeMouseListener(this.controlAdapter);
            this.removeMouseMotionListener(this.controlAdapter);
            this.controlAdapter = null;
        }
    }

    public MouseEvent getLeftButtonPressedEvent() {
        return this.leftButtonPressedEvent;
    }

    public void handleMousePressed(MouseEvent e) {
        this.isWithinClickThreshold = true;
        this.mousePressedEvent = e;
        this.leftButtonPressedEvent = null;
        this.setPressed(true);
        if (MouseEventUtilities.isQuoteLeftUnquoteMouseButton(e)) {
            this.leftButtonPressedEvent = e;
            if (this.leftButtonPressOperation != null) {
                ZManager.performIfAppropriate(this.leftButtonPressOperation, (EventObject)e, true);
            }
        } else if (MouseEventUtilities.isQuoteRightUnquoteMouseButton(e)) {
            if (ZManager.isDragInProgress()) {
                this.isWithinClickThreshold = false;
            } else if (this.popupOperation != null) {
                ZManager.performIfAppropriate(this.popupOperation, (EventObject)e, true);
            }
        }
    }

    public void handleMouseReleased(MouseEvent e) {
        this.setPressed(false);
    }

    public void handleMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.leftButtonDoubleClickOperation != null) {
            ZManager.performIfAppropriate(this.leftButtonDoubleClickOperation, (EventObject)e, true);
        }
    }

    public void handleMouseEntered(MouseEvent e) {
        if (!ZManager.isDragInProgress()) {
            this.setActive(true);
        }
    }

    public void handleMouseExited(MouseEvent e) {
        if (!ZManager.isDragInProgress()) {
            this.setActive(false);
        }
    }

    public void handleMouseMoved(MouseEvent e) {
    }

    public float getClickThreshold() {
        return this.clickThreshold;
    }

    public void setClickThreshold(float clickThreshold) {
        this.clickThreshold = clickThreshold;
    }

    protected boolean isWithinClickThreshold() {
        return this.isWithinClickThreshold;
    }

    protected void handleMouseDraggedOutsideOfClickThreshold(MouseEvent e) {
        this.isWithinClickThreshold = false;
    }

    public void handleMouseDragged(MouseEvent e) {
        int dy;
        int dx;
        if (this.isWithinClickThreshold && (float)((dx = e.getX() - this.mousePressedEvent.getX()) * dx + (dy = e.getY() - this.mousePressedEvent.getY()) * dy) > this.clickThreshold * this.clickThreshold) {
            this.handleMouseDraggedOutsideOfClickThreshold(e);
        }
    }

    public ActionOperation getLeftButtonPressOperation() {
        return this.leftButtonPressOperation;
    }

    public void setLeftButtonPressOperation(ActionOperation leftButtonPressOperation) {
        this.leftButtonPressOperation = leftButtonPressOperation;
    }

    public ActionOperation getLeftButtonDoubleClickOperation() {
        return this.leftButtonDoubleClickOperation;
    }

    public void setLeftButtonDoubleClickOperation(ActionOperation leftButtonDoubleClickOperation) {
        this.leftButtonDoubleClickOperation = leftButtonDoubleClickOperation;
    }

    public ActionOperation getPopupOperation() {
        return this.popupOperation;
    }

    public void setPopupOperation(ActionOperation popupOperation) {
        this.popupOperation = popupOperation;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        if (this.isActive != isActive) {
            this.isActive = isActive;
            this.repaint();
        }
    }

    protected boolean isPressed() {
        return this.isPressed;
    }

    public void setPressed(boolean isPressed) {
        if (this.isPressed != isPressed) {
            this.isPressed = isPressed;
            this.repaint();
        }
    }
}

