/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.awt.MouseFocusEventQueue;
import edu.cmu.cs.dennisc.awt.event.MouseEventUtilities;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.swing.SwingUtilities;
import edu.cmu.cs.dennisc.zoot.AbstractContext;
import edu.cmu.cs.dennisc.zoot.DragAndDropContext;
import edu.cmu.cs.dennisc.zoot.DragAndDropOperation;
import edu.cmu.cs.dennisc.zoot.DragProxy;
import edu.cmu.cs.dennisc.zoot.DropProxy;
import edu.cmu.cs.dennisc.zoot.DropReceptor;
import edu.cmu.cs.dennisc.zoot.DropReceptorInfo;
import edu.cmu.cs.dennisc.zoot.ZControl;
import edu.cmu.cs.dennisc.zoot.ZManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public abstract class ZDragComponent
extends ZControl {
    private DragAndDropOperation dragAndDropOperation;
    private DragProxy dragProxy = null;
    private DropProxy dropProxy = null;
    private ComponentListener componentAdapter = new ComponentListener(){

        public void componentHidden(ComponentEvent arg0) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            ZDragComponent.this.updateProxySizes();
        }

        public void componentShown(ComponentEvent e) {
        }
    };
    private DefaultDragAndDropContext dragAndDropContext;
    private static boolean isFauxDragDesired = true;
    private boolean isFauxDrag = false;

    public ZDragComponent() {
        this.updateProxySizes();
    }

    public void addNotify() {
        super.addNotify();
        this.addComponentListener(this.componentAdapter);
    }

    public void removeNotify() {
        this.removeComponentListener(this.componentAdapter);
        super.removeNotify();
    }

    protected boolean isMouseListeningDesired() {
        return super.isMouseListeningDesired() || this.dragAndDropOperation != null;
    }

    public Component getSubject() {
        return this;
    }

    public DragAndDropOperation getDragAndDropOperation() {
        return this.dragAndDropOperation;
    }

    public void setDragAndDropOperation(DragAndDropOperation dragAndDropOperation) {
        this.dragAndDropOperation = dragAndDropOperation;
    }

    protected boolean isAlphaDesiredWhenOverDropReceptor() {
        return false;
    }

    private boolean isActuallyPotentiallyDraggable() {
        boolean rv;
        boolean bl = rv = this.dragAndDropOperation != null;
        if (rv) {
            if (this.dragProxy == null) {
                this.dragProxy = new DragProxy(this, this.isAlphaDesiredWhenOverDropReceptor());
            }
            if (this.dropProxy == null) {
                this.dropProxy = new DropProxy(this);
            }
        }
        return rv;
    }

    protected JLayeredPane getLayeredPane() {
        JRootPane rootPane = javax.swing.SwingUtilities.getRootPane(this);
        if (rootPane != null) {
            return rootPane.getLayeredPane();
        }
        throw new RuntimeException("cannot find rootPane: " + this);
    }

    private void updateProxySizes() {
        if (this.isActuallyPotentiallyDraggable()) {
            this.dragProxy.setSize(this.dragProxy.getProxyWidth(), this.dragProxy.getProxyHeight());
            this.dropProxy.setSize(this.dropProxy.getProxyWidth(), this.dropProxy.getProxyHeight());
        }
    }

    private synchronized void updateProxyPosition(MouseEvent e) {
        MouseEvent mousePressedEvent;
        if (this.isActuallyPotentiallyDraggable() && (mousePressedEvent = this.getLeftButtonPressedEvent()) != null) {
            JLayeredPane layeredPane = this.getLayeredPane();
            Point locationOnScreenLayeredPane = layeredPane.getLocationOnScreen();
            Point locationOnScreen = this.getLocationOnScreen();
            int dx = locationOnScreen.x - locationOnScreenLayeredPane.x;
            int dy = locationOnScreen.y - locationOnScreenLayeredPane.y;
            boolean isCopyDesired = SwingUtilities.isQuoteControlUnquoteDown(e);
            int x = e.getX() + (dx -= mousePressedEvent.getX());
            int y = e.getY() + (dy -= mousePressedEvent.getY());
            this.dragProxy.setCopyDesired(isCopyDesired);
            this.dragProxy.setLocation(x, y);
            this.dropProxy.setCopyDesired(isCopyDesired);
        }
    }

    private void handleLeftMouseDraggedOutsideOfClickThreshold(MouseEvent e) {
        ZManager.setDragInProgress(true);
        this.updateProxySizes();
        this.updateProxyPosition(e);
        JLayeredPane layeredPane = this.getLayeredPane();
        layeredPane.add((Component)this.dragProxy, new Integer(1));
        layeredPane.setLayer(this.dragProxy, JLayeredPane.DRAG_LAYER);
        this.dragAndDropContext = new DefaultDragAndDropContext(this.dragAndDropOperation, this.getLeftButtonPressedEvent(), e, this.dragAndDropOperation.createListOfPotentialDropReceptors(this));
        if (this.dragAndDropOperation != null) {
            this.dragAndDropOperation.handleDragStarted(this.dragAndDropContext);
        }
    }

    private void handleLeftMouseDragged(MouseEvent e) {
        if (ZManager.isDragInProgress()) {
            this.updateProxyPosition(e);
            if (this.dragAndDropOperation != null) {
                this.dragAndDropContext.handleMouseDragged(e);
            }
        }
    }

    protected void handleMouseDraggedOutsideOfClickThreshold(MouseEvent e) {
        super.handleMouseDraggedOutsideOfClickThreshold(e);
        if (this.isActuallyPotentiallyDraggable() && MouseEventUtilities.isQuoteLeftUnquoteMouseButton(e)) {
            this.handleLeftMouseDraggedOutsideOfClickThreshold(e);
        }
    }

    public void handleMouseDragged(MouseEvent e) {
        super.handleMouseDragged(e);
        if (this.isActuallyPotentiallyDraggable() && MouseEventUtilities.isQuoteLeftUnquoteMouseButton(e) && !this.isWithinClickThreshold()) {
            this.handleLeftMouseDragged(e);
        }
    }

    public void handleMouseMoved(MouseEvent e) {
        super.handleMouseMoved(e);
        if (this.isActuallyPotentiallyDraggable() && this.isFauxDrag) {
            if (!ZManager.isDragInProgress()) {
                this.handleLeftMouseDraggedOutsideOfClickThreshold(e);
            }
            this.handleLeftMouseDragged(e);
        }
    }

    protected boolean isClickReservedForSelection() {
        return false;
    }

    public static boolean isFauxDragDesired() {
        return isFauxDragDesired;
    }

    public static void setFauxDragDesired(boolean isFauxDragDesired) {
        ZDragComponent.isFauxDragDesired = isFauxDragDesired;
    }

    public void handleMousePressed(MouseEvent e) {
        super.handleMousePressed(e);
        if (MouseEventUtilities.isQuoteRightUnquoteMouseButton(e) && ZManager.isDragInProgress()) {
            this.handleCancel(e);
        }
    }

    public void handleMouseReleased(MouseEvent e) {
        if (this.isActuallyPotentiallyDraggable() && MouseEventUtilities.isQuoteLeftUnquoteMouseButton(e)) {
            boolean isDrop;
            if (this.isWithinClickThreshold()) {
                if (isFauxDragDesired && !this.isClickReservedForSelection()) {
                    ZDragComponent focusedComponent = this.isFauxDrag ? null : this;
                    isDrop = this.isFauxDrag;
                    this.isFauxDrag = !this.isFauxDrag;
                    MouseFocusEventQueue.getSingleton().setComponentWithMouseFocus(focusedComponent);
                } else {
                    isDrop = false;
                }
            } else {
                isDrop = true;
            }
            if (isDrop) {
                ZManager.setDragInProgress(false);
                this.setActive(this.contains(e.getPoint()));
                JLayeredPane layeredPane = this.getLayeredPane();
                Rectangle bounds = this.dragProxy.getBounds();
                layeredPane.remove(this.dragProxy);
                layeredPane.repaint(bounds);
                if (this.dragAndDropContext != null) {
                    this.dragAndDropContext.handleMouseReleased(e);
                }
            }
        }
    }

    public void setDropProxyLocationAndShowIfNecessary(Point p, Component asSeenBy, Integer heightToAlignLeftCenterOn) {
        JLayeredPane layeredPane = this.getLayeredPane();
        p = javax.swing.SwingUtilities.convertPoint(asSeenBy, p, layeredPane);
        if (heightToAlignLeftCenterOn != null) {
            Rectangle dropBounds = this.dropProxy.getBounds();
            p.y += (heightToAlignLeftCenterOn - dropBounds.height) / 2;
        }
        this.dropProxy.setLocation(p);
        if (this.dropProxy.getParent() == null) {
            layeredPane.add((Component)this.dropProxy, new Integer(1));
            layeredPane.setLayer(this.dropProxy, JLayeredPane.DEFAULT_LAYER);
        }
    }

    public void hideDropProxyIfNecessary() {
        JLayeredPane layeredPane = this.getLayeredPane();
        if (this.dropProxy.getParent() != null) {
            Rectangle bounds = this.dropProxy.getBounds();
            if (layeredPane != null) {
                layeredPane.remove(this.dropProxy);
                layeredPane.repaint(bounds);
            } else {
                PrintUtilities.println("WARNING: hideDropProxyIfNecessary, layeredPane is null");
            }
        }
    }

    public void handleCancel(EventObject e) {
        ZManager.setDragInProgress(false);
        this.setActive(false);
        JLayeredPane layeredPane = this.getLayeredPane();
        if (layeredPane != null) {
            Rectangle bounds = this.dragProxy.getBounds();
            layeredPane.remove(this.dragProxy);
            layeredPane.repaint(bounds);
        }
        if (this.dragAndDropContext != null) {
            this.dragAndDropContext.handleCancel(e);
        }
        this.isFauxDrag = false;
        MouseFocusEventQueue.getSingleton().setComponentWithMouseFocus(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultDragAndDropContext
    extends AbstractContext<DragAndDropOperation>
    implements DragAndDropContext {
        private DropReceptorInfo[] potentialDropReceptorInfos;
        private DropReceptor currentDropReceptor;
        private MouseEvent latestMouseEvent;

        public DefaultDragAndDropContext(DragAndDropOperation operation, MouseEvent originalMouseEvent, MouseEvent latestMouseEvent, List<? extends DropReceptor> potentialDropReceptors) {
            super(operation, originalMouseEvent, true);
            this.potentialDropReceptorInfos = new DropReceptorInfo[0];
            this.setLatestMouseEvent(latestMouseEvent);
            this.potentialDropReceptorInfos = new DropReceptorInfo[potentialDropReceptors.size()];
            int i = 0;
            for (DropReceptor dropReceptor : potentialDropReceptors) {
                Component dropComponent = dropReceptor.getAWTComponent();
                Rectangle bounds = dropComponent.getBounds();
                bounds = javax.swing.SwingUtilities.convertRectangle(dropComponent.getParent(), bounds, this.getDragSource());
                this.potentialDropReceptorInfos[i] = new DropReceptorInfo(dropReceptor, bounds);
                ++i;
            }
            for (DropReceptorInfo dropReceptorInfo : this.potentialDropReceptorInfos) {
                dropReceptorInfo.getDropReceptor().dragStarted(this);
            }
        }

        @Override
        public MouseEvent getOriginalMouseEvent() {
            return (MouseEvent)this.getEvent();
        }

        @Override
        public MouseEvent getLatestMouseEvent() {
            return this.latestMouseEvent;
        }

        public void setLatestMouseEvent(MouseEvent latestMouseEvent) {
            this.latestMouseEvent = latestMouseEvent;
        }

        @Override
        public ZDragComponent getDragSource() {
            EventObject e = this.getEvent();
            if (e != null) {
                return (ZDragComponent)e.getSource();
            }
            return null;
        }

        @Override
        public DropReceptor getCurrentDropReceptor() {
            return this.currentDropReceptor;
        }

        public void setCurrentDropReceptor(DropReceptor currentDropReceptor) {
            this.currentDropReceptor = currentDropReceptor;
        }

        private DropReceptor getDropReceptorUnder(int x, int y) {
            DropReceptor rv = null;
            int prevHeight = Integer.MAX_VALUE;
            for (DropReceptorInfo dropReceptorInfo : this.potentialDropReceptorInfos) {
                assert (dropReceptorInfo != null);
                if (!dropReceptorInfo.contains(x, y)) continue;
                Rectangle bounds = dropReceptorInfo.getBounds();
                assert (bounds != null);
                int nextHeight = bounds.height;
                if (nextHeight >= prevHeight) continue;
                rv = dropReceptorInfo.getDropReceptor();
                prevHeight = nextHeight;
            }
            return rv;
        }

        private DropReceptor getDropReceptorUnder(Rectangle bounds) {
            DropReceptor rv = null;
            int prevHeight = Integer.MAX_VALUE;
            for (DropReceptorInfo dropReceptorInfo : this.potentialDropReceptorInfos) {
                int nextHeight;
                if (!dropReceptorInfo.intersects(bounds) || (nextHeight = dropReceptorInfo.getBounds().height) >= prevHeight) continue;
                rv = dropReceptorInfo.getDropReceptor();
                prevHeight = nextHeight;
            }
            return rv;
        }

        protected DropReceptor getDropReceptorUnder(MouseEvent e) {
            DropReceptor rv = this.getDropReceptorUnder(e.getX(), e.getY());
            if (rv == null && ZDragComponent.this.dragProxy != null) {
                Rectangle dragBounds = ZDragComponent.this.dragProxy.getBounds();
                dragBounds = javax.swing.SwingUtilities.convertRectangle(ZDragComponent.this.dragProxy.getParent(), dragBounds, this.getDragSource());
                int x = dragBounds.x;
                int y = dragBounds.y + dragBounds.height / 2;
                rv = this.getDropReceptorUnder(x, y);
                if (rv == null) {
                    rv = this.getDropReceptorUnder(dragBounds);
                }
            }
            return rv;
        }

        public void handleMouseDragged(MouseEvent e) {
            this.setLatestMouseEvent(e);
            DropReceptor nextDropReceptor = this.getDropReceptorUnder(e);
            if (this.currentDropReceptor != nextDropReceptor) {
                if (this.currentDropReceptor != null) {
                    ZDragComponent.this.dragAndDropOperation.handleDragExitedDropReceptor(this);
                    this.currentDropReceptor.dragExited(this, false);
                }
                this.currentDropReceptor = nextDropReceptor;
                if (this.currentDropReceptor != null) {
                    this.currentDropReceptor.dragEntered(this);
                    ZDragComponent.this.dragAndDropOperation.handleDragEnteredDropReceptor(this);
                }
            }
            if (ZDragComponent.this.dragProxy != null) {
                ZDragComponent.this.dragProxy.setOverDropAcceptor(this.currentDropReceptor != null);
            }
            if (this.currentDropReceptor != null) {
                this.currentDropReceptor.dragUpdated(this);
            }
        }

        public void handleMouseReleased(MouseEvent e) {
            this.setLatestMouseEvent(e);
            if (this.currentDropReceptor != null) {
                this.currentDropReceptor.dragDropped(this);
                this.currentDropReceptor.dragExited(this, true);
            }
            for (DropReceptorInfo dropReceptorInfo : this.potentialDropReceptorInfos) {
                dropReceptorInfo.getDropReceptor().dragStopped(this);
            }
            ZDragComponent.this.dragAndDropOperation.handleDragStopped(this);
            this.potentialDropReceptorInfos = new DropReceptorInfo[0];
        }

        public void handleCancel(EventObject e) {
            if (this.currentDropReceptor != null) {
                this.currentDropReceptor.dragExited(this, false);
            }
            for (DropReceptorInfo dropReceptorInfo : this.potentialDropReceptorInfos) {
                dropReceptorInfo.getDropReceptor().dragStopped(this);
            }
            ZDragComponent.this.dragAndDropOperation.handleDragStopped(this);
            this.potentialDropReceptorInfos = new DropReceptorInfo[0];
            ZDragComponent.this.hideDropProxyIfNecessary();
        }
    }
}

