/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.zoot.ActionOperation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

class ZHyperlink
extends AbstractButton {
    private static Map<String, View> map = new HashMap<String, View>();
    private ActionOperation actionOperation;
    private MouseAdapter mouseAdapter = new MouseAdapter();
    private Color activeColor = Color.BLUE;
    private Color pressedColor = Color.BLUE.darker();

    private static View createHTMLView(ZHyperlink hyperlink, Color color) {
        String name = (String)hyperlink.getAction().getValue("Name");
        String text = "<html><font color=\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"><u><b>" + name + "</b></u></font></html>";
        View rv = map.get(text);
        if (rv == null) {
            rv = BasicHTML.createHTMLView(hyperlink, text);
            map.put(text, rv);
        }
        return rv;
    }

    public ZHyperlink(ActionOperation actionOperation) {
        this.actionOperation = actionOperation;
        this.setModel(new DefaultButtonModel());
        Action action = this.actionOperation.getActionForConfiguringSwing();
        this.setAction(action);
        this.setToolTipText((String)action.getValue("LongDescription"));
    }

    protected ActionOperation getActionOperation() {
        return this.actionOperation;
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this.mouseAdapter);
    }

    public void removeNotify() {
        this.removeMouseListener(this.mouseAdapter);
        super.removeNotify();
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public void setActiveColor(Color activeColor) {
        this.activeColor = activeColor;
        this.repaint();
    }

    public Color getPressedColor() {
        return this.pressedColor;
    }

    public void setPressedColor(Color pressedColor) {
        this.pressedColor = pressedColor;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        View view = ZHyperlink.createHTMLView(this, Color.BLACK);
        float width = view.getPreferredSpan(0);
        float height = view.getPreferredSpan(1);
        return new Dimension((int)width + 1, (int)height + 1);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color color = this.model.isArmed() ? (this.model.isPressed() ? this.getPressedColor() : this.getActiveColor()) : this.getForeground();
        View view = ZHyperlink.createHTMLView(this, color);
        view.paint(g, g.getClipBounds());
    }

    class MouseAdapter
    implements MouseListener {
        MouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            ZHyperlink.this.model.setArmed(true);
            ZHyperlink.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            ZHyperlink.this.model.setArmed(false);
            ZHyperlink.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            ZHyperlink.this.model.setPressed(true);
            ZHyperlink.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            ZHyperlink.this.model.setPressed(false);
            ZHyperlink.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
        }
    }
}

