/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.alice.interact.AbstractDragAdapter;
import org.alice.interact.ModifierMask;
import org.alice.interact.PickHint;
import org.alice.interact.condition.ManipulatorConditionSet;
import org.alice.interact.condition.MouseDragCondition;
import org.alice.interact.condition.PickCondition;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.event.ManipulationEventCriteria;
import org.alice.interact.handle.ManipulationHandle2DCameraDriver;
import org.alice.interact.handle.ManipulationHandle2DCameraStrafe;
import org.alice.interact.handle.ManipulationHandle2DCameraTurnUpDown;
import org.alice.interact.manipulator.CameraDragDriveManipulator;
import org.alice.interact.manipulator.CameraDragStrafeManipulator;
import org.alice.interact.manipulator.CameraDragUpDownRotateManipulator;

public class CameraNavigatorWidget
extends JPanel {
    AbstractDragAdapter dragAdapter;
    ManipulationHandle2DCameraDriver cameraDriver;
    ManipulationHandle2DCameraTurnUpDown cameraControlUpDown;
    ManipulationHandle2DCameraStrafe cameraControlStrafe;

    public CameraNavigatorWidget(AbstractDragAdapter dragAdapter) {
        this.setLayout(new BoxLayout(this, 2));
        this.setOpaque(false);
        this.dragAdapter = dragAdapter;
        this.cameraControlUpDown = new ManipulationHandle2DCameraTurnUpDown();
        CameraDragUpDownRotateManipulator upDownManipulator = new CameraDragUpDownRotateManipulator(this.cameraControlUpDown);
        this.cameraControlUpDown.setManipulation(upDownManipulator);
        for (ManipulationEvent event : upDownManipulator.getManipulationEvents()) {
            this.cameraControlUpDown.addCondition(new ManipulationEventCriteria(event.getType(), event.getMovementDescription(), PickHint.CAMERA));
        }
        this.cameraControlUpDown.setDragAdapter(this.dragAdapter);
        this.dragAdapter.addManipulationListener(this.cameraControlUpDown);
        this.cameraControlStrafe = new ManipulationHandle2DCameraStrafe();
        CameraDragStrafeManipulator strafeManipulator = new CameraDragStrafeManipulator(this.cameraControlStrafe);
        this.cameraControlStrafe.setManipulation(strafeManipulator);
        for (ManipulationEvent event : strafeManipulator.getManipulationEvents()) {
            this.cameraControlStrafe.addCondition(new ManipulationEventCriteria(event.getType(), event.getMovementDescription(), PickHint.CAMERA));
        }
        this.dragAdapter.addManipulationListener(this.cameraControlStrafe);
        this.cameraControlStrafe.setDragAdapter(this.dragAdapter);
        this.cameraDriver = new ManipulationHandle2DCameraDriver();
        CameraDragDriveManipulator driverManipulator = new CameraDragDriveManipulator(this.cameraDriver);
        this.cameraDriver.setManipulation(driverManipulator);
        for (ManipulationEvent event : driverManipulator.getManipulationEvents()) {
            this.cameraDriver.addCondition(new ManipulationEventCriteria(event.getType(), event.getMovementDescription(), PickHint.CAMERA));
        }
        this.dragAdapter.addManipulationListener(this.cameraDriver);
        driverManipulator.setDragAdapter(this.dragAdapter);
        ManipulatorConditionSet mouseHandleDrag_NoShift = new ManipulatorConditionSet(driverManipulator);
        MouseDragCondition handleNoShiftCondition = new MouseDragCondition(1, new PickCondition(PickHint.MULTIMODE_HANDLES), new ModifierMask(ModifierMask.ModifierKey.NOT_SHIFT));
        mouseHandleDrag_NoShift.addCondition(handleNoShiftCondition);
        this.dragAdapter.addManipulator(mouseHandleDrag_NoShift);
        strafeManipulator.setDragAdapter(this.dragAdapter);
        ManipulatorConditionSet mouseHandleDrag_Shift = new ManipulatorConditionSet(strafeManipulator);
        MouseDragCondition handleShiftCondition = new MouseDragCondition(1, new PickCondition(PickHint.MULTIMODE_HANDLES), new ModifierMask(ModifierMask.ModifierKey.SHIFT));
        mouseHandleDrag_Shift.addCondition(handleShiftCondition);
        this.dragAdapter.addManipulator(mouseHandleDrag_Shift);
        this.cameraDriver.setDragAdapter(this.dragAdapter);
        this.add(this.cameraControlStrafe);
        this.add(this.cameraDriver);
        this.add(this.cameraControlUpDown);
    }

    public void setExpanded(boolean isExpanded) {
        this.cameraControlUpDown.setVisible(isExpanded);
        this.cameraControlStrafe.setVisible(isExpanded);
    }
}

