/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import org.alice.interact.TargetBasedAnimation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DoubleTargetBasedAnimation
extends TargetBasedAnimation<Double> {
    public DoubleTargetBasedAnimation(Double currentValue) {
        super(currentValue);
    }

    public DoubleTargetBasedAnimation(Double currentValue, double speed) {
        super(currentValue, speed);
    }

    public DoubleTargetBasedAnimation(Double currentValue, Double targetValue) {
        super(currentValue, targetValue);
    }

    public DoubleTargetBasedAnimation(Double currentValue, Double targetValue, double speed) {
        super(currentValue, targetValue, speed);
        if (((Double)this.currentValue).isNaN()) {
            this.currentValue = new Double(0.0);
        }
        if (((Double)this.targetValue).isNaN()) {
            this.targetValue = new Double(0.0);
        }
    }

    @Override
    protected double getDistanceToDone() {
        return Math.abs((Double)this.currentValue - (Double)this.targetValue);
    }

    @Override
    public boolean isDone() {
        return ((Double)this.currentValue).equals(this.targetValue);
    }

    @Override
    protected Double interpolate(Double v0, Double v1, double deltaSinceLastUpdate) {
        double newValue = v0 + (v1 - v0) * this.speed * deltaSinceLastUpdate;
        return new Double(newValue);
    }

    @Override
    protected Double newE(Double other) {
        return new Double(other);
    }
}

