/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.lookingglass.PickResult;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import org.alice.interact.PickHint;
import org.alice.interact.condition.PickCondition;
import org.alice.interact.handle.ManipulationHandle;

public class InputState {
    private Point currentMouseLocation = new Point();
    private HashMap<Integer, Boolean> currentKeysToStatesMap = new HashMap();
    private HashMap<Integer, Boolean> currentMouseButtonsToStatesMap = new HashMap();
    private int currentMouseWheelState = 0;
    private InputEventType currentInputEventType = InputEventType.NULL_EVENT;
    private PickResult clickPickResult = null;
    private PickResult rolloverPickResult = null;
    private Transformable rolloverPickTransformable = null;
    private Transformable clickPickTransformable = null;
    private Transformable currentlySelectedObject = null;
    private ManipulationHandle clickHandle = null;
    private ManipulationHandle rolloverHandle = null;

    public ManipulationHandle getRolloverHandle() {
        return this.rolloverHandle;
    }

    public void setRolloverHandle(ManipulationHandle rolloverHandle) {
        this.rolloverHandle = rolloverHandle;
    }

    public ManipulationHandle getClickHandle() {
        return this.clickHandle;
    }

    public void setClickHandle(ManipulationHandle clickHandle) {
        this.clickHandle = clickHandle;
    }

    public Transformable getCurrentlySelectedObject() {
        return this.currentlySelectedObject;
    }

    public void setCurrentlySelectedObject(Transformable currentlySelectedObject) {
        this.currentlySelectedObject = currentlySelectedObject;
    }

    public boolean isKeyDown(int keyIndex) {
        if (this.currentKeysToStatesMap.containsKey(keyIndex)) {
            return this.currentKeysToStatesMap.get(keyIndex);
        }
        return false;
    }

    public void setKeyState(int keyIndex, boolean isDown) {
        this.currentKeysToStatesMap.put(keyIndex, new Boolean(isDown));
    }

    public void setMouseState(int mouseButton, boolean isDown) {
        Integer mouseInt = new Integer(mouseButton);
        this.currentMouseButtonsToStatesMap.put(mouseInt, new Boolean(isDown));
    }

    public boolean isAnyMouseButtonDown() {
        for (Integer key : this.currentMouseButtonsToStatesMap.keySet()) {
            if (!this.currentMouseButtonsToStatesMap.get(key).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isMouseDown(int mouseButton) {
        if (this.currentMouseButtonsToStatesMap.containsKey(mouseButton)) {
            return this.currentMouseButtonsToStatesMap.get(mouseButton);
        }
        return false;
    }

    public void setMouseWheelState(int mouseWheelMovement) {
        this.currentMouseWheelState = mouseWheelMovement;
    }

    public int getMouseWheelState() {
        return this.currentMouseWheelState;
    }

    public void setMouseLocation(Point mouseLocation) {
        this.currentMouseLocation = mouseLocation;
    }

    public Point getMouseLocation() {
        return this.currentMouseLocation;
    }

    public void setInputEventType(InputEventType eventType) {
        this.currentInputEventType = eventType;
    }

    public InputEventType getInputEventType() {
        return this.currentInputEventType;
    }

    public void setClickPickResult(PickResult pickResult) {
        this.clickPickResult = pickResult;
        Transformable picked = this.getClickPickedTransformable(true);
        PickHint clickedObjectType = PickCondition.getPickType(this.clickPickResult);
        if (!clickedObjectType.intersects(PickHint.NOTHING)) {
            this.setClickPickTransformable(picked);
        } else {
            this.setClickPickTransformable(null);
        }
        this.clickHandle = picked instanceof ManipulationHandle ? (ManipulationHandle)((Object)picked) : null;
    }

    public PickResult getClickPickResult() {
        return this.clickPickResult;
    }

    public PickResult getRolloverPickResult() {
        return this.rolloverPickResult;
    }

    public void setRolloverPickResult(PickResult rolloverPickResult) {
        ManipulationHandle handle;
        this.rolloverPickResult = rolloverPickResult;
        Transformable picked = this.getRolloverPickedTransformable(true);
        boolean validPick = true;
        if (picked instanceof ManipulationHandle && !(handle = (ManipulationHandle)((Object)picked)).isPickable()) {
            validPick = false;
        }
        PickHint rolloverObjectType = PickCondition.getPickType(this.rolloverPickResult);
        if (validPick && !rolloverObjectType.intersects(PickHint.NOTHING)) {
            this.setRolloverPickTransformable(picked);
        } else {
            this.setRolloverPickTransformable(null);
        }
        this.rolloverHandle = validPick && picked instanceof ManipulationHandle ? (ManipulationHandle)((Object)picked) : null;
    }

    public Transformable getRolloverPickTransformable() {
        return this.rolloverPickTransformable;
    }

    public void setRolloverPickTransformable(Transformable rolloverPickTransformable) {
        this.rolloverPickTransformable = rolloverPickTransformable;
    }

    public Transformable getClickPickTransformable() {
        return this.clickPickTransformable;
    }

    public void setClickPickTransformable(Transformable clickPickTransformable) {
        this.clickPickTransformable = clickPickTransformable;
    }

    protected Component getFirstClassFromComponent(Component object) {
        if (object == null) {
            return null;
        }
        Object bonusData = object.getBonusDataFor("PICK_HINT_KEY");
        if (bonusData instanceof PickHint) {
            return object;
        }
        return this.getFirstClassFromComponent(object.getParent());
    }

    protected Transformable getPickedTransformable(PickResult pickResult, boolean getFirstClass) {
        Composite sgParent;
        Visual sgVisual;
        if (pickResult != null && (sgVisual = pickResult.getVisual()) != null && (sgParent = sgVisual.getParent()) instanceof Transformable) {
            if (getFirstClass) {
                Component firstClassComponent = this.getFirstClassFromComponent(sgParent);
                if (firstClassComponent instanceof Transformable) {
                    return (Transformable)firstClassComponent;
                }
            } else {
                return (Transformable)sgParent;
            }
        }
        return null;
    }

    public Transformable getClickPickedTransformable(boolean getFirstClassObject) {
        return this.getPickedTransformable(this.clickPickResult, getFirstClassObject);
    }

    public Transformable getRolloverPickedTransformable(boolean getFirstClassObject) {
        return this.getPickedTransformable(this.rolloverPickResult, getFirstClassObject);
    }

    public void copyState(InputState sourceState) {
        this.currentKeysToStatesMap = (HashMap)sourceState.currentKeysToStatesMap.clone();
        this.currentMouseButtonsToStatesMap = (HashMap)sourceState.currentMouseButtonsToStatesMap.clone();
        this.currentMouseLocation.setLocation(sourceState.currentMouseLocation);
        this.currentMouseWheelState = sourceState.currentMouseWheelState;
        this.currentInputEventType = sourceState.currentInputEventType;
        this.clickPickResult = sourceState.clickPickResult;
        this.clickPickTransformable = sourceState.clickPickTransformable;
        this.currentlySelectedObject = sourceState.currentlySelectedObject;
        this.rolloverPickTransformable = sourceState.rolloverPickTransformable;
        this.rolloverPickResult = sourceState.rolloverPickResult;
        this.rolloverHandle = sourceState.rolloverHandle;
        this.clickHandle = sourceState.clickHandle;
    }

    public String toString() {
        String mouseButtonState = "";
        String keyState = "";
        boolean isFirst = true;
        Object[] keyKeys = this.currentKeysToStatesMap.keySet().toArray();
        for (int i = 0; i < keyKeys.length; ++i) {
            if (!this.currentKeysToStatesMap.get(keyKeys[i]).booleanValue()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                keyState = keyState + ", ";
            }
            keyState = keyState + KeyEvent.getKeyText((Integer)keyKeys[i]);
        }
        isFirst = true;
        Object[] mouseKeys = this.currentMouseButtonsToStatesMap.keySet().toArray();
        for (int i = 0; i < mouseKeys.length; ++i) {
            if (!this.currentMouseButtonsToStatesMap.get(mouseKeys[i]).booleanValue()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                mouseButtonState = mouseButtonState + ", ";
            }
            mouseButtonState = mouseButtonState + "button " + mouseKeys[i];
        }
        return "Event Type: " + (Object)((Object)this.currentInputEventType) + "\nKeys: " + keyState + "\nMouse Buttons: " + mouseButtonState + "\nMouse Wheel: " + this.currentMouseWheelState + "\nMouse Location: " + this.currentMouseLocation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InputEventType {
        MOUSE_WHEEL,
        MOUSE_DOWN,
        MOUSE_UP,
        MOUSE_DRAGGED,
        KEY_DOWN,
        KEY_UP,
        NULL_EVENT;

    }
}

